/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.diagram.DiagramContainer;
import org.teiid.designer.metamodels.transformation.TransformationContainer;

public class CompareUtil {
    private CompareUtil() {
    }

    public static void skipChangesFromDefault(DifferenceReport report) {
        Mapping rootMapping = report.getMapping();
        if (rootMapping != null) {
            CompareUtil.skipChangesFromDefault(rootMapping, true);
        }
    }

    public static int skipChangesFromDefault(Mapping differenceNode, boolean recursive) {
        int count = 0;
        DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor(differenceNode);
        if (desc != null) {
            count += CompareUtil.skipChangesFromDefault(desc);
        }
        if (recursive) {
            for (Mapping nestedNode : differenceNode.getNested()) {
                count += CompareUtil.skipChangesFromDefault(nestedNode, recursive);
            }
        }
        return count;
    }

    public static int skipChangesFromDefault(DifferenceDescriptor differenceDescriptor) {
        DifferenceType diffType = differenceDescriptor.getType();
        if (diffType.getValue() == 1) {
            return 0;
        }
        if (diffType.getValue() == 2) {
            return 0;
        }
        int count = 0;
        EList propertyDifferences = differenceDescriptor.getPropertyDifferences();
        for (PropertyDifference propDiff : propertyDifferences) {
            if (propDiff.isSkip()) continue;
            EStructuralFeature feature = propDiff.getAffectedFeature();
            Object featureDefaultValue = feature.getDefaultValue();
            if (featureDefaultValue != null) {
                Object newValue = propDiff.getNewValue();
                if (!featureDefaultValue.equals(newValue)) continue;
                propDiff.setSkip(true);
                ++count;
                continue;
            }
            if (propDiff.getNewValue() != null || propDiff.getOldValue() == null) continue;
            propDiff.setSkip(true);
            ++count;
        }
        return count;
    }

    public static DifferenceDescriptor getDifferenceDescriptor(Mapping mappingNode) {
        MappingHelper helper = mappingNode.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            return (DifferenceDescriptor)helper;
        }
        return null;
    }

    public static boolean hasInstanceof(Mapping mappingNode, Class c) {
        for (Object obj : mappingNode.getInputs()) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        for (Object obj : mappingNode.getOutputs()) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static int skipUnchangeableFeatures(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        int count = 0;
        EList nestedMappings = rootMapping.getNested();
        for (Mapping nestedMapping : nestedMappings) {
            count += CompareUtil.skipUnchangeableFeatures(nestedMapping, true);
        }
        return count;
    }

    public static int skipUnchangeableFeatures(Mapping differenceNode, boolean recursive) {
        int count = 0;
        DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor(differenceNode);
        if (desc != null && !desc.isSkip()) {
            int type = desc.getType().getValue();
            switch (type) {
                case 1: 
                case 2: {
                    EList inputs = differenceNode.getInputs();
                    EList outputs = differenceNode.getOutputs();
                    EObject input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                    EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
                    EObject obj = input != null ? input : output;
                    EObject parent = obj.eContainer();
                    if (parent == null) break;
                    EClass parentEClass = parent.eClass();
                    for (EReference ref : parentEClass.getEAllContainments()) {
                        if (ref.isChangeable()) continue;
                        if (ref.isMany()) {
                            List values = (List)parent.eGet((EStructuralFeature)ref);
                            if (!values.contains(obj)) continue;
                            desc.setSkip(true);
                            ++count;
                            continue;
                        }
                        EObject value = (EObject)parent.eGet((EStructuralFeature)ref);
                        if (!obj.equals(value)) continue;
                        desc.setSkip(true);
                        ++count;
                    }
                    break;
                }
                case 3: {
                    for (PropertyDifference propDiff : desc.getPropertyDifferences()) {
                        EStructuralFeature feature;
                        boolean changeable;
                        if (propDiff.isSkip() || (changeable = (feature = propDiff.getAffectedFeature()).isChangeable()) && (!(feature instanceof EReference) || !((EReference)feature).isContainment())) continue;
                        propDiff.setSkip(true);
                        ++count;
                    }
                    break;
                }
            }
        }
        if (recursive) {
            for (Mapping nestedNode : differenceNode.getNested()) {
                count += CompareUtil.skipUnchangeableFeatures(nestedNode, recursive);
            }
        }
        return count;
    }

    public static void skipDeletesOfStandardContainers(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        for (Mapping nestedMapping : nestedMappings) {
            DifferenceDescriptor desc;
            if (CompareUtil.hasInstanceof(nestedMapping, ModelAnnotation.class)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                if (desc != null && desc.isDeletion()) {
                    desc.setSkip(true);
                }
                CompareUtil.skipChangesFromDefault(nestedMapping, true);
                continue;
            }
            if (CompareUtil.hasInstanceof(nestedMapping, AnnotationContainer.class)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                if (desc == null || !desc.isDeletion()) continue;
                desc.setSkip(true);
                continue;
            }
            if (CompareUtil.hasInstanceof(nestedMapping, TransformationContainer.class)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                desc.setSkip(true);
                continue;
            }
            if (!CompareUtil.hasInstanceof(nestedMapping, DiagramContainer.class)) continue;
            desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
            desc.setSkip(true);
        }
    }

    public static void skipDeletesOfModelImports(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        for (Mapping nestedMapping : nestedMappings) {
            if (!CompareUtil.hasInstanceof(nestedMapping, ModelAnnotation.class)) continue;
            for (Mapping nestedNested : nestedMapping.getNested()) {
                DifferenceDescriptor desc;
                if (!CompareUtil.hasInstanceof(nestedNested, ModelImport.class) || (desc = CompareUtil.getDifferenceDescriptor(nestedMapping)) == null || !desc.isDeletion()) continue;
                desc.setSkip(true);
            }
        }
    }

    public static void print(DifferenceReport report, PrintStream stream) {
        CompareUtil.print(report, stream, false);
    }

    public static void print(DifferenceReport report, PrintStream stream, boolean showSkips) {
        CoreArgCheck.isNotNull((Object)report);
        CoreArgCheck.isNotNull((Object)stream);
        stream.println("");
        if (report.getTitle() != null && report.getTitle().trim().length() != 0) {
            stream.println("DifferenceReport: " + report.getTitle());
        } else {
            stream.println("DifferenceReport");
        }
        CompareUtil.printMapping(report.getMapping(), "   ", stream, showSkips);
    }

    protected static void printMapping(Mapping mapping, String prefix, PrintStream stream, boolean showSkips) {
        String msg = prefix;
        ArrayList<String> submsgs = null;
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (mapping.getNestedIn() == null) {
            msg = String.valueOf(msg) + " Difference Report Root Mapping";
        } else if (inputs.size() == 1 || outputs.size() == 1) {
            EObject input;
            EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
            EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
            if (output != null) {
                msg = String.valueOf(msg) + ModelerCore.getModelEditor().getModelRelativePath(output);
            } else if (input != null) {
                msg = String.valueOf(msg) + ModelerCore.getModelEditor().getModelRelativePath(input);
            }
            MappingHelper helper = mapping.getHelper();
            if (helper != null && helper instanceof DifferenceDescriptor) {
                DifferenceDescriptor desc = (DifferenceDescriptor)helper;
                if (showSkips || !desc.isSkip()) {
                    DifferenceType type = desc.getType();
                    if (type.getValue() == 1) {
                        msg = String.valueOf(msg) + " (Added)";
                    } else if (type.getValue() == 2) {
                        msg = String.valueOf(msg) + " (Deleted)";
                    } else if (type.getValue() == 3) {
                        msg = String.valueOf(msg) + " (Changed)";
                        submsgs = new ArrayList<String>(desc.getPropertyDifferences().size());
                        for (PropertyDifference propDiff : desc.getPropertyDifferences()) {
                            if (!showSkips && propDiff.isSkip()) continue;
                            String featureName = propDiff.getAffectedFeature().getName();
                            if (propDiff.isSkip()) {
                                featureName = String.valueOf(featureName) + " [skip]";
                            }
                            submsgs.add(String.valueOf(featureName) + " changed from " + propDiff.getOldValue());
                            String slot = CompareUtil.getString(' ', featureName.length());
                            submsgs.add(String.valueOf(slot) + "           to " + propDiff.getNewValue());
                        }
                    }
                    if (desc.isSkip()) {
                        msg = String.valueOf(msg) + " [skip]";
                    }
                }
            }
        }
        stream.println(msg);
        if (submsgs != null) {
            for (String submsg : submsgs) {
                stream.println(String.valueOf(prefix) + "    (" + submsg + ")");
            }
        }
        for (Mapping nested : mapping.getNested()) {
            CompareUtil.printMapping(nested, "  " + prefix, stream, showSkips);
        }
    }

    protected static String getString(char c, int length) {
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

