/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.factory;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDContentTypeCategory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.mapping.factory.IMappableTree;
import org.teiid.designer.mapping.factory.ITreeToRelationalMapper;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlChoice;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.factory.XmlMappableTree;

public class XmlFragmentMapper
implements ITreeToRelationalMapper,
PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(XmlFragmentMapper.class);
    private XmlFragment fragment;
    private XmlMappableTree tree;

    public boolean allowsMappingClass(EObject theTreeNode) {
        return theTreeNode instanceof XmlElement || theTreeNode instanceof XmlContainerNode;
    }

    public boolean allowsStagingTable(EObject theTreeNode) {
        return this.allowsMappingClass(theTreeNode);
    }

    public boolean canIterate(EObject theTreeNode) {
        this.checkNodeIsXmlDocumentEntity(theTreeNode);
        int maxOccurs = 0;
        if (theTreeNode instanceof XmlDocumentNode) {
            maxOccurs = XsdUtil.getMaxOccursLiteral((XSDComponent)((XmlDocumentNode)theTreeNode).getXsdComponent());
        } else if (theTreeNode instanceof XmlContainerNode) {
            maxOccurs = XsdUtil.getMaxOccursLiteral((XSDComponent)((XmlContainerNode)theTreeNode).getXsdComponent());
        }
        return maxOccurs > 1 || maxOccurs == -1;
    }

    private void checkNodeIsXmlDocumentEntity(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (!(theTreeNode instanceof XmlDocumentEntity)) {
            throw new IllegalArgumentException(Util.getString(String.valueOf(PREFIX) + "invalidType", new Object[]{"XmlDocumentEntity", theTreeNode.getClass().getName()}));
        }
    }

    public IMappableTree getMappableTree() {
        if (this.tree == null) {
            this.tree = new XmlMappableTree((EObject)this.fragment);
        }
        return this.tree;
    }

    public boolean isContainerNode(EObject theTreeNode) {
        return theTreeNode instanceof XmlContainerNode;
    }

    public boolean isMappable(EObject theTreeNode) {
        this.checkNodeIsXmlDocumentEntity(theTreeNode);
        if (theTreeNode instanceof XmlAttribute) {
            return this.isMappable((XmlAttribute)theTreeNode);
        }
        if (theTreeNode instanceof XmlElement) {
            return this.isMappable((XmlElement)theTreeNode);
        }
        return false;
    }

    public boolean isMappable(XmlAttribute attribute) {
        CoreArgCheck.isNotNull((Object)attribute);
        return !attribute.isValueFixed();
    }

    public boolean isMappable(XmlElement element) {
        CoreArgCheck.isNotNull((Object)element);
        XSDComponent schemaComponent = element.getXsdComponent();
        if (schemaComponent != null) {
            return this.isElementMappable(schemaComponent);
        }
        return true;
    }

    public boolean isElementMappable(XSDComponent xsdComponent) {
        CoreArgCheck.isNotNull((Object)xsdComponent);
        if (xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration elementDecl = (XSDElementDeclaration)xsdComponent;
            XSDTypeDefinition type = XsdUtil.getType((XSDElementDeclaration)elementDecl);
            if (type instanceof XSDSimpleTypeDefinition) {
                return true;
            }
            if (type instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
                if (complexType.isMixed()) {
                    return true;
                }
                XSDContentTypeCategory category = complexType.getContentTypeCategory();
                int categoryValue = category.getValue();
                switch (categoryValue) {
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        } else if (xsdComponent instanceof XSDComplexTypeDefinition) {
            return true;
        }
        return false;
    }

    public boolean isMappingRequired(EObject theTreeNode) {
        this.checkNodeIsXmlDocumentEntity(theTreeNode);
        throw new RuntimeException("XmlFragmentMapper.isMappingRequired not yet implemented");
    }

    public boolean isRecursive(EObject theTreeNode) {
        this.checkNodeIsXmlDocumentEntity(theTreeNode);
        return theTreeNode instanceof XmlElement && ((XmlElement)theTreeNode).isRecursive();
    }

    public boolean isTreeRoot(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        return theTreeNode instanceof XmlFragment;
    }

    public void setTreeRoot(EObject theFragment) {
        CoreArgCheck.isNotNull((Object)theFragment);
        this.fragment = (XmlFragment)theFragment;
        ModelContents modelContents = ModelerCore.getModelEditor().getModelContents((EObject)this.fragment);
        modelContents.getTransformations((EObject)this.fragment);
    }

    public boolean isTreeNode(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        return theTreeNode instanceof XmlDocumentNode || this.isTreeRoot(theTreeNode) || theTreeNode instanceof XmlContainerNode;
    }

    public String getPathInDocument(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (theTreeNode instanceof XmlDocumentNode) {
            return ((XmlDocumentNode)theTreeNode).getPathInDocument();
        }
        if (theTreeNode instanceof XmlContainerNode) {
            return ((XmlContainerNode)theTreeNode).getPathInDocument();
        }
        return null;
    }

    public String getXsdQualifiedName(EObject theTreeNode) {
        XSDComponent xsdComponent;
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (theTreeNode instanceof XmlDocumentNode && (xsdComponent = ((XmlDocumentNode)theTreeNode).getXsdComponent()) != null && xsdComponent instanceof XSDNamedComponent) {
            return ((XSDNamedComponent)xsdComponent).getQName();
        }
        return null;
    }

    public String getXsdTargetNamespace(EObject theTreeNode) {
        XSDComponent xsdComponent;
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (theTreeNode instanceof XmlDocumentNode && (xsdComponent = ((XmlDocumentNode)theTreeNode).getXsdComponent()) != null && xsdComponent instanceof XSDNamedComponent) {
            return ((XSDNamedComponent)xsdComponent).getTargetNamespace();
        }
        return null;
    }

    public EObject getXsdComponent(EObject theTreeNode) {
        CoreArgCheck.isNotNull((Object)theTreeNode);
        if (theTreeNode instanceof XmlDocumentNode) {
            XSDComponent xsdComp = ((XmlDocumentNode)theTreeNode).getXsdComponent();
            EObject container = xsdComp.eContainer();
            if (container instanceof XSDParticle || container instanceof XSDAttributeUse) {
                return container;
            }
            return xsdComp;
        }
        if (theTreeNode instanceof XmlContainerNode) {
            return ((XmlContainerNode)theTreeNode).getXsdComponent();
        }
        return null;
    }

    public boolean isChoiceNode(EObject theTreeNode) {
        return theTreeNode instanceof XmlChoice;
    }
}

