/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.Arrays;
import java.util.List;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitorCallback;
import org.teiid.designer.query.sql.lang.ICompareCriteria;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.IDelete;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.IGroupBy;
import org.teiid.designer.query.sql.lang.IInsert;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.ISetCriteria;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.query.sql.lang.IUpdate;
import org.teiid.designer.query.sql.symbol.IAliasSymbol;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.designer.query.sql.symbol.IMultipleElementSymbol;
import org.teiid.designer.query.sql.symbol.IWindowFunction;
import org.teiid.designer.query.sql.symbol.IWindowSpecification;
import org.teiid.query.ui.sqleditor.component.AliasSymbolDisplayNode;
import org.teiid.query.ui.sqleditor.component.CompareCriteriaDisplayNode;
import org.teiid.query.ui.sqleditor.component.CompoundCriteriaDisplayNode;
import org.teiid.query.ui.sqleditor.component.DeleteDisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeVisitor;
import org.teiid.query.ui.sqleditor.component.ElementSymbolDisplayNode;
import org.teiid.query.ui.sqleditor.component.FromDisplayNode;
import org.teiid.query.ui.sqleditor.component.FunctionDisplayNode;
import org.teiid.query.ui.sqleditor.component.GroupByDisplayNode;
import org.teiid.query.ui.sqleditor.component.GroupSymbolDisplayNode;
import org.teiid.query.ui.sqleditor.component.InsertDisplayNode;
import org.teiid.query.ui.sqleditor.component.MatchCriteriaDisplayNode;
import org.teiid.query.ui.sqleditor.component.OrderByDisplayNode;
import org.teiid.query.ui.sqleditor.component.QueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SelectDisplayNode;
import org.teiid.query.ui.sqleditor.component.SeparatorDisplayNode;
import org.teiid.query.ui.sqleditor.component.SetCriteriaDisplayNode;
import org.teiid.query.ui.sqleditor.component.SetQueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SymbolDisplayNode;
import org.teiid.query.ui.sqleditor.component.TextDisplayNode;
import org.teiid.query.ui.sqleditor.component.UnknownDisplayNode;
import org.teiid.query.ui.sqleditor.component.UnknownQueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.UpdateDisplayNode;

public class DisplayNodeFactory {
    private static final String UNDEFINED = "<undefined>";
    private static final String[] SEPARATORS = new String[11];
    private static final List SEPARATOR_WORDS;

    static {
        DisplayNodeFactory.SEPARATORS[0] = " ";
        DisplayNodeFactory.SEPARATORS[1] = " \n";
        DisplayNodeFactory.SEPARATORS[2] = "\n";
        DisplayNodeFactory.SEPARATORS[3] = " \t";
        DisplayNodeFactory.SEPARATORS[4] = "\t";
        DisplayNodeFactory.SEPARATORS[5] = ", ";
        DisplayNodeFactory.SEPARATORS[6] = ",";
        DisplayNodeFactory.SEPARATORS[7] = "(";
        DisplayNodeFactory.SEPARATORS[8] = ")";
        DisplayNodeFactory.SEPARATORS[9] = " (";
        DisplayNodeFactory.SEPARATORS[10] = ") ";
        SEPARATOR_WORDS = Arrays.asList(SEPARATORS);
    }

    static DisplayNode createDisplayNode(DisplayNode parentNode, Object obj, int indentLevel) {
        boolean dontAppend;
        DisplayNode node = DisplayNodeFactory.constructDisplayNode(parentNode, obj);
        boolean bl = dontAppend = obj instanceof IGroupSymbol || obj instanceof IMultipleElementSymbol || obj instanceof IElementSymbol;
        if (obj instanceof ILanguageObject) {
            DisplayNodeVisitor ssv = new DisplayNodeVisitor(node, dontAppend, indentLevel);
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor callbackSQLStringVisitor = queryService.getCallbackSQLStringVisitor((ISQLStringVisitorCallback)ssv);
            ((ILanguageObject)obj).acceptVisitor((ILanguageVisitor)callbackSQLStringVisitor);
        }
        return node;
    }

    public static DisplayNode createDisplayNode(DisplayNode parentNode, Object obj) {
        return DisplayNodeFactory.createDisplayNode(parentNode, obj, 0);
    }

    static DisplayNode constructDisplayNode(DisplayNode parentNode, Object obj) {
        String objText;
        if (obj instanceof IQuery) {
            QueryDisplayNode node = new QueryDisplayNode(parentNode, (IQuery)obj);
            return node;
        }
        if (obj instanceof ISetQuery) {
            SetQueryDisplayNode node = new SetQueryDisplayNode(parentNode, (ISetQuery)obj);
            return node;
        }
        if (obj instanceof IInsert) {
            InsertDisplayNode node = new InsertDisplayNode(parentNode, (IInsert)obj);
            return node;
        }
        if (obj instanceof IUpdate) {
            UpdateDisplayNode node = new UpdateDisplayNode(parentNode, (IUpdate)obj);
            return node;
        }
        if (obj instanceof IDelete) {
            DeleteDisplayNode node = new DeleteDisplayNode(parentNode, (IDelete)obj);
            return node;
        }
        if (obj instanceof ISelect) {
            SelectDisplayNode node = new SelectDisplayNode(parentNode, (ISelect)obj);
            return node;
        }
        if (obj instanceof IFrom) {
            FromDisplayNode node = new FromDisplayNode(parentNode, (IFrom)obj);
            return node;
        }
        if (obj instanceof IGroupBy) {
            GroupByDisplayNode node = new GroupByDisplayNode(parentNode, (IGroupBy)obj);
            return node;
        }
        if (obj instanceof IOrderBy) {
            OrderByDisplayNode node = new OrderByDisplayNode(parentNode, (IOrderBy)obj);
            return node;
        }
        if (parentNode instanceof FunctionDisplayNode && obj instanceof IConstant && ((IConstant)obj).getValue() != null) {
            return new TextDisplayNode(parentNode, obj.toString());
        }
        if (obj instanceof String) {
            String text = (String)obj;
            if (SEPARATOR_WORDS.contains(text)) {
                return new SeparatorDisplayNode(parentNode, text);
            }
            return new TextDisplayNode(parentNode, text);
        }
        if (obj instanceof ICompareCriteria) {
            CompareCriteriaDisplayNode node = new CompareCriteriaDisplayNode(parentNode, (ICompareCriteria)obj);
            return node;
        }
        if (obj instanceof IMatchCriteria) {
            MatchCriteriaDisplayNode node = new MatchCriteriaDisplayNode(parentNode, (IMatchCriteria)obj);
            return node;
        }
        if (obj instanceof ISetCriteria) {
            SetCriteriaDisplayNode node = new SetCriteriaDisplayNode(parentNode, (ISetCriteria)obj);
            return node;
        }
        if (obj instanceof ICompoundCriteria) {
            CompoundCriteriaDisplayNode node = new CompoundCriteriaDisplayNode(parentNode, (ICompoundCriteria)obj);
            return node;
        }
        if (obj instanceof IFunction) {
            FunctionDisplayNode node = new FunctionDisplayNode(parentNode, (IFunction)obj);
            return node;
        }
        if (obj instanceof IWindowFunction || obj instanceof IWindowSpecification) {
            TextDisplayNode node = new TextDisplayNode(parentNode, obj.toString());
            return node;
        }
        if (obj instanceof IAliasSymbol) {
            AliasSymbolDisplayNode node = new AliasSymbolDisplayNode(parentNode, (IAliasSymbol)obj);
            return node;
        }
        if (obj instanceof IElementSymbol) {
            ElementSymbolDisplayNode node = new ElementSymbolDisplayNode(parentNode, (IElementSymbol)obj);
            return node;
        }
        if (obj instanceof IGroupSymbol) {
            GroupSymbolDisplayNode node = new GroupSymbolDisplayNode(parentNode, (IGroupSymbol)obj);
            return node;
        }
        if (obj instanceof IMultipleElementSymbol) {
            SymbolDisplayNode node = new SymbolDisplayNode(parentNode, (ILanguageObject)((IMultipleElementSymbol)obj));
            return node;
        }
        if (obj instanceof ILanguageObject) {
            DisplayNode node = new DisplayNode();
            node.parentNode = parentNode;
            node.languageObject = (ILanguageObject)obj;
            return node;
        }
        String unknownText = UNDEFINED;
        if (obj != null && (objText = obj.toString()).trim().length() > 0) {
            unknownText = objText;
        }
        UnknownDisplayNode node = new UnknownDisplayNode(parentNode, unknownText);
        return node;
    }

    public static DisplayNode createUnknownQueryDisplayNode(DisplayNode parentNode, String name) {
        return new UnknownQueryDisplayNode(parentNode, name);
    }
}

