/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.sqleditor.component.DisplayNodeConstants;

public class DisplayNode
implements DisplayNodeConstants {
    protected int startIndex = 0;
    protected int endIndex = 0;
    protected DisplayNode parentNode = null;
    protected ILanguageObject languageObject = null;
    protected List<DisplayNode> childNodeList = new ArrayList<DisplayNode>(1);
    protected List<DisplayNode> displayNodeList = new ArrayList<DisplayNode>(1);
    private boolean visible = true;

    protected DisplayNode() {
    }

    public DisplayNode getParent() {
        return this.parentNode;
    }

    public ILanguageObject getLanguageObject() {
        return this.languageObject;
    }

    public List<DisplayNode> getChildren() {
        return this.childNodeList;
    }

    public List getDisplayNodeList() {
        return this.displayNodeList;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible, boolean includeDescendents) {
        this.visible = visible;
        if (includeDescendents && this.childNodeList != null) {
            Iterator<DisplayNode> iter = this.childNodeList.iterator();
            while (iter.hasNext()) {
                iter.next().setVisible(visible, includeDescendents);
            }
        }
        if (this.displayNodeList != null) {
            for (DisplayNode node : this.displayNodeList) {
                if (node.parentNode != this) continue;
                node.setVisible(visible, includeDescendents);
            }
        }
    }

    public String toDisplayString() {
        StringBuffer sb = new StringBuffer();
        Iterator<DisplayNode> iter = this.displayNodeList.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toDisplayString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<DisplayNode> iter = this.displayNodeList.iterator();
        while (iter.hasNext()) {
            sb.append(((Object)iter.next()).toString());
        }
        return sb.toString();
    }

    public boolean hasChildren() {
        return this.childNodeList != null && this.childNodeList.size() > 0;
    }

    public boolean hasDisplayNodes() {
        return this.displayNodeList.size() > 0;
    }

    public boolean supportsElement() {
        return false;
    }

    public boolean supportsGroup() {
        return false;
    }

    public boolean supportsExpression() {
        return this.isInExpression();
    }

    public boolean isInExpression() {
        return this.getExpression() != null;
    }

    public DisplayNode getExpression() {
        DisplayNode parentNode = this;
        while (parentNode != null) {
            if (parentNode.languageObject != null && parentNode.languageObject instanceof IExpression) {
                return parentNode;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public boolean supportsCriteria() {
        return this.isInCriteria();
    }

    public boolean isInCriteria() {
        return this.getCriteria() != null;
    }

    public DisplayNode getCriteria() {
        DisplayNode parentNode = this;
        while (parentNode != null) {
            if (parentNode.languageObject instanceof ICriteria) {
                return parentNode;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public int setStartIndex(int index) {
        this.startIndex = index;
        this.endIndex = index;
        Iterator<DisplayNode> iter = this.displayNodeList.iterator();
        DisplayNode node = null;
        if (iter.hasNext()) {
            node = iter.next();
            this.endIndex = node.setStartIndex(this.endIndex);
        }
        this.startIndex = this.endIndex + 1;
        while (iter.hasNext()) {
            node = iter.next();
            this.endIndex = node.setStartIndex(this.startIndex);
            this.startIndex = this.endIndex + 1;
        }
        for (DisplayNode displayNode : this.displayNodeList) {
            this.reindexParents(displayNode);
        }
        return this.endIndex;
    }

    private void reindexParents(DisplayNode node) {
        while (node != null) {
            List childDisplayNodes;
            int nd;
            DisplayNode parentNode = node.getParent();
            if (parentNode != null && (nd = (childDisplayNodes = parentNode.getDisplayNodeList()).size()) != 0) {
                parentNode.startIndex = ((DisplayNode)childDisplayNodes.get(0)).getStartIndex();
                parentNode.endIndex = ((DisplayNode)childDisplayNodes.get(nd - 1)).getEndIndex();
            }
            node = parentNode;
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int length() {
        return this.endIndex - this.startIndex + 1;
    }

    public boolean isIndexAtStart(int index) {
        return index == this.startIndex;
    }

    public boolean isIndexAtEnd(int index) {
        return index == this.endIndex + 1;
    }

    public boolean isAnywhereWithin(int index) {
        return index >= this.startIndex && index <= this.endIndex + 1;
    }

    public boolean isWithin(int index) {
        return index > this.startIndex && index < this.endIndex + 1;
    }

    protected void addChildNode(DisplayNode child) {
        this.childNodeList.add(child);
        this.displayNodeList.add(child);
    }
}

