/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.util;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryParser;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.builder.util.ICriteriaStrategy;

public class CriteriaStrategy
implements ICriteriaStrategy {
    protected static final String INVALID_SELECTION_MSG = UiConstants.Util.getString("CriteriaStrategy.invalidSelectionMsg", new Object[0]);
    protected static final String SUBQUERY_SELECT_STATEMENT = "SELECT {0} FROM {1}";
    protected TreeViewer viewer;
    protected ILabelProvider labelProvider;
    protected ITreeContentProvider contentProvider;

    public CriteriaStrategy() {
    }

    public CriteriaStrategy(TreeViewer treeViewer) {
        this.setTreeViewer(treeViewer);
    }

    private void checkState() {
        if (this.viewer == null || this.labelProvider == null || this.contentProvider == null) {
            throw new IllegalStateException(UiConstants.Util.getString("CriteriaStrategy.invalidStateMsg", new Object[0]));
        }
    }

    @Override
    public ICommand getCommand(Object theNode) {
        this.checkState();
        ICommand result = null;
        if (this.isValid(theNode)) {
            String nodeName = this.getRuntimeFullName(theNode);
            String parentName = this.getRuntimeFullName(this.contentProvider.getParent(theNode));
            String sql = MessageFormat.format(SUBQUERY_SELECT_STATEMENT, nodeName, parentName);
            result = this.parseSql(sql);
        }
        return result;
    }

    @Override
    public String getInvalidMessage(Object theNode) {
        return INVALID_SELECTION_MSG;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    @Override
    public String getRuntimeFullName(Object theNode) {
        Object parent;
        this.checkState();
        String result = this.labelProvider.getText(theNode);
        while ((parent = this.contentProvider.getParent(theNode)) != null) {
            result = String.valueOf(this.labelProvider.getText(parent)) + this.getDelimiterChar() + result;
            theNode = parent;
        }
        return result;
    }

    @Override
    public Object getNode(ILanguageObject theLangObj) {
        Object result = null;
        if (this.isValid(theLangObj) && theLangObj instanceof IElementSymbol) {
            result = ((IElementSymbol)theLangObj).getMetadataID();
        }
        return result;
    }

    @Override
    public boolean isValid(Object theNode) {
        this.checkState();
        return theNode == null || this.viewer == null || this.viewer.getContentProvider() == null ? false : !((ITreeContentProvider)this.viewer.getContentProvider()).hasChildren(theNode);
    }

    protected ICommand parseSql(String theSql) {
        ICommand command = null;
        if (theSql != null) {
            try {
                IQueryParser parser = ModelerCore.getTeiidQueryService().getQueryParser();
                command = parser.parseCommand(theSql);
            }
            catch (Exception exception) {}
        }
        return command;
    }

    @Override
    public void setTreeViewer(TreeViewer theViewer) {
        this.viewer = theViewer;
        this.labelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
        this.contentProvider = (ITreeContentProvider)this.getTreeViewer().getContentProvider();
    }

    protected char getDelimiterChar() {
        return '.';
    }
}

