/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerRuntimeArrayConstantsTest
extends Assert {
    private String typeId;

    public ServerRuntimeArrayConstantsTest(String typeId) {
        this.typeId = typeId;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        IServerType[] servers = ServerCore.getServerTypes();
        IRuntimeType[] rtTypes = ServerCore.getRuntimeTypes();
        ArrayList<String> collector = new ArrayList<String>();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getId().startsWith("org.jboss.ide.eclipse.as.eap.") || servers[i].getId().startsWith("org.jboss.ide.eclipse.as.")) {
                collector.add(servers[i].getId());
            }
            ++i;
        }
        i = 0;
        while (i < rtTypes.length) {
            if (rtTypes[i].getId().startsWith("org.jboss.ide.eclipse.as.runtime.")) {
                collector.add(rtTypes[i].getId());
            }
            ++i;
        }
        collector.remove("org.jboss.ide.eclipse.as.runtime.stripped");
        collector.remove("org.jboss.ide.eclipse.as.systemCopyServer");
        Object[] allTypes = collector.toArray(new String[collector.size()]);
        return ServerParameterUtils.asCollection(allTypes);
    }

    @Test
    public void testServerHomeSet() {
        ServerRuntimeArrayConstantsTest.assertNotNull((Object)this.typeId);
        IServerType type = ServerCore.findServerType((String)this.typeId);
        if (type != null) {
            String rtType;
            if (type.getRuntimeType() == null) {
                ServerRuntimeArrayConstantsTest.fail((String)("Server type " + this.typeId + " does not have an associated runtime"));
            }
            if ((rtType = type.getRuntimeType().getId()) == null) {
                ServerRuntimeArrayConstantsTest.fail((String)("Runtime type for servertype " + this.typeId + " has a null id."));
            }
            ServerRuntimeArrayConstantsTest.assertTrue((boolean)Arrays.asList(IJBossToolingConstants.ALL_JBOSS_RUNTIMES).contains(rtType));
        } else {
            IRuntimeType t = ServerCore.findRuntimeType((String)this.typeId);
            ServerRuntimeArrayConstantsTest.assertNotNull((Object)t);
            ServerRuntimeArrayConstantsTest.assertTrue((boolean)Arrays.asList(IJBossToolingConstants.ALL_JBOSS_RUNTIMES).contains(this.typeId));
        }
    }
}

