/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils.wtp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.jca.project.facet.ConnectorFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.JavaUtilityProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.ide.eclipse.as.ui.mbeans.project.JBossSARFacetProjectCreationDataModelProvider;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;

public class CreateProjectOperationsUtility {
    private static final String APP_CLIENT_PROJ_12 = "myAppClient_12";
    private static final String APP_CLIENT_PROJ_13 = "myAppClient_13";
    private static final String APP_CLIENT_PROJ_14 = "myAppClient_14";
    private static final String APP_CLIENT_PROJ_5 = "myAppClient_5";
    private static final String APP_CLIENT_PROJ_6 = "myAppClient_6";
    private static final String EJB_PROJ_11 = "myEJB_11";
    private static final String EJB_PROJ_2 = "myEJB_2";
    private static final String EJB_PROJ_21 = "myEJB_21";
    private static final String EJB_PROJ_3 = "myEJB_3";
    private static final String EJB_PROJ_31 = "myEJB_31";
    private static final String WEB_PROJ_22 = "myWeb_22";
    private static final String WEB_PROJ_23 = "myWeb_23";
    private static final String WEB_PROJ_24 = "myWeb_24";
    private static final String WEB_PROJ_25 = "myWeb_25";
    private static final String WEB_PROJ_30 = "myWeb_30";
    private static final String CONNECTOR_PROJ_1 = "myConnector_1";
    private static final String CONNECTOR_PROJ_15 = "myConnector_15";

    public static IDataModel getUtilityProjectCreationDataModel(String projName, String earName) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaUtilityProjectCreationDataModelProvider());
        dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", (Object)projName);
        dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.SOURCE_FOLDER", (Object)"src");
        if (earName != null) {
            dm.setProperty("IJavaUtilityProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        }
        return dm;
    }

    public void testEAR12_Defaults() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("aEAR", null, null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR13_Defaults() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("bEAR", null, null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR14_Defaults() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("cEAR", null, null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_Defaults() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("dEAR", null, null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR12_ChangedContentDir() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("eEAR", "whosContent", null, null, JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR13_ChangedContentDir() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("fEAR", "myContent", null, null, JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR14_ChangedContentDir() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("gEAR", "yourContent", null, null, JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_ChangedContentDir() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("hEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR12_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("zEAR", null, CreateProjectOperationsUtility.getJ2EEDependencyList_12(), CreateProjectOperationsUtility.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR13_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("yEAR", null, CreateProjectOperationsUtility.getJ2EEDependencyList_13(), CreateProjectOperationsUtility.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR14_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("xEAR", null, CreateProjectOperationsUtility.getJ2EEDependencyList_14(), CreateProjectOperationsUtility.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("wEAR", null, CreateProjectOperationsUtility.getJ2EEDependencyList_5(), CreateProjectOperationsUtility.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR12_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("zEAR", "myContent", CreateProjectOperationsUtility.getJ2EEDependencyList_12(), CreateProjectOperationsUtility.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR13_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("yEAR", "ourContent", CreateProjectOperationsUtility.getJ2EEDependencyList_13(), CreateProjectOperationsUtility.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR14_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("xEAR", "theirContent", CreateProjectOperationsUtility.getJ2EEDependencyList_14(), CreateProjectOperationsUtility.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("wEAR", "yourContent", CreateProjectOperationsUtility.getJ2EEDependencyList_5(), CreateProjectOperationsUtility.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_Defaults_WithDD() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("myEAR", null, null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify(dm);
    }

    public void testEAR50_ChangedContentDir_WithDD() throws Exception {
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel("yourEAR", "ourContent", null, null, JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runAndVerify(dm);
    }

    public static List getJ2EEDependencyList_12() throws Exception {
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(CreateProjectOperationsUtility.getAppClientCreationDataModel(APP_CLIENT_PROJ_12, null, JavaEEFacetConstants.APP_CLIENT_12, true, true));
        models.add(CreateProjectOperationsUtility.getEJBDataModel(EJB_PROJ_11, null, null, null, JavaEEFacetConstants.EJB_11, true));
        models.add(CreateProjectOperationsUtility.getWebDataModel(WEB_PROJ_22, null, null, null, null, JavaEEFacetConstants.WEB_22, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)models.get(i));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_12() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_13() throws Exception {
        CreateProjectOperationsUtility.getJ2EEDependencyList_12();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(CreateProjectOperationsUtility.getAppClientCreationDataModel(APP_CLIENT_PROJ_13, null, JavaEEFacetConstants.APP_CLIENT_13, true, true));
        models.add(CreateProjectOperationsUtility.getEJBDataModel(EJB_PROJ_2, null, null, null, JavaEEFacetConstants.EJB_2, true));
        models.add(CreateProjectOperationsUtility.getWebDataModel(WEB_PROJ_23, null, null, null, null, JavaEEFacetConstants.WEB_23, true));
        models.add(CreateProjectOperationsUtility.getConnectorDataModel(CONNECTOR_PROJ_1, null, null, JavaEEFacetConstants.CONNECTOR_1));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)models.get(i));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_13() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_14() throws Exception {
        CreateProjectOperationsUtility.getJ2EEDependencyList_13();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(CreateProjectOperationsUtility.getAppClientCreationDataModel(APP_CLIENT_PROJ_14, null, JavaEEFacetConstants.APP_CLIENT_14, true, true));
        models.add(CreateProjectOperationsUtility.getEJBDataModel(EJB_PROJ_21, null, null, null, JavaEEFacetConstants.EJB_21, true));
        models.add(CreateProjectOperationsUtility.getWebDataModel(WEB_PROJ_24, null, null, null, null, JavaEEFacetConstants.WEB_24, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)models.get(i));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static List getJavaDependencyList_14() {
        return Collections.emptyList();
    }

    public static List getJ2EEDependencyList_5() throws Exception {
        CreateProjectOperationsUtility.getJ2EEDependencyList_14();
        ArrayList<IProject> dependencies = new ArrayList<IProject>();
        ArrayList<IDataModel> models = new ArrayList<IDataModel>();
        models.add(CreateProjectOperationsUtility.getAppClientCreationDataModel(APP_CLIENT_PROJ_5, null, JavaEEFacetConstants.APP_CLIENT_5, true, false));
        models.add(CreateProjectOperationsUtility.getAppClientCreationDataModel("myAppClient_5_WithDD", null, JavaEEFacetConstants.APP_CLIENT_5, true, true));
        models.add(CreateProjectOperationsUtility.getEJBDataModel(EJB_PROJ_3, null, null, null, JavaEEFacetConstants.EJB_3, false));
        models.add(CreateProjectOperationsUtility.getEJBDataModel("myEJB_3_WithDD", null, null, null, JavaEEFacetConstants.EJB_3, true));
        models.add(CreateProjectOperationsUtility.getWebDataModel(WEB_PROJ_25, null, null, null, null, JavaEEFacetConstants.WEB_25, false));
        models.add(CreateProjectOperationsUtility.getWebDataModel("myWeb_25_WithDD", null, null, null, null, JavaEEFacetConstants.WEB_25, true));
        int i = 0;
        while (i < models.size()) {
            OperationTestCase.runDataModel((IDataModel)models.get(i));
            ++i;
        }
        dependencies.addAll(Arrays.asList(JavaEEProjectUtilities.getAllProjects()));
        return dependencies;
    }

    public static IDataModel getEJBDataModel(String projName, String clientName, String clientSourceFolder, String earName, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
            if (clientName != null) {
                facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
                facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", clientName);
                if (clientSourceFolder != null) {
                    facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_SOURCE_FOLDER ", clientSourceFolder);
                }
            }
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
        javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        return dm;
    }

    public static IDataModel getEJBDataModel(String projName, String clientName, String clientSourceFolder, String earName, IProjectFacetVersion version, boolean createCleint, boolean createDD) {
        IDataModel dm = CreateProjectOperationsUtility.getEJBDataModel(projName, clientName, clientSourceFolder, earName, version, createDD);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", createCleint);
        return dm;
    }

    public static List getJavaDependencyList_5() {
        return Collections.emptyList();
    }

    public static List getJavaDependencyList_6() {
        return Collections.emptyList();
    }

    public static IDataModel getEARDataModel(String projName, String contentDir, List dependenciesJ2EE, List dependenciesJava, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap factMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = (IDataModel)factMap.get((Object)"jst.ear");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (contentDir != null) {
            facetModel.setStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR", contentDir);
        }
        if (dependenciesJ2EE != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST", (Object)dependenciesJ2EE);
        }
        if (dependenciesJava != null) {
            facetModel.setProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST", (Object)dependenciesJava);
        }
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        return dm;
    }

    public static IDataModel getAppClientCreationDataModel(String projName, String earName, IProjectFacetVersion version, boolean createDefaultMainClass, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AppClientFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.appclient");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        facetModel.setProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS", (Object)createDefaultMainClass);
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
        javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        return dm;
    }

    public static IDataModel getWebDataModel(String projName, String earName, String contextRoot, String contentDir, String javaSrcDir, IProjectFacetVersion version, boolean createDD) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.web");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (contextRoot != null && earName != null) {
            facetModel.setStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", contextRoot);
        }
        if (contentDir != null) {
            facetModel.setStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", contentDir);
        }
        if (javaSrcDir != null) {
            facetModel.setStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER", javaSrcDir);
        }
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", createDD);
        IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
        javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        return dm;
    }

    public static IDataModel getConnectorDataModel(String projName, String earName, String sourceFolder, IProjectFacetVersion version) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        if (earName != null) {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)true);
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        } else {
            dm.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)false);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.connector");
        facetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        if (sourceFolder != null) {
            facetModel.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)sourceFolder);
        }
        if (version == JavaEEFacetConstants.CONNECTOR_15) {
            IDataModel javaFacetModel = facetMap.getFacetDataModel("jst.java");
            javaFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaEEFacetConstants.JAVA_5);
        }
        return dm;
    }

    public static IDataModel getSarDataModel(String projName, String sourceFolder, String contentFolder, String outputFolder, IProjectFacetVersion version) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JBossSARFacetProjectCreationDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel esbFacetModel = facetMap.getFacetDataModel("jst.jboss.sar");
        esbFacetModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)version);
        String tmp = JavaEEFacetConstants.JAVA_FACET.getId();
        IDataModel javaFacetModel = facetMap.getFacetDataModel(tmp);
        if (sourceFolder != null) {
            javaFacetModel.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)sourceFolder);
        }
        if (outputFolder != null) {
            javaFacetModel.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)outputFolder);
        }
        if (contentFolder != null) {
            esbFacetModel.setProperty("JBoss.Project.Content_Folder", (Object)contentFolder);
        }
        return dm;
    }
}

