/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.I18n;
import org.teiid.core.designer.exception.EmptyArgumentException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ddl.importer.DdlImporter;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiI18n;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiPlugin;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.util.ErrorHandler;

class DdlImporterPage
extends WizardPage
implements IPersistentWizardPage {
    private static final String TEIID_DIALECT = "TEIID";
    private static final String SQL92_DIALECT = "SQL92";
    private static final String ORACLE_DIALECT = "ORACLE";
    private static final String POSTGRES_DIALECT = "POSTGRES";
    private static final String DERBY_DIALECT = "DERBY";
    private static final int PANEL_GRID_SPAN = 3;
    private static final String INITIAL_DIALOG_FOLDER_SETTING = "initialDialogFolder";
    private static final String HISTORY_SETTING = "history";
    private static final int MAX_HISTORY = 5;
    private static final List<ModelType> MODEL_TYPES = Arrays.asList(ModelType.PHYSICAL_LITERAL, ModelType.VIRTUAL_LITERAL);
    private static final List<String> DIALECT_TYPES = Arrays.asList("TEIID", "SQL92", "ORACLE", "POSTGRES", "DERBY");
    private static final String OPT_TO_CREATE_MODEL_ENTITIES_FOR_UNSUPPORTED_DDL_SETTING = "optToCreateModelEntitiesForUnsupportedDdl";
    private static final String OPT_TO_SET_MODEL_ENTITY_DESCRIPTION_SETTING = "optToSetModelEntityDescription";
    private final DdlImporter importer;
    final IProject[] projects;
    IFile selectedFile;
    private StringNameValidator nameValidator = new StringNameValidator();
    private Combo ddlFileCombo;
    private Text modelFolderFld;
    private Text modelNameFld;
    Combo dialectCombo;
    private Button autoSelectDialectCheckBox;
    private Combo modelTypeCombo;
    private Button generateDefaultSQLCheckBox;
    private Button optToSetModelEntityDescriptionCheckBox;
    private Button optToCreateModelEntitiesForUnsupportedDdlCheckBox;
    Button filterRedundantUCsCB;
    private Text ddlFileContentsBox;
    private TabItem modelDefinitionTab;
    private TabItem optionsTab;
    private TabItem ddlTab;
    private String initDlgFolderName;
    private boolean generateModelName = true;
    Properties options;

    DdlImporterPage(DdlImporter importer, IProject[] projects, IStructuredSelection selection, Properties options) {
        super(DdlImporterPage.class.getSimpleName(), DdlImporterUiI18n.PAGE_TITLE, null);
        Object obj;
        this.importer = importer;
        this.projects = projects;
        this.options = options;
        HashSet<IContainer> selectedContainers = new HashSet<IContainer>();
        for (Object resource : selection) {
            if (resource instanceof IContainer) {
                selectedContainers.add((IContainer)resource);
            } else if (resource instanceof IResource) {
                selectedContainers.add(((IResource)resource).getParent());
            }
            if (selectedContainers.size() <= 1) continue;
            return;
        }
        if (selectedContainers.size() == 0) {
            if (projects.length == 1) {
                importer.setModelFolder((IContainer)projects[0]);
            }
        } else if (selectedContainers.size() == 1) {
            importer.setModelFolder((IContainer)selectedContainers.iterator().next());
        }
        if (selection.size() == 1 && (obj = selection.getFirstElement()) instanceof IFile) {
            this.selectedFile = (IFile)obj;
        }
    }

    void chooseDdlFile() {
        FileDialog dlg = new FileDialog(this.getShell());
        String ddlFileName = this.ddlFileCombo.getText().trim();
        File file = new File(ddlFileName);
        if (file.exists() && file.isDirectory()) {
            this.initDlgFolderName = ddlFileName;
        } else {
            String folderName;
            File folder;
            int ndx = ddlFileName.lastIndexOf(File.separatorChar);
            if (ndx < 0) {
                ndx = ddlFileName.lastIndexOf(47);
            }
            if (file.exists()) {
                dlg.setFileName(ddlFileName.substring(ndx + 1));
            }
            if (ndx >= 0 && (folder = new File(folderName = ddlFileName.substring(0, ndx + 1))).exists() && folder.isDirectory()) {
                this.initDlgFolderName = folderName;
            }
            if (this.initDlgFolderName == null) {
                this.initDlgFolderName = System.getProperty("user.home");
            }
        }
        dlg.setFilterPath(this.initDlgFolderName);
        dlg.setFilterExtensions(new String[]{"*.ddl; *.sql", "*.*"});
        dlg.setFilterNames(new String[]{"DDL Files", "All Files"});
        String fileName = dlg.open();
        if (fileName != null) {
            this.ddlFileCombo.setText(fileName);
            this.tabFromDdlFileCombo();
        }
        this.initDlgFolderName = dlg.getFilterPath();
    }

    void chooseDdlFileFromWorkspace() {
        ChooseFileDialog dlg = new ChooseFileDialog(DdlImporterUiI18n.CHOOSE_DDL_FILE_DIALOG_TITLE, DdlImporterUiI18n.CHOOSE_DDL_FILE_DIALOG_MSG, new ChooseFileDialogContentProvider(this){

            @Override
            boolean validFile(IFile file) {
                String ext = file.getFileExtension();
                if (ext == null) {
                    return false;
                }
                return "ddl".equals(ext = ext.toLowerCase()) || "sql".equals(ext);
            }
        });
        IResource choice = this.showChooseDialog(dlg);
        if (choice == null) {
            return;
        }
        File realFile = choice.getLocation().toFile();
        this.ddlFileCombo.setText(realFile.toString());
        this.tabFromDdlFileCombo();
    }

    void chooseModel() {
        IResource choice;
        ChooseFileDialog dlg = new ChooseFileDialog(DdlImporterUiI18n.CHOOSE_MODEL_FILE_DIALOG_TITLE, DdlImporterUiI18n.CHOOSE_MODEL_FILE_DIALOG_MSG, new ChooseFileDialogContentProvider(this){

            @Override
            boolean validFile(IFile file) {
                return this.relationalModel(file);
            }
        });
        if (this.importer.modelFile() != null) {
            dlg.setInitialSelection(this.importer.modelFile());
        }
        if ((choice = this.showChooseDialog(dlg)) == null) {
            return;
        }
        this.modelNameFld.setText(choice.getFullPath().removeFileExtension().lastSegment().toString());
        IPath folder = choice.getFullPath().removeLastSegments(1);
        this.modelFolderFld.setText(folder.toString());
    }

    void chooseModelFolder() {
        IResource choice;
        ChooseDialog dlg = new ChooseDialog(DdlImporterUiI18n.CHOOSE_MODEL_FOLDER_DIALOG_TITLE, DdlImporterUiI18n.CHOOSE_MODEL_FOLDER_DIALOG_MSG, new ChooseDialogContentProvider(this){

            @Override
            public final IResource[] getChildren(IContainer container) {
                ArrayList<IResource> children = new ArrayList<IResource>();
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource instanceof IContainer) {
                            children.add(resource);
                        }
                        ++n2;
                    }
                }
                catch (CoreException error) {
                    ErrorHandler.toExceptionDialog((CoreException)error);
                }
                return children.toArray(new IResource[children.size()]);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public final boolean hasChildren(IContainer container) {
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource resource = iResourceArray[n2];
                        if (resource instanceof IContainer) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException error) {
                    ErrorHandler.toExceptionDialog((CoreException)error);
                }
                return false;
            }
        });
        if (this.importer.modelFolder() != null) {
            dlg.setInitialSelection(this.importer.modelFolder());
        }
        if ((choice = this.showChooseDialog(dlg)) == null) {
            return;
        }
        this.modelFolderFld.setText(choice.getFullPath().toString());
        this.modelNameFld.setFocus();
    }

    public void createControl(Composite parent) {
        IDialogSettings settings = this.getDialogSettings();
        this.initDlgFolderName = settings.get(INITIAL_DIALOG_FOLDER_SETTING);
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayoutData((Object)new GridData(768));
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite panel = scrolledComposite.getPanel();
        panel.setLayoutData((Object)new GridData(768));
        panel.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)panel);
        Group ddlFileGroup = WidgetFactory.createGroup((Composite)panel, (String)DdlImporterUiI18n.FILE_GROUP_LABEL, (int)768, (int)3, (int)3);
        WidgetFactory.createLabel((Composite)ddlFileGroup, (int)4, (String)DdlImporterUiI18n.DDL_FILE_LABEL);
        String[] ddlFileHistory = settings.getArray(HISTORY_SETTING);
        List<Object> historyList = null;
        historyList = ddlFileHistory != null ? Arrays.asList(ddlFileHistory) : Collections.emptyList();
        this.ddlFileCombo = WidgetFactory.createCombo((Composite)ddlFileGroup, (int)0, (int)768, historyList, (ILabelProvider)new LabelProvider(), (boolean)false);
        this.ddlFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DdlImporterPage.this.ddlFileModified();
            }
        });
        this.ddlFileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.ddlFileSelected();
            }
        });
        Composite buttonPanel = WidgetFactory.createPanel((Composite)ddlFileGroup, (int)8);
        Button button = WidgetFactory.createButton((Composite)buttonPanel, (String)DdlImporterUiI18n.CHOOSE_FROM_FILE_SYSTEM_BUTTON, (int)256);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.chooseDdlFile();
            }
        });
        button = WidgetFactory.createButton((Composite)buttonPanel, (String)DdlImporterUiI18n.CHOOSE_FROM_WORKSPACE_BUTTON, (int)256);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.chooseDdlFileFromWorkspace();
            }
        });
        WidgetFactory.createLabel((Composite)ddlFileGroup, (int)4, (String)DdlImporterUiI18n.DIALECT_LABEL);
        Composite dialectPanel = WidgetFactory.createPanel((Composite)ddlFileGroup, (int)0, (int)256, (int)2, (int)2);
        this.dialectCombo = WidgetFactory.createCombo((Composite)dialectPanel, (int)8, (int)256, DIALECT_TYPES, (ILabelProvider)new LabelProvider(), (boolean)false);
        this.dialectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int comboIndx = DdlImporterPage.this.dialectCombo.getSelectionIndex();
                String dialect = DdlImporterPage.this.dialectCombo.getItem(comboIndx);
                DdlImporterPage.this.selectDialect(dialect);
            }
        });
        this.selectDialect(null);
        this.autoSelectDialectCheckBox = WidgetFactory.createCheckBox((Composite)dialectPanel, (String)DdlImporterUiI18n.AUTO_SELECT_DIALECT_CHECKBOX, (int)0, (int)1, (boolean)true);
        this.autoSelectDialectCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.autoSelectDialectChanged();
            }
        });
        this.dialectCombo.setEnabled(false);
        TabFolder tabFolder = this.createTabFolder(panel);
        this.createModelDefinitionTab(tabFolder);
        this.createNameOptionsTab(tabFolder);
        this.createDdlTab(tabFolder);
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        if (this.selectedFile != null) {
            if (this.relationalModel(this.selectedFile)) {
                this.modelNameFld.setText(this.selectedFile.getFullPath().removeFileExtension().lastSegment());
                this.generateModelName = false;
            } else {
                String ext = this.selectedFile.getFileExtension();
                if (ext != null && ("ddl".equals(ext = ext.toLowerCase()) || "sql".equals(ext))) {
                    this.ddlFileCombo.setText(this.selectedFile.getLocation().toString());
                }
            }
        } else {
            this.validate();
        }
    }

    private TabFolder createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2192);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabFolder);
        return tabFolder;
    }

    private void createModelDefinitionTab(TabFolder folderParent) {
        Composite thePanel = this.createModelDefinitionPanel((Composite)folderParent);
        this.modelDefinitionTab = new TabItem(folderParent, 0);
        this.modelDefinitionTab.setControl((Control)thePanel);
        this.modelDefinitionTab.setText(DdlImporterUiI18n.MODEL_GROUP_LABEL);
    }

    private void createNameOptionsTab(TabFolder folderParent) {
        Composite thePanel = this.createOptionsPanel((Composite)folderParent);
        this.optionsTab = new TabItem(folderParent, 0);
        this.optionsTab.setControl((Control)thePanel);
        this.optionsTab.setText(DdlImporterUiI18n.OPTIONS_GROUP_LABEL);
    }

    private void createDdlTab(TabFolder folderParent) {
        Composite thePanel = this.createDdlPanel((Composite)folderParent);
        this.ddlTab = new TabItem(folderParent, 0);
        this.ddlTab.setControl((Control)thePanel);
        this.ddlTab.setText(DdlImporterUiI18n.DDL_FILE_CONTENTS_TITLE);
    }

    private Composite createModelDefinitionPanel(Composite parent) {
        Composite mainPanel = WidgetFactory.createPanel((Composite)parent, (int)256, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(mainPanel);
        if (mainPanel.getHorizontalBar() != null) {
            mainPanel.getHorizontalBar().setVisible(false);
        }
        WidgetFactory.createLabel((Composite)mainPanel, (int)4, (String)DdlImporterUiI18n.MODEL_FOLDER_LABEL);
        this.modelFolderFld = WidgetFactory.createTextField((Composite)mainPanel, (int)768);
        IContainer modelFolder = this.importer.modelFolder();
        if (modelFolder != null) {
            this.modelFolderFld.setText(modelFolder.getFullPath().toString());
        }
        this.modelFolderFld.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DdlImporterPage.this.validate();
            }
        });
        Button button = WidgetFactory.createButton((Composite)mainPanel, (String)DdlImporterUiI18n.CHOOSE_BUTTON);
        if (this.projects.length == 0) {
            button.setEnabled(false);
        } else {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DdlImporterPage.this.chooseModelFolder();
                }
            });
        }
        WidgetFactory.createLabel((Composite)mainPanel, (int)4, (String)DdlImporterUiI18n.MODEL_NAME_LABEL);
        this.modelNameFld = WidgetFactory.createTextField((Composite)mainPanel);
        this.modelNameFld.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DdlImporterPage.this.modelNameModified();
            }
        });
        button = WidgetFactory.createButton((Composite)mainPanel, (String)DdlImporterUiI18n.CHOOSE_BUTTON);
        if (this.projects.length == 0) {
            button.setEnabled(false);
        } else {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DdlImporterPage.this.chooseModel();
                }
            });
        }
        WidgetFactory.createLabel((Composite)mainPanel, (int)4, (String)DdlImporterUiI18n.MODEL_TYPE_LABEL);
        Composite modelTypePanel = WidgetFactory.createPanel((Composite)mainPanel, (int)0, (int)256, (int)2, (int)2);
        this.modelTypeCombo = WidgetFactory.createCombo((Composite)modelTypePanel, (int)8, (int)256, MODEL_TYPES, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ModelType)element).getDisplayName();
            }
        });
        this.modelTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                DdlImporterPage.this.modelTypeModified();
            }
        });
        this.modelTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.validate();
            }
        });
        this.generateDefaultSQLCheckBox = WidgetFactory.createCheckBox((Composite)modelTypePanel, (String)DdlImporterUiI18n.GENERATE_DEFAULT_SQL_CHECKBOX, (int)0, (int)1, (boolean)false);
        this.generateDefaultSQLCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.generateDefaultSQLChanged();
            }
        });
        this.generateDefaultSQLCheckBox.setEnabled(false);
        this.modelTypeCombo.select(this.modelTypeCombo.indexOf(ModelType.PHYSICAL_LITERAL.getDisplayName()));
        return mainPanel;
    }

    void ddlFileModified() {
        this.validate();
        String ddlFileName = this.importer.ddlFileName();
        if (ddlFileName == null) {
            if (this.generateModelName) {
                this.modelNameFld.setText("");
                this.generateModelName = true;
            }
            this.ddlFileContentsBox.setText("");
        } else {
            if (this.generateModelName) {
                this.modelNameFld.setText(Path.fromOSString((String)ddlFileName).removeFileExtension().lastSegment());
                this.generateModelName = true;
            }
            try {
                File ddlFile = new File(ddlFileName);
                this.ddlFileContentsBox.setText(FileUtil.readSafe((File)ddlFile));
            }
            catch (IOException error) {
                ErrorHandler.toExceptionDialog((Throwable)error);
            }
        }
        this.ddlFileContentsBox.setTopIndex(0);
    }

    private Composite createOptionsPanel(Composite parent) {
        IDialogSettings settings = this.getDialogSettings();
        Composite mainPanel = WidgetFactory.createPanel((Composite)parent, (int)256, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(mainPanel);
        if (mainPanel.getHorizontalBar() != null) {
            mainPanel.getHorizontalBar().setVisible(false);
        }
        this.optToSetModelEntityDescriptionCheckBox = WidgetFactory.createCheckBox((Composite)mainPanel, (String)DdlImporterUiI18n.OPT_TO_SET_MODEL_ENTITY_DESCRIPTION_LABEL, (int)0, (int)3, (boolean)settings.getBoolean(OPT_TO_SET_MODEL_ENTITY_DESCRIPTION_SETTING));
        this.optToSetModelEntityDescriptionCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.optToSetModelEntityDescriptionModified();
            }
        });
        this.optToSetModelEntityDescriptionModified();
        this.optToCreateModelEntitiesForUnsupportedDdlCheckBox = WidgetFactory.createCheckBox((Composite)mainPanel, (String)DdlImporterUiI18n.OPT_TO_CREATE_MODEL_ENTITIES_FOR_UNSUPPORTED_DDL_LABEL, (int)0, (int)3, (boolean)settings.getBoolean(OPT_TO_CREATE_MODEL_ENTITIES_FOR_UNSUPPORTED_DDL_SETTING));
        this.optToCreateModelEntitiesForUnsupportedDdlCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.optToCreateModelEntitiesForUnsupportedDdlModified();
            }
        });
        this.optToCreateModelEntitiesForUnsupportedDdlModified();
        this.filterRedundantUCsCB = WidgetFactory.createCheckBox((Composite)mainPanel, (String)DdlImporterUiI18n.FILTER_UCS_FOR_DEFINED_PKS_LABEL, (int)0, (int)3, (boolean)true);
        this.filterRedundantUCsCB.setSelection(true);
        this.filterRedundantUCsCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DdlImporterPage.this.options.put("ddlImport_filterConstraints", Boolean.toString(DdlImporterPage.this.filterRedundantUCsCB.getSelection()));
            }
        });
        return mainPanel;
    }

    private Composite createDdlPanel(Composite parent) {
        Composite mainPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(mainPanel);
        this.ddlFileContentsBox = WidgetFactory.createTextBox((Composite)mainPanel);
        this.ddlFileContentsBox.setEditable(false);
        return mainPanel;
    }

    void ddlFileSelected() {
        this.ddlFileModified();
        this.tabFromDdlFileCombo();
    }

    void modelNameModified() {
        this.generateModelName = false;
        this.validate();
    }

    void modelTypeModified() {
        this.importer.setModelType(MODEL_TYPES.get(this.modelTypeCombo.indexOf(this.modelTypeCombo.getText())));
        if (this.modelTypeCombo.getText().equals(ModelType.VIRTUAL_LITERAL.getDisplayName())) {
            this.generateDefaultSQLCheckBox.setEnabled(true);
        } else {
            this.generateDefaultSQLCheckBox.setEnabled(false);
        }
    }

    void selectDialect(String dialect) {
        this.importer.setSpecifiedParser(dialect);
    }

    void autoSelectDialectChanged() {
        boolean isChecked = this.autoSelectDialectCheckBox.getSelection();
        if (isChecked) {
            this.dialectCombo.setEnabled(false);
            this.selectDialect(null);
        } else {
            this.dialectCombo.setEnabled(true);
            int comboIndx = this.dialectCombo.getSelectionIndex();
            if (comboIndx == -1) {
                int teiidIndx = this.dialectCombo.indexOf(SQL92_DIALECT);
                this.dialectCombo.select(teiidIndx);
                this.selectDialect(SQL92_DIALECT);
            } else {
                String dialect = this.dialectCombo.getItem(comboIndx);
                this.selectDialect(dialect);
            }
        }
    }

    void generateDefaultSQLChanged() {
        this.importer.setGenerateDefaultSQL(this.generateDefaultSQLCheckBox.getSelection());
    }

    void optToCreateModelEntitiesForUnsupportedDdlModified() {
        this.importer.setOptToCreateModelEntitiesForUnsupportedDdl(this.optToCreateModelEntitiesForUnsupportedDdlCheckBox.getSelection());
    }

    void optToSetModelEntityDescriptionModified() {
        this.importer.setOptToSetModelEntityDescription(this.optToSetModelEntityDescriptionCheckBox.getSelection());
    }

    boolean relationalModel(IFile file) {
        ModelResource model;
        block5: {
            if (file == null) {
                return false;
            }
            model = ModelerCore.getModelEditor().findModelResource((IResource)file);
            if (model != null) break block5;
            return false;
        }
        try {
            if (ModelUtil.isModelFile((Resource)model.getEmfResource()) && "http://www.metamatrix.com/metamodels/Relational".equals(ModelUtil.getXmiHeader((IResource)model.getResource()).getPrimaryMetamodelURI())) {
                return true;
            }
        }
        catch (CoreException error) {
            error.printStackTrace();
            WidgetUtil.showError((Throwable)error);
        }
        return false;
    }

    public void saveSettings() {
        String file;
        IDialogSettings settings = this.getDialogSettings();
        if (this.initDlgFolderName != null) {
            settings.put(INITIAL_DIALOG_FOLDER_SETTING, this.initDlgFolderName);
        }
        if ((file = this.importer.ddlFileName()) != null && !file.isEmpty()) {
            String[] history = this.ddlFileCombo.getItems();
            boolean exists = false;
            String[] stringArray = history;
            int n = history.length;
            int n2 = 0;
            while (n2 < n) {
                String oldFile = stringArray[n2];
                if (oldFile.equals(file)) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                if (history.length == 5) {
                    System.arraycopy(history, 0, history, 1, 4);
                } else {
                    String[] newHistory = new String[history.length + 1];
                    System.arraycopy(history, 0, newHistory, 1, history.length);
                    history = newHistory;
                }
                history[0] = file;
                this.ddlFileCombo.setItems(history);
                settings.put(HISTORY_SETTING, history);
            }
        }
        settings.put(OPT_TO_SET_MODEL_ENTITY_DESCRIPTION_SETTING, this.optToSetModelEntityDescriptionCheckBox.getSelection());
        settings.put(OPT_TO_CREATE_MODEL_ENTITIES_FOR_UNSUPPORTED_DDL_SETTING, this.optToCreateModelEntitiesForUnsupportedDdlCheckBox.getSelection());
    }

    public void setErrorMessage(String message) {
        if (message == null || this.getErrorMessage() == null) {
            super.setErrorMessage(message);
        }
        this.setPageComplete(message == null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.importer.modelFolder() != null) {
            this.ddlFileCombo.setFocus();
        }
    }

    private IResource showChooseDialog(ElementTreeSelectionDialog dialog) {
        return dialog.open() == 0 ? (IResource)dialog.getFirstResult() : null;
    }

    void tabFromDdlFileCombo() {
        if (this.importer.ddlFileName() != null) {
            if (this.importer.modelFolder() == null) {
                this.modelFolderFld.setFocus();
            } else {
                this.modelNameFld.setFocus();
            }
        }
    }

    void validate() {
        String validationMsg;
        this.setErrorMessage(null);
        String ddlFileName = this.ddlFileCombo.getText();
        try {
            this.importer.setDdlFileName(ddlFileName);
        }
        catch (EmptyArgumentException emptyArgumentException) {
            this.setErrorMessage(DdlImporterUiI18n.DDL_FILE_MSG);
        }
        catch (IllegalArgumentException error) {
            this.setErrorMessage(String.valueOf(DdlImporterUiI18n.DDL_FILE_MSG) + ' ' + error.getMessage());
        }
        this.ddlFileCombo.setToolTipText(ddlFileName);
        try {
            this.importer.setModelFolder(this.modelFolderFld.getText());
        }
        catch (EmptyArgumentException emptyArgumentException) {
            this.setErrorMessage(DdlImporterUiI18n.MODEL_FOLDER_MSG);
        }
        catch (IllegalArgumentException error) {
            this.setErrorMessage(String.valueOf(DdlImporterUiI18n.MODEL_FOLDER_MSG) + ' ' + error.getMessage());
        }
        String modelName = this.modelNameFld.getText().trim();
        if (!CoreStringUtil.isEmpty((String)modelName) && !CoreStringUtil.isEmpty((String)(validationMsg = this.nameValidator.checkValidName(modelName)))) {
            this.setErrorMessage(String.valueOf(DdlImporterUiI18n.MODEL_MSG) + '\n' + validationMsg);
        }
        try {
            this.importer.setModelName(modelName);
        }
        catch (EmptyArgumentException emptyArgumentException) {
            this.setErrorMessage(DdlImporterUiI18n.MODEL_MSG);
        }
        catch (IllegalArgumentException error) {
            this.setErrorMessage(String.valueOf(DdlImporterUiI18n.MODEL_MSG) + ' ' + error.getMessage());
        }
        if (this.importer.modelFile() != null && this.importer.modelFile().exists()) {
            try {
                ModelResource model = ModelerCore.getModelEditor().findModelResource((IResource)this.importer.modelFile());
                ModelType type = ModelUtil.isPhysical((Object)model.getEmfResource()) ? ModelType.PHYSICAL_LITERAL : ModelType.VIRTUAL_LITERAL;
                this.modelTypeCombo.select(this.modelTypeCombo.indexOf(type.getDisplayName()));
                this.modelTypeCombo.setEnabled(false);
            }
            catch (Exception error) {
                error.printStackTrace();
                WidgetUtil.showError((Throwable)error);
                return;
            }
        } else {
            this.modelTypeCombo.setEnabled(true);
        }
        if (this.getErrorMessage() == null) {
            String msg = I18n.format((String)DdlImporterUiI18n.PAGE_DESCRIPTION, (Object[])new Object[]{this.importer.modelFile().exists() ? DdlImporterUiI18n.UPDATE_MSG_PART : DdlImporterUiI18n.CREATE_MSG_PART, this.importer.modelType().getDisplayName().toLowerCase(), modelName, this.importer.ddlFileName()});
            IContainer modelFolder = this.importer.modelFolder();
            if (!modelFolder.exists()) {
                msg = String.valueOf(msg) + (modelFolder.getProject().exists() ? DdlImporterUiI18n.PATH_MSG_PART : DdlImporterUiI18n.PROJECT_MSG_PART) + I18n.format((String)DdlImporterUiI18n.PROJECT_MSG_PART, (Object[])new Object[]{modelFolder.getFullPath()});
            }
            this.setDescription(msg);
        }
    }

    private class ChooseDialog
    extends ElementTreeSelectionDialog {
        ChooseDialog(String title, String message, ChooseDialogContentProvider contentProvider) {
            super(DdlImporterPage.this.getShell(), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)contentProvider);
            this.setTitle(title);
            this.setMessage(message);
            this.setAllowMultiple(false);
            this.setInput(DdlImporterPage.this.projects);
        }
    }

    abstract class ChooseDialogContentProvider
    implements ITreeContentProvider {
        ChooseDialogContentProvider() {
        }

        public final void dispose() {
        }

        abstract IResource[] getChildren(IContainer var1);

        public final Object[] getChildren(Object parent) {
            return this.getChildren((IContainer)parent);
        }

        public Object[] getElements(Object inputElement) {
            return DdlImporterPage.this.projects;
        }

        public final Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        abstract boolean hasChildren(IContainer var1);

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return false;
            }
            return this.hasChildren((IContainer)element);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ChooseFileDialog
    extends ChooseDialog {
        ChooseFileDialog(String title, String message, ChooseDialogContentProvider contentProvider) {
            super(title, message, contentProvider);
            this.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection.length == 1 && selection[0] instanceof IFile) {
                        return new Status(0, DdlImporterUiPlugin.ID, null);
                    }
                    return new Status(4, DdlImporterUiPlugin.ID, null);
                }
            });
        }
    }

    abstract class ChooseFileDialogContentProvider
    extends ChooseDialogContentProvider {
        private IProject[] projects;

        ChooseFileDialogContentProvider() {
        }

        @Override
        public final IResource[] getChildren(IContainer container) {
            ArrayList<IResource> children = new ArrayList<IResource>();
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IContainer && this.hasChildren((IContainer)resource) || resource instanceof IFile && this.validFile((IFile)resource)) {
                        children.add(resource);
                    }
                    ++n2;
                }
            }
            catch (CoreException error) {
                ErrorHandler.toExceptionDialog((CoreException)error);
            }
            return children.toArray(new IResource[children.size()]);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (this.projects == null) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                IProject[] iProjectArray = DdlImporterPage.this.projects;
                int n = DdlImporterPage.this.projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (this.hasChildren((IContainer)project)) {
                        projects.add(project);
                    }
                    ++n2;
                }
                this.projects = projects.toArray(new IProject[projects.size()]);
            }
            return this.projects;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean hasChildren(IContainer container) {
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IContainer ? this.hasChildren(resource) : this.validFile((IFile)resource)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (CoreException error) {
                ErrorHandler.toExceptionDialog((CoreException)error);
            }
            return false;
        }

        abstract boolean validFile(IFile var1);
    }
}

