/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.status;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.advisor.ui.actions.AdvisorActionFactory;
import org.teiid.designer.advisor.ui.actions.NewModelAction;
import org.teiid.designer.advisor.ui.actions.ToggleAutoBuildAction;
import org.teiid.designer.advisor.ui.core.IAdvisorActionHandler;
import org.teiid.designer.advisor.ui.core.InfoPopAction;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatus;
import org.teiid.designer.advisor.ui.util.DSPPluginImageHelper;
import org.teiid.designer.advisor.ui.views.status.ModelProjectStatus;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class StatusActionHandler
implements IAdvisorActionHandler,
AdvisorUiConstants.Groups {
    final DSPPluginImageHelper imageHelper = AdvisorUiPlugin.getImageHelper();
    private static final String RELATIONAL_ID = "Relational";
    NewModelAction newRelationalSourceModelAction;
    NewModelAction newRelationalViewModelAction;
    private InfoPopAction showProblemsViewIPAction;
    private InfoPopAction importJdbcIPAction;
    private InfoPopAction importSalesforceIPAction;
    private InfoPopAction importDdlIPAction;
    private InfoPopAction importFlatFileIPAction;
    private InfoPopAction importXmlFileIPAction;
    private InfoPopAction openDSEIPAction;
    private InfoPopAction newJdbcCPIPAction;
    private InfoPopAction newSFCPIPAction;
    private InfoPopAction newWSSoapIPAction;
    private InfoPopAction importXsdIPAction;
    private InfoPopAction newRelationalSourceModelIPAction;
    private InfoPopAction newRelationalViewModelIPAction;
    private InfoPopAction toggleAutoBuildIPAction;
    private InfoPopAction previewDataIPAction;
    private InfoPopAction newVdbIPAction;
    private InfoPopAction editVdbIPAction;
    private InfoPopAction executeVdbIPAction;
    private ModelProjectStatus status;

    public StatusActionHandler() {
        try {
            this.createActions();
        }
        catch (CoreException e) {
            AdvisorUiConstants.UTIL.log((Throwable)e);
        }
    }

    private void createActions() throws CoreException {
        ToggleAutoBuildAction toggleAutoBuildAction = new ToggleAutoBuildAction(AdvisorUiPlugin.getDefault().getCurrentWorkbenchWindow());
        toggleAutoBuildAction.setText(Messages.ToggleAutoBuild);
        this.toggleAutoBuildIPAction = new InfoPopAction((IAction)toggleAutoBuildAction, 1, Messages.ToggleAutoBuild, this.imageHelper.BUILD_IMAGE);
        Action openDSEAction = new Action(){

            public void run() {
                UiUtil.showView((String)"org.eclipse.datatools.connectivity.DataSourceExplorerNavigator");
            }
        };
        openDSEAction.setText(Messages.OpenDatatoolsDataSourceExplorer);
        openDSEAction.setToolTipText(Messages.OpenDatatoolsDataSourceExplorer_tooltip);
        openDSEAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/data-source-explorer-view.gif"));
        this.openDSEIPAction = new InfoPopAction((IAction)openDSEAction, 1, Messages.Options_Action_OpenDSEAction_description, this.imageHelper.OPEN_DATA_SOURCE_EXPLORER_IMAGE);
        Action newJdbcCPAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.connection.new.jdbc", true);
            }
        };
        newJdbcCPAction.setText(Messages.CreateJdbcConnection);
        newJdbcCPAction.setToolTipText(Messages.CreateJdbcConnection);
        this.newJdbcCPIPAction = new InfoPopAction((IAction)newJdbcCPAction, 1, Messages.CreateJdbcConnection, this.imageHelper.NEW_CONNECTION_PROFILE_IMAGE);
        Action newSalesforceCPAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.connection.new.salesforce", true);
            }
        };
        newSalesforceCPAction.setText(Messages.CreateSalesforceConnection);
        newSalesforceCPAction.setToolTipText(Messages.CreateSalesforceConnection);
        this.newSFCPIPAction = new InfoPopAction((IAction)newSalesforceCPAction, 1, Messages.CreateSalesforceConnection, this.imageHelper.NEW_CONNECTION_PROFILE_IMAGE);
        Action newWSSoapCPAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.connection.new.odaws", true);
            }
        };
        newWSSoapCPAction.setText(Messages.CreateOdaWebServicesConnection);
        newWSSoapCPAction.setToolTipText(Messages.CreateOdaWebServicesConnection);
        this.newWSSoapIPAction = new InfoPopAction((IAction)newWSSoapCPAction, 1, Messages.CreateOdaWebServicesConnection, this.imageHelper.NEW_CONNECTION_PROFILE_IMAGE);
        Action delegateOpenProblemsViewAction = new Action(){

            public void run() {
                UiUtil.showView((String)"org.eclipse.ui.views.ProblemView");
            }
        };
        delegateOpenProblemsViewAction.setText(Messages.Options_Action_OpenProblemsView_description);
        delegateOpenProblemsViewAction.setToolTipText(Messages.Options_Action_OpenProblemsView_description);
        delegateOpenProblemsViewAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/ConfigurationManagerView.gif"));
        this.showProblemsViewIPAction = new InfoPopAction((IAction)delegateOpenProblemsViewAction, 0, Messages.Options_Action_OpenProblemsView_description, this.imageHelper.PROBLEMS_VIEW_IMAGE);
        Action delegateImportJdbcAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.importJdbcCommand", true);
            }
        };
        delegateImportJdbcAction.setText(Messages.Action_ImportJdbc_text);
        delegateImportJdbcAction.setToolTipText(Messages.Action_ImportJdbc_tooltip);
        delegateImportJdbcAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import-jdbc.gif"));
        this.importJdbcIPAction = new InfoPopAction((IAction)delegateImportJdbcAction, 1, Messages.Options_Action_ImportJDBC_description, this.imageHelper.IMPORT_JDBC_IMAGE);
        Action delegateImportDdlAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.importDdlCommand", true);
            }
        };
        delegateImportDdlAction.setText(Messages.Action_ImportDdl_text);
        delegateImportDdlAction.setToolTipText(Messages.Action_ImportDdl_tooltip);
        delegateImportDdlAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import-jdbc.gif"));
        this.importDdlIPAction = new InfoPopAction((IAction)delegateImportDdlAction, 1, Messages.Options_Action_ImportDdl_description, this.imageHelper.IMPORT_JDBC_IMAGE);
        Action delegateImportFlatFileAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.importFlatFileCommand", true);
            }
        };
        delegateImportFlatFileAction.setText(Messages.Action_ImportFlatFile_text);
        delegateImportFlatFileAction.setToolTipText(Messages.Action_ImportFlatFile_tooltip);
        delegateImportFlatFileAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import-jdbc.gif"));
        this.importFlatFileIPAction = new InfoPopAction((IAction)delegateImportFlatFileAction, 1, Messages.Options_Action_ImportFlatFile_description, this.imageHelper.IMPORT_JDBC_IMAGE);
        Action delegateImportXmlFileAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.importXmlFileCommand", true);
            }
        };
        delegateImportXmlFileAction.setText(Messages.Action_ImportXmlFile_text);
        delegateImportXmlFileAction.setToolTipText(Messages.Action_ImportXmlFile_tooltip);
        delegateImportXmlFileAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import-jdbc.gif"));
        this.importXmlFileIPAction = new InfoPopAction((IAction)delegateImportXmlFileAction, 1, Messages.Options_Action_ImportXmlFile_description, this.imageHelper.IMPORT_JDBC_IMAGE);
        Action delegateImportSalesforceAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.importSalesforceCommand", true);
            }
        };
        delegateImportSalesforceAction.setText(Messages.Action_ImportSalesforce_text);
        delegateImportSalesforceAction.setToolTipText(Messages.Action_ImportSalesforce_tooltip);
        delegateImportSalesforceAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import-jdbc.gif"));
        this.importSalesforceIPAction = new InfoPopAction((IAction)delegateImportSalesforceAction, 1, Messages.Options_Action_ImportSalesforce_description, this.imageHelper.IMPORT_JDBC_IMAGE);
        Action delegateImportXsdAction = new Action(){

            public void run() {
                ModelerUiViewUtils.launchWizard((String)"xsdFileSystemImportWizard", (IStructuredSelection)new StructuredSelection(), (boolean)true);
            }
        };
        delegateImportXsdAction.setText(Messages.Action_ImportXsd_text);
        delegateImportXsdAction.setToolTipText(Messages.Action_ImportXsd_tooltip);
        delegateImportXsdAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_xsd.gif"));
        this.importXsdIPAction = new InfoPopAction((IAction)delegateImportXsdAction, 1, Messages.Options_Action_ImportXsd_description, this.imageHelper.IMPORT_XSD_IMAGE);
        Action delegateNewVdbAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.vdb.create", true);
            }
        };
        delegateNewVdbAction.setText(Messages.Action_NewVdb_text);
        delegateNewVdbAction.setToolTipText(Messages.Action_NewVdb_tooltip);
        delegateNewVdbAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/new-vdb-wiz.gif"));
        this.newVdbIPAction = new InfoPopAction((IAction)delegateNewVdbAction, 1, Messages.Options_Action_NewVdb_description, this.imageHelper.NEW_VDB_IMAGE);
        Action delegateEditVdbAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.vdb.edit", true);
            }
        };
        delegateEditVdbAction.setText(Messages.Action_EditVdb_text);
        delegateEditVdbAction.setToolTipText(Messages.Action_EditVdb_tooltip);
        delegateEditVdbAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/edit-vdb.png"));
        this.editVdbIPAction = new InfoPopAction((IAction)delegateEditVdbAction, 1, Messages.Options_Action_EditVdb_description, this.imageHelper.EDIT_VDB_IMAGE);
        Action delegateExecuteVdbAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.vdb.execute", true);
            }
        };
        delegateExecuteVdbAction.setText(Messages.Action_ExecuteVdb_text);
        delegateExecuteVdbAction.setToolTipText(Messages.Action_ExecuteVdb_tooltip);
        delegateExecuteVdbAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/execute-vdb.gif"));
        this.executeVdbIPAction = new InfoPopAction((IAction)delegateExecuteVdbAction, 0, Messages.Options_Action_ExecuteVdb_description, this.imageHelper.EXECUTE_VDB_IMAGE);
        Action delegatePreviewDataAction = new Action(){

            public void run() {
                AdvisorActionFactory.executeAction("org.teiid.designer.previewData", true);
            }
        };
        delegatePreviewDataAction.setText(Messages.Action_PreviewData_text);
        delegatePreviewDataAction.setToolTipText(Messages.Action_PreviewData_tooltip);
        delegatePreviewDataAction.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/preview-data.gif"));
        this.previewDataIPAction = new InfoPopAction((IAction)delegatePreviewDataAction, 2, Messages.Options_Action_PreviewData_description, this.imageHelper.PREVIEW_DATA_IMAGE);
        this.newRelationalSourceModelAction = new NewModelAction();
        Action delegateNewRelationalSourceModelAction = new Action(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).StatusActionHandler.this.newRelationalSourceModelAction.setModelType(ModelType.PHYSICAL_LITERAL);
                        (this).StatusActionHandler.this.newRelationalSourceModelAction.setMetamodelClass(StatusActionHandler.RELATIONAL_ID);
                        (this).StatusActionHandler.this.newRelationalSourceModelAction.run();
                    }
                });
            }
        };
        delegateNewRelationalSourceModelAction.setText(Messages.Action_NewSourceModel_text);
        delegateNewRelationalSourceModelAction.setToolTipText(Messages.Action_NewSourceModel_tooltip);
        this.newRelationalSourceModelIPAction = new InfoPopAction((IAction)delegateNewRelationalSourceModelAction, 1, Messages.Options_Action_NewRelationalSourceModel_description, this.imageHelper.NEW_MODEL_IMAGE);
        this.newRelationalViewModelAction = new NewModelAction();
        Action delegateNewRelationalViewModelAction = new Action(){

            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).StatusActionHandler.this.newRelationalViewModelAction.setModelType(ModelType.VIRTUAL_LITERAL);
                        (this).StatusActionHandler.this.newRelationalViewModelAction.setMetamodelClass(StatusActionHandler.RELATIONAL_ID);
                        (this).StatusActionHandler.this.newRelationalViewModelAction.run();
                    }
                });
            }
        };
        delegateNewRelationalViewModelAction.setText(Messages.Action_NewViewModel_text);
        delegateNewRelationalViewModelAction.setToolTipText(Messages.Action_NewViewModel_tooltip);
        this.newRelationalViewModelIPAction = new InfoPopAction((IAction)delegateNewRelationalViewModelAction, 1, Messages.Options_Action_NewRelationalViewModel_description, this.imageHelper.NEW_MODEL_IMAGE);
    }

    @Override
    public InfoPopAction[] getActions(int groupType) {
        ArrayList<InfoPopAction> actions = new ArrayList<InfoPopAction>();
        boolean hasErrors = false;
        switch (groupType) {
            case 8: {
                actions.add(this.newVdbIPAction);
                actions.add(this.editVdbIPAction);
                actions.add(this.executeVdbIPAction);
                break;
            }
            case 0: {
                if (this.getStatus() != null && this.getModelProjectStatus().getModelStatus() != null) {
                    hasErrors = this.getModelProjectStatus().getModelStatus().getSeverity() == 4;
                }
                actions.add(this.showProblemsViewIPAction);
                String desc = Messages.Options_Action_TurnAutobiuldOn_description;
                if (ModelerCore.getWorkspace().isAutoBuilding()) {
                    desc = Messages.Options_Action_TurnAutobiuldOff_description;
                }
                this.toggleAutoBuildIPAction.setDescription(desc);
                actions.add(this.toggleAutoBuildIPAction);
                break;
            }
            case 1: {
                if (this.getStatus() != null && this.getModelProjectStatus().getSourceModelsStatus() != null) {
                    boolean bl = hasErrors = this.getModelProjectStatus().getSourceModelsStatus().getSeverity() == 4;
                }
                if (hasErrors) {
                    actions.add(this.showProblemsViewIPAction);
                }
                actions.add(this.importJdbcIPAction);
                actions.add(this.importDdlIPAction);
                actions.add(this.importSalesforceIPAction);
                actions.add(this.newRelationalSourceModelIPAction);
                actions.add(this.previewDataIPAction);
                break;
            }
            case 3: {
                if (this.getStatus() != null && this.getModelProjectStatus().getViewModelsStatus() != null) {
                    boolean bl = hasErrors = this.getModelProjectStatus().getViewModelsStatus().getSeverity() == 4;
                }
                if (hasErrors) {
                    actions.add(this.showProblemsViewIPAction);
                }
                actions.add(this.newRelationalViewModelIPAction);
                actions.add(this.importFlatFileIPAction);
                actions.add(this.importXmlFileIPAction);
                actions.add(this.previewDataIPAction);
                break;
            }
            case 2: {
                actions.add(this.openDSEIPAction);
                actions.add(this.newJdbcCPIPAction);
                actions.add(this.newSFCPIPAction);
                actions.add(this.newWSSoapIPAction);
                break;
            }
            case 5: {
                if (this.getStatus() != null && this.getModelProjectStatus().getXmlSchemaFilesStatus() != null) {
                    boolean bl = hasErrors = this.getModelProjectStatus().getXmlSchemaFilesStatus().getSeverity() == 4;
                }
                if (hasErrors) {
                    actions.add(this.showProblemsViewIPAction);
                }
                actions.add(this.importXsdIPAction);
                break;
            }
            case 10: {
                actions.add(this.previewDataIPAction);
                actions.add(this.executeVdbIPAction);
                break;
            }
        }
        InfoPopAction[] ipArray = new InfoPopAction[actions.size()];
        int iCount = 0;
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            ipArray[iCount++] = (InfoPopAction)iter.next();
        }
        return ipArray;
    }

    @Override
    public AdvisorStatus getStatus() {
        return null;
    }

    private ModelProjectStatus getModelProjectStatus() {
        return this.status;
    }

    public void setStatus(ModelProjectStatus status) {
        this.status = status;
    }

    @Override
    public void setStatus(AdvisorStatus status) {
    }
}

