/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.Messages;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.Preferences;

public class Utils {
    public static String getNormalizedOidString(Dn dn, Schema schema) {
        StringBuffer sb = new StringBuffer();
        Iterator it = dn.getRdns().iterator();
        while (it.hasNext()) {
            Rdn rdn = (Rdn)it.next();
            sb.append(Utils.getOidString(rdn, schema));
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static String getOidString(Rdn rdn, Schema schema) {
        StringBuffer sb = new StringBuffer();
        Iterator it = rdn.iterator();
        while (it.hasNext()) {
            Ava ava = (Ava)it.next();
            sb.append(Utils.getOidString(ava, schema));
            if (!it.hasNext()) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    private static String getOidString(Ava ava, Schema schema) {
        String oid = schema != null ? schema.getAttributeTypeDescription(ava.getNormType()).getOid() : ava.getNormType();
        return String.valueOf(Strings.toLowerCase((String)Strings.trim((String)oid))) + "=" + Strings.trim((String)ava.getValue().getString()).toLowerCase();
    }

    public static String arrayToString(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(array[0]);
        int i = 1;
        while (i < array.length) {
            sb.append(", ");
            sb.append(array[i]);
            ++i;
        }
        return sb.toString();
    }

    public static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        int i = 0;
        while (i < data1.length) {
            if (data1[i] != data2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getShortenedString(String value, int length) {
        if (value == null) {
            return "";
        }
        if (value.length() > length) {
            value = String.valueOf(value.substring(0, length)) + "...";
        }
        return value;
    }

    public static String serialize(Object o) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            String s;
            Thread.currentThread().setContextClassLoader(Utils.class.getClassLoader());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(baos);
            encoder.writeObject(o);
            encoder.close();
            String string = s = LdifUtils.utf8decode((byte[])baos.toByteArray());
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public static Object deserialize(String s) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Utils.class.getClassLoader());
            ByteArrayInputStream bais = new ByteArrayInputStream(LdifUtils.utf8encode((String)s));
            XMLDecoder decoder = new XMLDecoder(bais);
            Object o = decoder.readObject();
            decoder.close();
            Object object = o;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public static String getNonNullString(Object o) {
        return o == null ? "-" : o.toString();
    }

    public static String formatBytes(long bytes) {
        String size = "";
        size = bytes > 0x100000L ? String.valueOf(size) + bytes / 1024L / 1024L + " " + Messages.Utils_MegaBytes + " (" + bytes + " " + Messages.Utils_Bytes + ")" : (bytes > 1024L ? String.valueOf(size) + bytes / 1024L + " " + Messages.Utils_KiloBytes + " (" + bytes + " " + Messages.Utils_Bytes + ")" : (bytes > 1L ? String.valueOf(size) + bytes + " " + Messages.Utils_Bytes : String.valueOf(size) + bytes + " " + Messages.Utils_Byte));
        return size;
    }

    public static boolean containsIgnoreCase(Collection<String> c, String s) {
        if (c == null || s == null) {
            return false;
        }
        for (String string : c) {
            if (!string.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static LdifFormatParameters getLdifFormatParameters() {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        boolean spaceAfterColon = store.getBoolean("ldifSpaceAfterColon");
        int lineWidth = store.getInt("ldifLineWidth");
        String lineSeparator = store.getString("ldifLineSeparator");
        LdifFormatParameters ldifFormatParameters = new LdifFormatParameters(spaceAfterColon, lineWidth, lineSeparator);
        return ldifFormatParameters;
    }

    public static LdapUrl getLdapURL(IBrowserConnection browserConnection) {
        LdapUrl url = new LdapUrl();
        if (browserConnection.getConnection() != null) {
            if (browserConnection.getConnection().getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS) {
                url.setScheme("ldaps://");
            } else {
                url.setScheme("ldap://");
            }
            url.setHost(browserConnection.getConnection().getHost());
            url.setPort(browserConnection.getConnection().getPort());
        }
        return url;
    }

    public static LdapUrl getLdapURL(IEntry entry) {
        LdapUrl url = Utils.getLdapURL(entry.getBrowserConnection());
        url.setDn(entry.getDn());
        return url;
    }

    public static LdapUrl getLdapURL(ISearch search) {
        LdapUrl url = Utils.getLdapURL(search.getBrowserConnection());
        url.setDn(search.getSearchBase());
        if (search.getReturningAttributes() != null) {
            url.setAttributes(Arrays.asList(search.getReturningAttributes()));
        }
        url.setScope(search.getScope().getScope());
        url.setFilter(search.getFilter());
        return url;
    }

    /*
     * Could not resolve type clashes
     */
    public static LdifFile computeDiff(IEntry oldEntry, IEntry newEntry) {
        IBrowserConnection.ModifyMode modifyMode = oldEntry.getBrowserConnection().getModifyMode();
        IBrowserConnection.ModifyMode modifyModeNoEMR = oldEntry.getBrowserConnection().getModifyModeNoEMR();
        IBrowserConnection.ModifyOrder modifyAddDeleteOrder = oldEntry.getBrowserConnection().getModifyAddDeleteOrder();
        HashSet<String> attributeDescriptions = new HashSet<String>();
        IAttribute[] iAttributeArray = oldEntry.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute oldAttr = iAttributeArray[n2];
            attributeDescriptions.add(oldAttr.getDescription());
            ++n2;
        }
        iAttributeArray = newEntry.getAttributes();
        n = iAttributeArray.length;
        n2 = 0;
        while (n2 < n) {
            IAttribute newAttr = iAttributeArray[n2];
            attributeDescriptions.add(newAttr.getDescription());
            ++n2;
        }
        LdifChangeModifyRecord record = new LdifChangeModifyRecord(LdifDnLine.create((String)newEntry.getDn().getName()));
        if (newEntry.isReferral()) {
            record.addControl(LdifControlLine.create((String)StudioControl.MANAGEDSAIT_CONTROL.getOid(), (boolean)StudioControl.MANAGEDSAIT_CONTROL.isCritical(), (byte[])StudioControl.MANAGEDSAIT_CONTROL.getControlValue()));
        }
        record.setChangeType(LdifChangeTypeLine.createModify());
        for (String attributeDescription : attributeDescriptions) {
            IValue value;
            LdifModSpec modSpec;
            Object attrValLine4;
            int n3;
            Schema schema = oldEntry.getBrowserConnection().getSchema();
            AttributeType atd = schema.getAttributeTypeDescription(attributeDescription);
            boolean hasEMR = SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(atd, schema) != null;
            boolean isReplaceForced = hasEMR && modifyMode == IBrowserConnection.ModifyMode.REPLACE || !hasEMR && modifyModeNoEMR == IBrowserConnection.ModifyMode.REPLACE;
            boolean isAddDelForced = hasEMR && modifyMode == IBrowserConnection.ModifyMode.ADD_DELETE || !hasEMR && modifyModeNoEMR == IBrowserConnection.ModifyMode.ADD_DELETE;
            boolean isOrderedValue = atd.getExtensions().containsKey("X-ORDERED") && ((List)atd.getExtensions().get("X-ORDERED")).contains("VALUES");
            IAttribute oldAttribute = oldEntry.getAttribute(attributeDescription);
            HashSet<String> oldValues = new HashSet<String>();
            LinkedHashMap<String, LdifAttrValLine> oldAttrValLines = new LinkedHashMap<String, LdifAttrValLine>();
            if (oldAttribute != null) {
                IValue[] iValueArray = oldAttribute.getValues();
                int n4 = iValueArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IValue value2 = iValueArray[n5];
                    LdifAttrValLine attrValLine2 = Utils.computeDiffCreateAttrValLine(value2);
                    oldValues.add(attrValLine2.getUnfoldedValue());
                    oldAttrValLines.put(attrValLine2.getUnfoldedValue(), attrValLine2);
                    ++n5;
                }
            }
            IAttribute newAttribute = newEntry.getAttribute(attributeDescription);
            HashSet<String> newValues = new HashSet<String>();
            LinkedHashMap<String, IValue[]> newAttrValLines = new LinkedHashMap<String, IValue[]>();
            if (newAttribute != null) {
                IValue[] iValueArray = newAttribute.getValues();
                n3 = iValueArray.length;
                int attrValLine2 = 0;
                while (attrValLine2 < n3) {
                    IValue value3 = iValueArray[attrValLine2];
                    attrValLine4 = Utils.computeDiffCreateAttrValLine(value3);
                    newValues.add(attrValLine4.getUnfoldedValue());
                    newAttrValLines.put(attrValLine4.getUnfoldedValue(), (IValue[])attrValLine4);
                    ++attrValLine2;
                }
            }
            if (oldAttribute != null && newAttribute == null) {
                modSpec = isReplaceForced ? LdifModSpec.createReplace((String)attributeDescription) : LdifModSpec.createDelete((String)attributeDescription);
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            if (oldAttribute == null && newAttribute != null) {
                modSpec = isReplaceForced ? LdifModSpec.createReplace((String)attributeDescription) : LdifModSpec.createAdd((String)attributeDescription);
                attrValLine4 = newAttribute.getValues();
                int n6 = ((IValue[])attrValLine4).length;
                n3 = 0;
                while (n3 < n6) {
                    value = attrValLine4[n3];
                    modSpec.addAttrVal(Utils.computeDiffCreateAttrValLine(value));
                    ++n3;
                }
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            if (oldAttribute == null || newAttribute == null || oldValues.equals(newValues)) continue;
            if (isReplaceForced) {
                modSpec = LdifModSpec.createReplace((String)attributeDescription);
                attrValLine4 = newAttribute.getValues();
                int n7 = ((IValue[])attrValLine4).length;
                n3 = 0;
                while (n3 < n7) {
                    value = attrValLine4[n3];
                    modSpec.addAttrVal(Utils.computeDiffCreateAttrValLine(value));
                    ++n3;
                }
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            ArrayList<LdifAttrValLine> toDel = new ArrayList<LdifAttrValLine>();
            ArrayList<LdifAttrValLine> toAdd = new ArrayList<LdifAttrValLine>();
            for (Map.Entry entry : oldAttrValLines.entrySet()) {
                if (newValues.contains(entry.getKey())) continue;
                toDel.add((LdifAttrValLine)entry.getValue());
            }
            for (Map.Entry entry : newAttrValLines.entrySet()) {
                if (oldValues.contains(entry.getKey())) continue;
                toAdd.add((LdifAttrValLine)entry.getValue());
            }
            if (isAddDelForced || toAdd.size() + toDel.size() <= newAttrValLines.size() && !isOrderedValue || !toDel.isEmpty() && toAdd.isEmpty() || !toAdd.isEmpty() && toDel.isEmpty()) {
                LdifModSpec addModSpec = LdifModSpec.createAdd((String)attributeDescription);
                for (LdifAttrValLine attrValLine3 : toAdd) {
                    addModSpec.addAttrVal(attrValLine3);
                }
                addModSpec.finish(LdifModSpecSepLine.create());
                LdifModSpec delModSpec = LdifModSpec.createDelete((String)attributeDescription);
                for (Object attrValLine4 : toDel) {
                    delModSpec.addAttrVal((LdifAttrValLine)attrValLine4);
                }
                delModSpec.finish(LdifModSpecSepLine.create());
                if (modifyAddDeleteOrder == IBrowserConnection.ModifyOrder.DELETE_FIRST) {
                    if (delModSpec.getAttrVals().length > 0) {
                        record.addModSpec(delModSpec);
                    }
                    if (addModSpec.getAttrVals().length <= 0) continue;
                    record.addModSpec(addModSpec);
                    continue;
                }
                if (addModSpec.getAttrVals().length > 0) {
                    record.addModSpec(addModSpec);
                }
                if (delModSpec.getAttrVals().length <= 0) continue;
                record.addModSpec(delModSpec);
                continue;
            }
            LdifModSpec modSpec2 = LdifModSpec.createReplace((String)attributeDescription);
            for (LdifAttrValLine attrValLine3 : newAttrValLines.values()) {
                modSpec2.addAttrVal(attrValLine3);
            }
            modSpec2.finish(LdifModSpecSepLine.create());
            record.addModSpec(modSpec2);
        }
        record.finish(LdifSepLine.create());
        LdifFile model = new LdifFile();
        if (record.isValid() && record.getModSpecs().length > 0) {
            model.addContainer((LdifContainer)record);
        }
        return model.getRecords().length > 0 ? model : null;
    }

    private static LdifAttrValLine computeDiffCreateAttrValLine(IValue value) {
        IAttribute attribute = value.getAttribute();
        if (attribute.isBinary()) {
            return LdifAttrValLine.create((String)attribute.getDescription(), (byte[])value.getBinaryValue());
        }
        return LdifAttrValLine.create((String)attribute.getDescription(), (String)value.getStringValue());
    }
}

