/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.PagedResultsResponseControl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.StudioPagedResultsControl;
import org.apache.directory.studio.connection.core.io.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.SearchUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.ContinuedSearchResultEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Entry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.core.runtime.IProgressMonitor;

public class SearchRunnable
implements StudioConnectionBulkRunnableWithProgress {
    protected ISearch[] searches;
    protected ISearch[] searchesToPerform;

    public SearchRunnable(ISearch[] searches) {
        this.searches = searches;
        this.searchesToPerform = searches;
    }

    private SearchRunnable(ISearch search, ISearch searchToPerform) {
        this.searches = new ISearch[]{search};
        this.searchesToPerform = new ISearch[]{searchToPerform};
    }

    public Connection[] getConnections() {
        Connection[] connections = new Connection[this.searches.length];
        int i = 0;
        while (i < connections.length) {
            connections[i] = this.searches[i].getBrowserConnection().getConnection();
            ++i;
        }
        return connections;
    }

    public String getName() {
        return BrowserCoreMessages.jobs__search_name;
    }

    public Object[] getLockedObjects() {
        ArrayList<ISearch> l = new ArrayList<ISearch>();
        l.addAll(Arrays.asList(this.searches));
        return l.toArray();
    }

    public String getErrorMessage() {
        return this.searches.length == 1 ? BrowserCoreMessages.jobs__search_error_1 : BrowserCoreMessages.jobs__search_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.searches.length + 1);
        monitor.reportProgress(" ");
        int pi = 0;
        while (pi < this.searches.length) {
            ISearch search = this.searches[pi];
            ISearch searchToPerform = this.searchesToPerform[pi];
            monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__search_task, (Object[])new String[]{search.getName()}));
            monitor.worked(1);
            if (search.getBrowserConnection() != null) {
                search.setSearchResults(new ISearchResult[0]);
                search.getResponseControls().clear();
                search.setNextPageSearchRunnable(null);
                search.setTopPageSearchRunnable(null);
                searchToPerform.setSearchResults(new ISearchResult[0]);
                searchToPerform.setNextPageSearchRunnable(null);
                searchToPerform.setTopPageSearchRunnable(null);
                searchToPerform.getResponseControls().clear();
                do {
                    SearchRunnable.searchAndUpdateModel(searchToPerform.getBrowserConnection(), searchToPerform, monitor);
                    if (search != searchToPerform) {
                        ISearchResult[] sr1 = search.getSearchResults();
                        ISearchResult[] sr2 = searchToPerform.getSearchResults();
                        ISearchResult[] sr = new ISearchResult[sr1.length + sr2.length];
                        System.arraycopy(sr1, 0, sr, 0, sr1.length);
                        System.arraycopy(sr2, 0, sr, sr1.length, sr2.length);
                        search.setSearchResults(sr);
                    } else {
                        search.setSearchResults(searchToPerform.getSearchResults());
                    }
                    ISearch clonedSearch = (ISearch)searchToPerform.clone();
                    clonedSearch.getResponseControls().clear();
                    StudioPagedResultsControl sprResponseControl = null;
                    StudioPagedResultsControl sprRequestControl = null;
                    for (StudioControl responseControl : searchToPerform.getResponseControls()) {
                        if (!(responseControl instanceof StudioPagedResultsControl)) continue;
                        sprResponseControl = (StudioPagedResultsControl)responseControl;
                    }
                    Iterator<StudioControl> it = clonedSearch.getControls().iterator();
                    while (it.hasNext()) {
                        StudioControl requestControl = it.next();
                        if (!(requestControl instanceof StudioPagedResultsControl)) continue;
                        sprRequestControl = (StudioPagedResultsControl)requestControl;
                        it.remove();
                    }
                    searchToPerform = null;
                    if (sprResponseControl == null || sprRequestControl == null) continue;
                    StudioPagedResultsControl nextSpsc = new StudioPagedResultsControl(sprRequestControl.getSize(), sprResponseControl.getCookie(), sprRequestControl.isCritical(), sprRequestControl.isScrollMode());
                    ISearch nextPageSearch = (ISearch)clonedSearch.clone();
                    nextPageSearch.getResponseControls().clear();
                    nextPageSearch.getControls().add((StudioControl)nextSpsc);
                    if (sprRequestControl.isScrollMode()) {
                        if (sprRequestControl.getCookie() != null) {
                            ISearch topPageSearch = (ISearch)search.clone();
                            topPageSearch.getResponseControls().clear();
                            SearchRunnable topPageSearchRunnable = new SearchRunnable(search, topPageSearch);
                            search.setTopPageSearchRunnable(topPageSearchRunnable);
                        }
                        if (sprResponseControl.getCookie() == null) continue;
                        SearchRunnable nextPageSearchRunnable = new SearchRunnable(search, nextPageSearch);
                        search.setNextPageSearchRunnable(nextPageSearchRunnable);
                        continue;
                    }
                    if (sprResponseControl.getCookie() == null || search.getCountLimit() != 0 && search.getSearchResults().length >= search.getCountLimit()) continue;
                    searchToPerform = nextPageSearch;
                } while (searchToPerform != null);
            }
            ++pi;
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        int pi = 0;
        while (pi < this.searches.length) {
            EventRegistry.fireSearchUpdated(new SearchUpdateEvent(this.searches[pi], SearchUpdateEvent.EventDetail.SEARCH_PERFORMED), this);
            ++pi;
        }
    }

    public static void searchAndUpdateModel(IBrowserConnection browserConnection, ISearch search, StudioProgressMonitor monitor) {
        block19: {
            if (browserConnection.getConnection() == null) {
                return;
            }
            try {
                if (monitor.isCanceled()) break block19;
                SearchParameter searchParameter = SearchRunnable.getSearchParameter(search);
                ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>();
                ArrayList<SearchContinuation> searchContinuationList = new ArrayList<SearchContinuation>();
                StudioNamingEnumeration enumeration = null;
                try {
                    enumeration = SearchRunnable.search(browserConnection, searchParameter, monitor);
                    while (!monitor.isCanceled() && enumeration != null && enumeration.hasMore()) {
                        StudioSearchResult sr = (StudioSearchResult)enumeration.next();
                        boolean isContinuedSearchResult = sr.isContinuedSearchResult();
                        LdapUrl searchContinuationUrl = sr.getSearchContinuationUrl();
                        if (searchContinuationUrl == null) {
                            Dn dn = JNDIUtils.getDn((javax.naming.directory.SearchResult)sr);
                            IEntry entry = null;
                            Connection resultConnection = sr.getConnection();
                            IBrowserConnection resultBrowserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(resultConnection);
                            if (resultBrowserConnection == null) {
                                resultBrowserConnection = browserConnection;
                            }
                            if ((entry = resultBrowserConnection.getEntryFromCache(dn)) == null && (entry = SearchRunnable.createAndCacheEntry(resultBrowserConnection, dn, monitor)) == null) {
                                return;
                            }
                            SearchRunnable.initFlags(entry, (javax.naming.directory.SearchResult)sr, searchParameter);
                            SearchRunnable.fillAttributes(entry, (javax.naming.directory.SearchResult)sr, search.getSearchParameter());
                            if (isContinuedSearchResult) {
                                entry = new ContinuedSearchResultEntry(resultBrowserConnection, dn);
                            }
                            searchResultList.add(new SearchResult(entry, search));
                        } else {
                            SearchContinuation searchContinuation = new SearchContinuation(search, searchContinuationUrl);
                            searchContinuationList.add(searchContinuation);
                        }
                        monitor.reportProgress(searchResultList.size() == 1 ? BrowserCoreMessages.model__retrieved_1_entry : BrowserCoreMessages.bind((String)BrowserCoreMessages.model__retrieved_n_entries, (Object[])new String[]{Integer.toString(searchResultList.size())}));
                    }
                }
                catch (Exception e) {
                    int ldapStatusCode = JNDIUtils.getLdapStatusCode(e);
                    if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) {
                        search.setCountLimitExceeded(true);
                    }
                    monitor.reportError(e);
                }
                try {
                    Control[] jndiControls;
                    if (enumeration != null && (jndiControls = enumeration.getResponseControls()) != null) {
                        Control[] controlArray = jndiControls;
                        int n = jndiControls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control jndiControl = controlArray[n2];
                            if (jndiControl instanceof PagedResultsResponseControl) {
                                PagedResultsResponseControl prrc = (PagedResultsResponseControl)jndiControl;
                                StudioPagedResultsControl studioControl = new StudioPagedResultsControl(prrc.getResultSize(), prrc.getCookie(), prrc.isCritical(), false);
                                search.getResponseControls().add((StudioControl)studioControl);
                                search.setCountLimitExceeded(prrc.getCookie() != null);
                            } else {
                                StudioControl studioControl = new StudioControl();
                                studioControl.setOid(jndiControl.getID());
                                studioControl.setCritical(jndiControl.isCritical());
                                studioControl.setControlValue(jndiControl.getEncodedValue());
                                search.getResponseControls().add(studioControl);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    monitor.reportError(e);
                }
                monitor.reportProgress(searchResultList.size() == 1 ? BrowserCoreMessages.model__retrieved_1_entry : BrowserCoreMessages.bind((String)BrowserCoreMessages.model__retrieved_n_entries, (Object[])new String[]{Integer.toString(searchResultList.size())}));
                monitor.worked(1);
                search.setSearchResults(searchResultList.toArray(new ISearchResult[searchResultList.size()]));
                search.setSearchContinuations(searchContinuationList.toArray(new SearchContinuation[searchContinuationList.size()]));
            }
            catch (Exception e) {
                if (search != null) {
                    search.setSearchResults(new ISearchResult[0]);
                }
                monitor.reportError(e);
            }
        }
    }

    public static StudioNamingEnumeration search(IBrowserConnection browserConnection, SearchParameter parameter, StudioProgressMonitor monitor) {
        if (browserConnection == null) {
            return null;
        }
        String searchBase = parameter.getSearchBase().getName();
        SearchControls controls = new SearchControls();
        SearchScope scope = parameter.getScope();
        switch (scope) {
            case OBJECT: {
                controls.setSearchScope(0);
                break;
            }
            case ONELEVEL: {
                controls.setSearchScope(1);
                break;
            }
            case SUBTREE: {
                controls.setSearchScope(2);
                break;
            }
            default: {
                controls.setSearchScope(1);
            }
        }
        controls.setReturningAttributes(parameter.getReturningAttributes());
        controls.setCountLimit(parameter.getCountLimit());
        int timeLimit = parameter.getTimeLimit() * 1000;
        if (timeLimit > 1) {
            --timeLimit;
        }
        controls.setTimeLimit(timeLimit);
        String filter = parameter.getFilter();
        Connection.AliasDereferencingMethod aliasesDereferencingMethod = parameter.getAliasesDereferencingMethod();
        Connection.ReferralHandlingMethod referralsHandlingMethod = parameter.getReferralsHandlingMethod();
        Control[] jndiControls = null;
        if (parameter.getControls() != null) {
            List<StudioControl> ctls = parameter.getControls();
            jndiControls = new Control[ctls.size()];
            int i = 0;
            while (i < ctls.size()) {
                StudioControl ctl = ctls.get(i);
                jndiControls[i] = new BasicControl(ctl.getOid(), ctl.isCritical(), ctl.getControlValue());
                ++i;
            }
        }
        StudioNamingEnumeration result = browserConnection.getConnection().getConnectionWrapper().search(searchBase, filter, controls, aliasesDereferencingMethod, referralsHandlingMethod, jndiControls, monitor, null);
        return result;
    }

    private static SearchParameter getSearchParameter(ISearch search) {
        String[] returningAttributes;
        SearchParameter searchParameter = (SearchParameter)search.getSearchParameter().clone();
        if (search.isInitHasChildrenFlag()) {
            if (search.getBrowserConnection().getSchema().hasAttributeTypeDescription("hasSubordinates") && !Utils.containsIgnoreCase(Arrays.asList(searchParameter.getReturningAttributes()), "hasSubordinates")) {
                returningAttributes = new String[searchParameter.getReturningAttributes().length + 1];
                System.arraycopy(searchParameter.getReturningAttributes(), 0, returningAttributes, 0, searchParameter.getReturningAttributes().length);
                returningAttributes[returningAttributes.length - 1] = "hasSubordinates";
                searchParameter.setReturningAttributes(returningAttributes);
            } else if (search.getBrowserConnection().getSchema().hasAttributeTypeDescription("numSubordinates") && !Utils.containsIgnoreCase(Arrays.asList(searchParameter.getReturningAttributes()), "numSubordinates")) {
                returningAttributes = new String[searchParameter.getReturningAttributes().length + 1];
                System.arraycopy(searchParameter.getReturningAttributes(), 0, returningAttributes, 0, searchParameter.getReturningAttributes().length);
                returningAttributes[returningAttributes.length - 1] = "numSubordinates";
                searchParameter.setReturningAttributes(returningAttributes);
            } else if (search.getBrowserConnection().getSchema().hasAttributeTypeDescription("subordinateCount") && !Utils.containsIgnoreCase(Arrays.asList(searchParameter.getReturningAttributes()), "subordinateCount")) {
                returningAttributes = new String[searchParameter.getReturningAttributes().length + 1];
                System.arraycopy(searchParameter.getReturningAttributes(), 0, returningAttributes, 0, searchParameter.getReturningAttributes().length);
                returningAttributes[returningAttributes.length - 1] = "subordinateCount";
                searchParameter.setReturningAttributes(returningAttributes);
            }
        }
        if (!Utils.containsIgnoreCase(Arrays.asList(searchParameter.getReturningAttributes()), "objectClass") && !Utils.containsIgnoreCase(Arrays.asList(searchParameter.getReturningAttributes()), "*")) {
            returningAttributes = new String[searchParameter.getReturningAttributes().length + 1];
            System.arraycopy(searchParameter.getReturningAttributes(), 0, returningAttributes, 0, searchParameter.getReturningAttributes().length);
            returningAttributes[returningAttributes.length - 1] = "objectClass";
            searchParameter.setReturningAttributes(returningAttributes);
        }
        if (searchParameter.getControls() != null) {
            IBrowserConnection connection = search.getBrowserConnection();
            HashSet<String> supportedConrolSet = new HashSet<String>();
            if (connection.getRootDSE() != null && connection.getRootDSE().getAttribute("supportedControl") != null) {
                IAttribute scAttribute = connection.getRootDSE().getAttribute("supportedControl");
                String[] supportedControls = scAttribute.getStringValues();
                int i = 0;
                while (i < supportedControls.length) {
                    supportedConrolSet.add(Strings.toLowerCase((String)supportedControls[i]));
                    ++i;
                }
            }
            List<StudioControl> controls = searchParameter.getControls();
            Iterator<StudioControl> it = controls.iterator();
            while (it.hasNext()) {
                StudioControl control = it.next();
                if (supportedConrolSet.contains(Strings.toLowerCase((String)control.getOid()))) continue;
                it.remove();
            }
        }
        return searchParameter;
    }

    private static IEntry createAndCacheEntry(IBrowserConnection browserConnection, Dn dn, StudioProgressMonitor monitor) {
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        IEntry entry = null;
        LinkedList<Dn> parentDnList = new LinkedList<Dn>();
        Dn parentDn = dn;
        while (parentDn != null && browserConnection.getEntryFromCache(parentDn) == null) {
            parentDnList.addFirst(parentDn);
            parentDn = parentDn.getParent();
        }
        for (Dn aDn : parentDnList) {
            parentDn = aDn.getParent();
            if (parentDn == null) {
                entry = browserConnection.getRootDSE();
                continue;
            }
            if (!parentDn.isEmpty() && browserConnection.getEntryFromCache(parentDn) != null) {
                IEntry parentEntry = browserConnection.getEntryFromCache(parentDn);
                entry = new Entry(parentEntry, aDn.getRdn());
                entry.setDirectoryEntry(true);
                parentEntry.addChild(entry);
                parentEntry.setChildrenInitialized(true);
                parentEntry.setHasMoreChildren(true);
                parentEntry.setHasChildrenHint(true);
                browserConnection.cacheEntry(entry);
                continue;
            }
            SearchParameter searchParameter = new SearchParameter();
            searchParameter.setSearchBase(aDn);
            searchParameter.setFilter(null);
            searchParameter.setReturningAttributes(ISearch.NO_ATTRIBUTES);
            searchParameter.setScope(SearchScope.OBJECT);
            searchParameter.setCountLimit(1);
            searchParameter.setTimeLimit(0);
            searchParameter.setAliasesDereferencingMethod(browserConnection.getAliasesDereferencingMethod());
            searchParameter.setReferralsHandlingMethod(browserConnection.getReferralsHandlingMethod());
            searchParameter.setInitHasChildrenFlag(true);
            dummyMonitor.reset();
            StudioNamingEnumeration enumeration = SearchRunnable.search(browserConnection, searchParameter, dummyMonitor);
            try {
                if (enumeration == null || !enumeration.hasMore()) continue;
                entry = new BaseDNEntry(aDn, browserConnection);
                browserConnection.getRootDSE().addChild(entry);
                browserConnection.cacheEntry(entry);
                enumeration.close();
            }
            catch (NamingException namingException) {}
        }
        return entry;
    }

    private static void initFlags(IEntry entry, javax.naming.directory.SearchResult sr, SearchParameter searchParameter) throws NamingException {
        NamingEnumeration<? extends javax.naming.directory.Attribute> attributeEnumeration = sr.getAttributes().getAll();
        while (attributeEnumeration.hasMore()) {
            javax.naming.directory.Attribute attribute = attributeEnumeration.next();
            if (attribute == null) continue;
            String attributeDescription = attribute.getID();
            NamingEnumeration<?> valueEnumeration = attribute.getAll();
            if ("objectClass".equalsIgnoreCase(attributeDescription)) {
                if (entry.getAttribute(attributeDescription) != null) {
                    entry.deleteAttribute(entry.getAttribute(attributeDescription));
                }
                entry.addAttribute(new Attribute(entry, attributeDescription));
            }
            while (valueEnumeration.hasMore()) {
                Object o = valueEnumeration.next();
                if (!(o instanceof String)) continue;
                String value = (String)o;
                if (searchParameter.isInitHasChildrenFlag()) {
                    if ("hasSubordinates".equalsIgnoreCase(attributeDescription) && "FALSE".equalsIgnoreCase(value)) {
                        entry.setHasChildrenHint(false);
                    }
                    if ("numSubordinates".equalsIgnoreCase(attributeDescription) && "0".equalsIgnoreCase(value)) {
                        entry.setHasChildrenHint(false);
                    }
                    if ("subordinateCount".equalsIgnoreCase(attributeDescription) && "0".equalsIgnoreCase(value)) {
                        entry.setHasChildrenHint(false);
                    }
                }
                if (!"objectClass".equalsIgnoreCase(attributeDescription)) continue;
                if ("alias".equalsIgnoreCase(value)) {
                    entry.setAlias(true);
                    entry.setHasChildrenHint(false);
                }
                if ("referral".equalsIgnoreCase(value)) {
                    entry.setReferral(true);
                    entry.setHasChildrenHint(false);
                }
                IAttribute ocAttribute = entry.getAttribute(attributeDescription);
                Value ocValue = new Value(ocAttribute, value);
                ocAttribute.addValue(ocValue);
            }
        }
        if (searchParameter.getControls() != null && searchParameter.getControls().contains(StudioControl.SUBENTRIES_CONTROL) || "(|(objectClass=subentry)(objectClass=ldapSubentry))".equalsIgnoreCase(searchParameter.getFilter())) {
            entry.setSubentry(true);
            entry.setHasChildrenHint(false);
        }
    }

    private static void fillAttributes(IEntry entry, javax.naming.directory.SearchResult sr, SearchParameter searchParameter) throws NamingException {
        if (searchParameter.getReturningAttributes() == null || searchParameter.getReturningAttributes().length > 0) {
            if (searchParameter.getReturningAttributes() != null) {
                int i;
                IAttribute[] oldAttributes;
                String[] ras = searchParameter.getReturningAttributes();
                if (Arrays.asList(ras).contains("*")) {
                    oldAttributes = entry.getAttributes();
                    i = 0;
                    while (oldAttributes != null && i < oldAttributes.length) {
                        if (!oldAttributes[i].isOperationalAttribute()) {
                            entry.deleteAttribute(oldAttributes[i]);
                        }
                        ++i;
                    }
                }
                if (Arrays.asList(ras).contains("+")) {
                    oldAttributes = entry.getAttributes();
                    i = 0;
                    while (oldAttributes != null && i < oldAttributes.length) {
                        if (oldAttributes[i].isOperationalAttribute()) {
                            entry.deleteAttribute(oldAttributes[i]);
                        }
                        ++i;
                    }
                }
                int r = 0;
                while (r < ras.length) {
                    AttributeHierarchy ah = entry.getAttributeWithSubtypes(ras[r]);
                    if (ah != null) {
                        for (IAttribute attribute : ah) {
                            entry.deleteAttribute(attribute);
                        }
                    }
                    ++r;
                }
            } else {
                IAttribute[] oldAttributes = entry.getAttributes();
                int i = 0;
                while (oldAttributes != null && i < oldAttributes.length) {
                    entry.deleteAttribute(oldAttributes[i]);
                    ++i;
                }
            }
            NamingEnumeration<? extends javax.naming.directory.Attribute> attributeEnumeration = sr.getAttributes().getAll();
            while (attributeEnumeration.hasMore()) {
                javax.naming.directory.Attribute attribute = attributeEnumeration.next();
                String attributeDescription = attribute.getID();
                IAttribute oldAttribute = entry.getAttribute(attributeDescription);
                if (oldAttribute == null) continue;
                entry.deleteAttribute(oldAttribute);
            }
            attributeEnumeration = sr.getAttributes().getAll();
            while (attributeEnumeration.hasMore()) {
                javax.naming.directory.Attribute attribute = attributeEnumeration.next();
                String attributeDescription = attribute.getID();
                if (!attribute.getAll().hasMore()) continue;
                IAttribute studioAttribute = null;
                if (entry.getAttribute(attributeDescription) == null) {
                    studioAttribute = new Attribute(entry, attributeDescription);
                    entry.addAttribute(studioAttribute);
                } else {
                    studioAttribute = entry.getAttribute(attributeDescription);
                }
                NamingEnumeration<?> valueEnumeration = attribute.getAll();
                while (valueEnumeration.hasMore()) {
                    Object value = valueEnumeration.next();
                    studioAttribute.addValue(new Value(studioAttribute, value));
                }
            }
        }
    }
}

