/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dnd;

import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.dnd.FileDropTargetListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class TextDropTargetListener
extends FileDropTargetListener {
    public TextDropTargetListener(GraphicalViewer viewer, BPELEditor editor) {
        super(viewer, editor);
    }

    @Override
    public void drop(DropTargetEvent event) {
        if (this.getTransfer().isSupportedType(event.currentDataType)) {
            String data = (String)this.getTextTransfer().nativeToJava(event.currentDataType);
            if (data == null) {
                return;
            }
            if (!((data = data.trim()).startsWith("http://") || data.startsWith("https://") || data.startsWith("ftp://") || data.startsWith("ftps://"))) {
                return;
            }
            URI uri = null;
            try {
                uri = URI.createURI((String)data);
                this.startImport();
                this.addImport(this.attemptLoad(uri), uri);
                this.endImport(event);
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    @Override
    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    public TextTransfer getTextTransfer() {
        return (TextTransfer)this.getTransfer();
    }

    @Override
    public boolean isEnabled(DropTargetEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String data = (String)TextTransfer.getInstance().nativeToJava(event.currentDataType);
            if (data == null) {
                return false;
            }
            return (data = data.trim()).startsWith("http://") || data.startsWith("https://");
        }
        return false;
    }
}

