/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.wizards;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.fuse.transformation.camel.CamelConfigBuilder;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelConfigurationHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelFileTypeHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformTestWizardPage;

public class NewTransformationTestWizard
extends NewElementWizard
implements INewWizard {
    static final String DEFAULT_DOZER_CONFIG_FILE_NAME = "dozerBeanMapping.xml";
    IProject project;
    IJavaProject javaProject;
    IFile camelConfigFile;
    CamelConfigBuilder builder;
    String transformID = null;
    String packageName = null;
    String className = null;
    private TransformTestWizardPage _page = null;
    private static final String JDT_EDITOR = "org.eclipse.jdt.ui.CompilationUnitEditor";

    public NewTransformationTestWizard() {
        this.setWindowTitle("New Fuse Transformation Test");
        this._page = new TransformTestWizardPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this._page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._page.setTypeName("TransformationTest", true);
        if (selection.size() != 1) {
            return;
        }
        this._page.init(selection);
        Object selectedObject = selection.getFirstElement();
        if (selectedObject != null) {
            IResource findCamelContext;
            IFile selectedFile;
            boolean isCamelConfig;
            if (selectedObject instanceof IResource) {
                this.project = ((IResource)selectedObject).getProject();
            }
            if (selectedObject instanceof IFile && (isCamelConfig = CamelFileTypeHelper.isSupportedCamelFile(this.project, (selectedFile = (IFile)selectedObject).getProjectRelativePath().toPortableString()))) {
                this.camelConfigFile = selectedFile;
            }
            if (this.project != null) {
                this._page.setProject(this.project);
                this.javaProject = JavaCore.create((IProject)this.project);
            }
            if (this.project != null && this.camelConfigFile == null && (findCamelContext = this.project.findMember("src/main/resources/META-INF/spring/camel-context.xml")) != null) {
                this.camelConfigFile = (IFile)findCamelContext;
            }
            if (this.camelConfigFile != null) {
                this._page.setCamelConfigFile(this.camelConfigFile);
                File file = new File(this.camelConfigFile.getLocationURI());
                try {
                    this.builder = CamelConfigurationHelper.load(file).getConfigBuilder();
                    this._page.setBuilder(this.builder);
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
            if (this.javaProject != null) {
                this._page.setJavaProject(this.javaProject);
                IFolder srcFolder = this.javaProject.getProject().getFolder("src/test/java");
                if (!JavaUtil.findFolderOnProjectClasspath(this.javaProject, (IResource)srcFolder)) {
                    JavaUtil.addFolderToProjectClasspath(this.javaProject, (IResource)srcFolder);
                }
                if (!srcFolder.exists()) {
                    try {
                        srcFolder.refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)srcFolder);
                this._page.setPackageFragmentRoot(root, true);
            }
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.getContainer().getCurrentPage() == this._page;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this._page.createType(monitor);
        if (this._page.getGeneratedResource() != null) {
            if (this.project == null && this._page.getProject() != null) {
                this.project = this._page.getProject();
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "TransformationEditor", "Problem encountered while creating test class."));
        }
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IFile resource = (IFile)this._page.getGeneratedResource();
        this.openResource(resource);
    }

    public IJavaElement getCreatedElement() {
        return this._page.getCreatedType();
    }

    protected void openResource(final IFile resource) {
        if (resource.getType() != 1) {
            return;
        }
        Display display = this.getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage activePage = window.getActivePage();
                if (activePage != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (String)NewTransformationTestWizard.JDT_EDITOR, (boolean)true);
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

