/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.StartPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformationTypePage;
import org.jboss.tools.fuse.transformation.editor.wizards.NewTransformationWizard;

public abstract class XformWizardPage
extends WizardPage {
    final DataBindingContext context = new DataBindingContext(SWTObservables.getRealm((Display)Display.getCurrent()));
    final ObservablesManager observablesManager = new ObservablesManager();
    final Model model;
    protected int decoratorPosition = 128;

    protected XformWizardPage(String pageName, Model model) {
        super(pageName);
        this.model = model;
    }

    protected XformWizardPage(String pageName, String title, ImageDescriptor titleImage, Model model) {
        this(pageName, model);
        this.setTitle(title);
        this.setImageDescriptor(titleImage);
    }

    protected Label createLabel(Composite parent, int style, String labeltext, String tooltip) {
        Label label = new Label(parent, style);
        label.setText(labeltext);
        label.setToolTipText(tooltip);
        return label;
    }

    protected Label createLabel(Composite parent, String labeltext, String tooltip) {
        return this.createLabel(parent, 0, labeltext, tooltip);
    }

    public void createControl(Composite parent) {
        this.setErrorMessage(null);
    }

    public IWizardPage getNextPage() {
        if (this instanceof StartPage) {
            return this.getSourcePage();
        }
        if (this instanceof TransformationTypePage) {
            TransformationTypePage page = (TransformationTypePage)((Object)this);
            if (page.isSourcePage()) {
                return this.getTargetPage();
            }
            return null;
        }
        return super.getNextPage();
    }

    public void resetFinish() {
        this.setPageComplete(false);
        this.pingBinding();
        this.notifyListeners();
    }

    public void clearControls() {
    }

    public void notifyListeners() {
    }

    public IWizardPage getSourcePage() {
        if (this.model.getSourceTypeStr() != null && !this.model.getSourceTypeStr().trim().isEmpty()) {
            if (this.model.getSourceTypeStr().equalsIgnoreCase("java")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.javaSource;
            }
            if (this.model.getSourceTypeStr().equalsIgnoreCase("xml")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.xmlSource;
            }
            if (this.model.getSourceTypeStr().equalsIgnoreCase("json")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.jsonSource;
            }
            if (this.model.getSourceTypeStr().equalsIgnoreCase("other")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.otherSource;
            }
        }
        return null;
    }

    public IWizardPage getTargetPage() {
        if (this.model.getTargetTypeStr() != null && !this.model.getTargetTypeStr().trim().isEmpty()) {
            if (this.model.getTargetTypeStr().equalsIgnoreCase("java")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.javaTarget;
            }
            if (this.model.getTargetTypeStr().equalsIgnoreCase("xml")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.xmlTarget;
            }
            if (this.model.getTargetTypeStr().equalsIgnoreCase("json")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.jsonTarget;
            }
            if (this.model.getTargetTypeStr().equalsIgnoreCase("other")) {
                NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
                return wizard.otherTarget;
            }
        }
        return null;
    }

    void validatePage() {
        this.setPageComplete(this.getErrorMessage() == null);
        NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
        StartPage startPage = (StartPage)wizard.getStartingPage();
        XformWizardPage pageToRefresh = null;
        if (startPage != null && startPage.getSourcePage() != null && startPage.getSourcePage().equals((Object)this)) {
            pageToRefresh = (XformWizardPage)startPage.getTargetPage();
            pageToRefresh.pingBinding();
        }
    }

    public boolean isSourceOrTargetPage() {
        NewTransformationWizard wizard = (NewTransformationWizard)this.getWizard();
        StartPage startPage = (StartPage)wizard.getStartingPage();
        if (startPage.getSourcePage().equals((Object)this)) {
            return true;
        }
        return startPage.getTargetPage().equals((Object)this);
    }

    protected Model getModel() {
        return this.model;
    }

    public void pingBinding() {
    }

    protected void listenForValidationChanges() {
        if (this.context != null) {
            IObservableList bindings = this.context.getValidationStatusProviders();
            ValidationChangedListener listener = new ValidationChangedListener();
            for (Object o : bindings) {
                Binding b = (Binding)o;
                b.getTarget().addChangeListener((IChangeListener)listener);
            }
        }
    }

    protected void notifyControl(Control cntrl, int event) {
        if (cntrl != null && !cntrl.isDisposed()) {
            cntrl.notifyListeners(event, new Event());
        }
    }

    class ValidationChangedListener
    implements IChangeListener {
        ValidationChangedListener() {
        }

        public void handleChange(ChangeEvent event) {
            XformWizardPage.this.validatePage();
        }
    }
}

