/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.ClasspathResourceSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformationTypePage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;
import org.jboss.tools.fuse.transformation.model.xml.XmlModelGenerator;

public class XMLPage
extends XformWizardPage
implements TransformationTypePage {
    private Composite _page;
    private boolean isSource = true;
    private Text _xmlFileText;
    private Button _xmlSchemaOption;
    private Button _xmlInstanceOption;
    private Text _xmlPreviewText;
    private ComboViewer _xmlRootsCombo;
    private Binding _binding;
    private Binding _binding2;

    public XMLPage(String pageName, Model model, boolean isSource) {
        super(pageName, model);
        this.setTitle("XML Page");
        this.setImageDescriptor(Activator.imageDescriptor("transform.png"));
        this.isSource = isSource;
        this.observablesManager.addObservablesFromContext(this.context, true, true);
    }

    @Override
    public void createControl(final Composite parent) {
        if (this.isSource) {
            this.setTitle("Source Type (XML)");
            this.setDescription("Specify details for the source XML for this transformation.");
        } else {
            this.setTitle("Target Type (XML)");
            this.setDescription("Specify details for the target XML for this transformation.");
        }
        this.observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                XMLPage.this.createPage(parent);
            }
        });
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.context);
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void createPage(Composite parent) {
        this._page = new Composite(parent, 0);
        this.setControl((Control)this._page);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.horizontalSpacing = 10;
        this._page.setLayout((Layout)layout);
        Group group = new Group(this._page, 16);
        group.setText("XML Type Definition");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        this._xmlSchemaOption = new Button((Composite)group, 16);
        this._xmlSchemaOption.setText("XML Schema");
        this._xmlSchemaOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this._xmlSchemaOption.setSelection(true);
        this._xmlInstanceOption = new Button((Composite)group, 16);
        this._xmlInstanceOption.setText("XML Instance Document");
        this._xmlInstanceOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this._xmlSchemaOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (XMLPage.this.isSourcePage()) {
                    XMLPage.this.model.setSourceType(ModelType.XSD);
                    XMLPage.this.model.setSourceFilePath("");
                } else {
                    XMLPage.this.model.setTargetType(ModelType.XSD);
                    XMLPage.this.model.setTargetFilePath("");
                }
                XMLPage.this._xmlPreviewText.setText("");
                XMLPage.this._xmlRootsCombo.getCombo().removeAll();
                XMLPage.this._xmlRootsCombo.getCombo().setText("");
                XMLPage.this.resetFinish();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this._xmlInstanceOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (XMLPage.this.isSourcePage()) {
                    XMLPage.this.model.setSourceType(ModelType.XML);
                } else {
                    XMLPage.this.model.setTargetType(ModelType.XML);
                }
                XMLPage.this.model.setTargetFilePath("");
                XMLPage.this._xmlPreviewText.setText("");
                XMLPage.this._xmlRootsCombo.getCombo().removeAll();
                XMLPage.this._xmlRootsCombo.getCombo().setText("");
                XMLPage.this.resetFinish();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label label = this.isSourcePage() ? this.createLabel(this._page, "Source File:", "The source XML file for the transformation.") : this.createLabel(this._page, "Target File:", "The target XML file for the transformation.");
        this._xmlFileText = new Text(this._page, 2048);
        this._xmlFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._xmlFileText.setToolTipText(label.getToolTipText());
        Button xmlFileBrowseButton = new Button(this._page, 0);
        xmlFileBrowseButton.setLayoutData((Object)new GridData());
        xmlFileBrowseButton.setText("...");
        xmlFileBrowseButton.setToolTipText("Browse to specify the XML file.");
        xmlFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String extension = "xml";
                boolean isXML = true;
                if (XMLPage.this._xmlInstanceOption.getSelection()) {
                    extension = "xml";
                    isXML = true;
                } else if (XMLPage.this._xmlSchemaOption.getSelection()) {
                    extension = "xsd";
                    isXML = false;
                }
                String path = XMLPage.this.selectResourceFromWorkspace(XMLPage.this._page.getShell(), extension);
                if (path != null) {
                    if (XMLPage.this.isSourcePage()) {
                        if (isXML) {
                            XMLPage.this.model.setSourceType(ModelType.XML);
                        } else {
                            XMLPage.this.model.setSourceType(ModelType.XSD);
                        }
                        XMLPage.this.model.setSourceFilePath(path);
                    } else {
                        if (isXML) {
                            XMLPage.this.model.setTargetType(ModelType.XML);
                        } else {
                            XMLPage.this.model.setTargetType(ModelType.XSD);
                        }
                        XMLPage.this.model.setTargetFilePath(path);
                    }
                    XMLPage.this._xmlFileText.setText(path);
                    Path tempPath = new Path(path);
                    IFile xmlFile = XMLPage.this.model.getProject().getFile((IPath)tempPath);
                    if (xmlFile != null) {
                        try {
                            Throwable throwable = null;
                            Object var8_11 = null;
                            try (InputStream istream = xmlFile.getContents();){
                                StringBuffer buffer = new StringBuffer();
                                Throwable throwable2 = null;
                                Object var12_17 = null;
                                try (BufferedReader in = new BufferedReader(new InputStreamReader(istream));){
                                    String inputLine;
                                    while ((inputLine = in.readLine()) != null) {
                                        buffer.append(String.valueOf(inputLine) + "\n");
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                                XMLPage.this._xmlPreviewText.setText(buffer.toString());
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    XMLPage.this._xmlFileText.notifyListeners(24, null);
                }
            }
        });
        label = this.createLabel(this._page, "Element Root:", "Element root to use for the root of the transformation object.");
        this._xmlRootsCombo = new ComboViewer(this._page, 12);
        this._xmlRootsCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._xmlRootsCombo.getCombo().setToolTipText(label.getToolTipText());
        this._xmlRootsCombo.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this._xmlRootsCombo.setLabelProvider((IBaseLabelProvider)new QNameLabelProvider());
        this._xmlRootsCombo.getCombo().setEnabled(false);
        this._xmlRootsCombo.getCombo().setToolTipText("This list will be populated as soon as an XML file is selected.");
        Group group2 = new Group(this._page, 16);
        group2.setText("XML Structure Preview");
        group2.setLayout((Layout)new FillLayout());
        group2.setLayoutData((Object)new GridData(4, 4, true, true, 3, 3));
        this._xmlPreviewText = new Text((Composite)group2, 520);
        this._xmlPreviewText.setBackground(this._page.getBackground());
        this.bindControls();
        this.validatePage();
    }

    @Override
    public boolean isSourcePage() {
        return this.isSource;
    }

    @Override
    public boolean isTargetPage() {
        return !this.isSource;
    }

    private String selectResourceFromWorkspace(Shell shell, String extension) {
        IJavaProject javaProject = null;
        if (this.getModel() != null && this.getModel().getProject() != null) {
            javaProject = JavaCore.create((IProject)this.getModel().getProject());
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), extension) : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), extension);
        dialog.setTitle("Select " + extension.toUpperCase() + " From Project");
        dialog.setInitialPattern("*." + extension);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        return ((IResource)result[0]).getProjectRelativePath().toPortableString();
    }

    private void bindControls() {
        ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe((Widget)this._xmlFileText);
        IObservableValue modelValue = null;
        modelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceFilePath").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetFilePath").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String path = value == null ? null : value.toString().trim();
                String pathEmptyError = null;
                String unableToFindError = null;
                if (XMLPage.this.isSourcePage()) {
                    pathEmptyError = "A source file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a source file with the supplied path";
                } else {
                    pathEmptyError = "A target file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a target file with the supplied path";
                }
                if (path == null || path.isEmpty()) {
                    return ValidationStatus.error((String)pathEmptyError);
                }
                if (XMLPage.this.model.getProject().findMember(path) == null) {
                    return ValidationStatus.error((String)unableToFindError);
                }
                return ValidationStatus.ok();
            }
        });
        this._binding = this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding, (int)this.decoratorPosition, (Composite)this._xmlFileText.getParent());
        IViewerObservableValue comboWidgetValue = ViewerProperties.singleSelection().observe((Viewer)this._xmlRootsCombo);
        IObservableValue comboModelValue = null;
        comboModelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceClassName").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetClassName").observe((Object)this.model);
        UpdateValueStrategy combostrategy = new UpdateValueStrategy();
        combostrategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String name;
                String string = name = value == null ? null : value.toString().trim();
                if (name == null || name.isEmpty()) {
                    return ValidationStatus.error((String)"A root element name must be supplied for the transformation.");
                }
                return ValidationStatus.ok();
            }
        });
        this._binding2 = this.context.bindValue((IObservableValue)comboWidgetValue, comboModelValue, combostrategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding2, (int)this.decoratorPosition, (Composite)this._xmlRootsCombo.getControl().getParent());
        modelValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Object value = event.diff.getNewValue();
                String path = null;
                if (value != null && !value.toString().trim().isEmpty()) {
                    path = value.toString().trim();
                }
                if (path == null) {
                    return;
                }
                XmlModelGenerator modelGen = new XmlModelGenerator();
                ArrayList<QName> elements = null;
                IPath filePath = XMLPage.this.model.getProject().getLocation().makeAbsolute().append(path);
                path = filePath.makeAbsolute().toPortableString();
                if (XMLPage.this.model != null) {
                    QName element;
                    if (XMLPage.this.isSourcePage() && XMLPage.this.model.getSourceType() != null) {
                        if (XMLPage.this.model.getSourceType().equals((Object)ModelType.XSD)) {
                            try {
                                elements = modelGen.getElementsFromSchema(new File(path));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (XMLPage.this.model.getSourceType().equals((Object)ModelType.XML)) {
                            try {
                                element = modelGen.getRootElementName(new File(path));
                                if (element != null) {
                                    elements = new ArrayList<QName>();
                                    elements.add(element);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (!XMLPage.this.isSourcePage() && XMLPage.this.model.getTargetType() != null) {
                        if (XMLPage.this.model.getTargetType().equals((Object)ModelType.XSD)) {
                            try {
                                elements = modelGen.getElementsFromSchema(new File(path));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else if (XMLPage.this.model.getTargetType().equals((Object)ModelType.XML)) {
                            try {
                                element = modelGen.getRootElementName(new File(path));
                                if (element != null) {
                                    elements = new ArrayList();
                                    elements.add(element);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                WritableList elementList = new WritableList();
                if (elements != null && !elements.isEmpty()) {
                    for (QName qname : elements) {
                        elementList.add((Object)qname.getLocalPart());
                        XMLPage.this._xmlRootsCombo.setData(qname.getLocalPart(), (Object)qname.getNamespaceURI());
                    }
                }
                XMLPage.this._xmlRootsCombo.setInput((Object)elementList);
                if (elementList != null && !elementList.isEmpty()) {
                    XMLPage.this._xmlRootsCombo.setSelection((ISelection)new StructuredSelection(elementList.get(0)));
                    String elementName = (String)elementList.get(0);
                    if (XMLPage.this.isSourcePage()) {
                        XMLPage.this.model.setSourceClassName(elementName);
                    } else {
                        XMLPage.this.model.setTargetClassName(elementName);
                    }
                    XMLPage.this._xmlRootsCombo.getCombo().setEnabled(true);
                    if (elementList.size() == 1) {
                        XMLPage.this._xmlRootsCombo.getCombo().setToolTipText("Only one root element found.");
                    } else {
                        XMLPage.this._xmlRootsCombo.getCombo().setToolTipText("Select from the available list of root elements.");
                    }
                }
            }
        });
        this.listenForValidationChanges();
    }

    @Override
    public void notifyListeners() {
        if (this._xmlFileText != null && !this._xmlFileText.isDisposed()) {
            this.notifyControl((Control)this._xmlFileText, 24);
            this.notifyControl((Control)this._xmlRootsCombo.getCombo(), 24);
        }
    }

    @Override
    public void clearControls() {
        if (this._xmlFileText != null && !this._xmlFileText.isDisposed()) {
            this._xmlFileText.setText("");
            this._xmlRootsCombo.setSelection(null);
            this._xmlPreviewText.setText("");
        }
        this.notifyListeners();
    }

    @Override
    public void pingBinding() {
        if (this._binding != null) {
            this._binding.validateTargetToModel();
        }
        if (this._binding2 != null) {
            this._binding2.validateTargetToModel();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.notifyListeners();
        }
    }

    class QNameLabelProvider
    extends LabelProvider {
        QNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof QName) {
                QName qname = (QName)element;
                return qname.getLocalPart();
            }
            return super.getText(element);
        }
    }
}

