/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.ClasspathResourceSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformationTypePage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;

public class JSONPage
extends XformWizardPage
implements TransformationTypePage {
    private Composite _page;
    private boolean isSource = true;
    private Text _jsonFileText;
    private Button _jsonSchemaOption;
    private Button _jsonInstanceOption;
    private Text _jsonPreviewText;
    private Binding _binding;

    public JSONPage(String pageName, Model model, boolean isSource) {
        super(pageName, model);
        this.setTitle("JSON Page");
        this.setImageDescriptor(Activator.imageDescriptor("transform.png"));
        this.isSource = isSource;
        this.observablesManager.addObservablesFromContext(this.context, true, true);
    }

    private void bindControls() {
        ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe((Widget)this._jsonFileText);
        IObservableValue modelValue = null;
        modelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceFilePath").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetFilePath").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String path = value == null ? null : value.toString().trim();
                String pathEmptyError = null;
                String unableToFindError = null;
                if (JSONPage.this.isSourcePage()) {
                    pathEmptyError = "A source file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a source file with the supplied path";
                } else {
                    pathEmptyError = "A target file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a target file with the supplied path";
                }
                if (path == null || path.isEmpty()) {
                    return ValidationStatus.error((String)pathEmptyError);
                }
                if (JSONPage.this.model.getProject().findMember(path) == null) {
                    return ValidationStatus.error((String)unableToFindError);
                }
                return ValidationStatus.ok();
            }
        });
        this._binding = this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding, (int)this.decoratorPosition, (Composite)this._jsonFileText.getParent());
        this.listenForValidationChanges();
    }

    @Override
    public void createControl(final Composite parent) {
        if (this.isSource) {
            this.setTitle("Source Type (JSON)");
            this.setDescription("Specify details for the source JSON for this transformation.");
        } else {
            this.setTitle("Target Type (JSON)");
            this.setDescription("Specify details for the target JSON for this transformation.");
        }
        this.observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                JSONPage.this.createPage(parent);
            }
        });
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.context);
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void createPage(Composite parent) {
        this._page = new Composite(parent, 0);
        this.setControl((Control)this._page);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.horizontalSpacing = 10;
        this._page.setLayout((Layout)layout);
        Group group = new Group(this._page, 16);
        group.setText("JSON Type Definition");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 3, 2));
        this._jsonSchemaOption = new Button((Composite)group, 16);
        this._jsonSchemaOption.setText("JSON Schema");
        this._jsonSchemaOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this._jsonSchemaOption.setSelection(true);
        this._jsonInstanceOption = new Button((Composite)group, 16);
        this._jsonInstanceOption.setText("JSON Instance Document");
        this._jsonInstanceOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this._jsonSchemaOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JSONPage.this.isSourcePage()) {
                    JSONPage.this.model.setSourceType(ModelType.JSON_SCHEMA);
                } else {
                    JSONPage.this.model.setTargetType(ModelType.JSON_SCHEMA);
                }
                JSONPage.this.model.setTargetFilePath("");
                JSONPage.this._jsonPreviewText.setText("");
                JSONPage.this.resetFinish();
            }
        });
        this._jsonInstanceOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JSONPage.this.isSourcePage()) {
                    JSONPage.this.model.setSourceType(ModelType.JSON);
                } else {
                    JSONPage.this.model.setTargetType(ModelType.JSON);
                }
                JSONPage.this.model.setTargetFilePath("");
                JSONPage.this._jsonPreviewText.setText("");
                JSONPage.this.resetFinish();
            }
        });
        Label label = this.isSourcePage() ? this.createLabel(this._page, "Source File:", "The source JSON file for the transformation.") : this.createLabel(this._page, "Target File:", "The target JSON file for the transformation.");
        this._jsonFileText = new Text(this._page, 2048);
        this._jsonFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._jsonFileText.setToolTipText(label.getToolTipText());
        Button jsonFileBrowseButton = new Button(this._page, 0);
        jsonFileBrowseButton.setLayoutData((Object)new GridData());
        jsonFileBrowseButton.setText("...");
        jsonFileBrowseButton.setToolTipText("Browse to specify the JSON file.");
        jsonFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = JSONPage.this.selectResourceFromWorkspace(JSONPage.this._page.getShell(), "json");
                if (path != null) {
                    try {
                        boolean schema = JSONPage.this.jsonSchema(path);
                        JSONPage.this._jsonInstanceOption.setSelection(!schema);
                        JSONPage.this._jsonSchemaOption.setSelection(schema);
                        if (JSONPage.this.isSourcePage()) {
                            if (schema) {
                                JSONPage.this.model.setSourceType(ModelType.JSON_SCHEMA);
                            } else {
                                JSONPage.this.model.setSourceType(ModelType.JSON);
                            }
                            JSONPage.this.model.setSourceFilePath(path);
                        } else {
                            if (schema) {
                                JSONPage.this.model.setTargetType(ModelType.JSON_SCHEMA);
                            } else {
                                JSONPage.this.model.setTargetType(ModelType.JSON);
                            }
                            JSONPage.this.model.setTargetFilePath(path);
                        }
                        JSONPage.this._jsonFileText.setText(path);
                        Path tempPath = new Path(path);
                        IFile xmlFile = JSONPage.this.model.getProject().getFile((IPath)tempPath);
                        if (xmlFile != null) {
                            try {
                                Throwable throwable = null;
                                Object var7_11 = null;
                                try (InputStream istream = xmlFile.getContents();){
                                    StringBuffer buffer = new StringBuffer();
                                    Throwable throwable2 = null;
                                    Object var11_17 = null;
                                    try (BufferedReader in = new BufferedReader(new InputStreamReader(istream));){
                                        String inputLine;
                                        while ((inputLine = in.readLine()) != null) {
                                            buffer.append(String.valueOf(inputLine) + "\n");
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                    JSONPage.this._jsonPreviewText.setText(buffer.toString());
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (CoreException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                        }
                        JSONPage.this._jsonFileText.notifyListeners(24, new Event());
                    }
                    catch (Exception e) {
                        Activator.error(e);
                    }
                }
            }
        });
        Group group2 = new Group(this._page, 16);
        group2.setText("JSON Structure Preview");
        group2.setLayout((Layout)new FillLayout());
        group2.setLayoutData((Object)new GridData(4, 4, true, true, 3, 3));
        this._jsonPreviewText = new Text((Composite)group2, 520);
        this._jsonPreviewText.setBackground(this._page.getBackground());
        this.bindControls();
        this.validatePage();
    }

    @Override
    public boolean isSourcePage() {
        return this.isSource;
    }

    @Override
    public boolean isTargetPage() {
        return !this.isSource;
    }

    /*
     * Exception decompiling
     */
    boolean jsonSchema(String path) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CASE], 9[SWITCH]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String selectResourceFromWorkspace(Shell shell, String extension) {
        IJavaProject javaProject = null;
        if (this.getModel() != null && this.getModel().getProject() != null) {
            javaProject = JavaCore.create((IProject)this.getModel().getProject());
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), extension) : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), extension);
        dialog.setTitle("Select " + extension.toUpperCase() + " From Project");
        dialog.setInitialPattern("*." + extension);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        return ((IResource)result[0]).getProjectRelativePath().toPortableString();
    }

    @Override
    public void notifyListeners() {
        if (this._jsonFileText != null && !this._jsonFileText.isDisposed()) {
            this.notifyControl((Control)this._jsonFileText, 24);
        }
    }

    @Override
    public void clearControls() {
        if (this._jsonFileText != null && !this._jsonFileText.isDisposed()) {
            this._jsonFileText.setText("");
            this._jsonPreviewText.setText("");
        }
        this.notifyListeners();
    }

    @Override
    public void pingBinding() {
        if (this._binding != null) {
            this._binding.validateTargetToModel();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.notifyListeners();
        }
    }
}

