/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.fusesource.ide.camel.model.catalog.Dependency;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.dozer.DozerResourceClasspathSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelFileTypeHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelResourceClasspathSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.ClasspathResourceSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.IndexesDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;

public class Util {
    public static final String MAIN_PATH = "src/main/";
    public static final String RESOURCES_PATH = "src/main/resources/";

    public static Object draggedObject() {
        return ((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).getFirstElement();
    }

    public static boolean draggingFromValidSource(TransformationConfig config) {
        Object object = Util.draggedObject();
        if (object instanceof Variable) {
            return true;
        }
        if (!(object instanceof org.jboss.tools.fuse.transformation.model.Model)) {
            return false;
        }
        org.jboss.tools.fuse.transformation.model.Model model = (org.jboss.tools.fuse.transformation.model.Model)object;
        if (Util.type(model)) {
            return false;
        }
        return config.root(model).equals((Object)config.getSourceModel());
    }

    public static boolean draggingFromValidTarget(TransformationConfig config) {
        Object object = Util.draggedObject();
        if (!(object instanceof org.jboss.tools.fuse.transformation.model.Model)) {
            return false;
        }
        org.jboss.tools.fuse.transformation.model.Model model = (org.jboss.tools.fuse.transformation.model.Model)object;
        if (Util.type(model)) {
            return false;
        }
        return config.root(model).equals((Object)config.getTargetModel());
    }

    private static ArrayList<IResource> getAllXMLFilesInProject(IProject project) {
        ArrayList<IResource> allFiles = new ArrayList<IResource>();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = project.getLocation();
        Util.recursivelyFindFilesWithExtension(allFiles, path, wsRoot, "xml");
        return allFiles;
    }

    public static List<Integer> indexes(Shell shell, org.jboss.tools.fuse.transformation.model.Model model, boolean source) {
        IndexesDialog dlg;
        if (Util.isOrInCollection(model) && (dlg = new IndexesDialog(shell, model, source)).open() == 0) {
            return dlg.indexes;
        }
        return null;
    }

    public static boolean isOrInCollection(org.jboss.tools.fuse.transformation.model.Model model) {
        return model != null && (model.isCollection() || Util.isOrInCollection(model.getParent()));
    }

    public static final PaintListener ovalBorderPainter() {
        return new PaintListener(){

            public void paintControl(PaintEvent event) {
                Color oldForeground = event.gc.getForeground();
                event.gc.setForeground(event.display.getSystemColor(15));
                Rectangle bounds = ((Control)event.widget).getBounds();
                event.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, bounds.height, bounds.height);
                event.gc.setForeground(oldForeground);
            }
        };
    }

    private static void populateClasses(Shell shell, IParent parent, List<IType> types, Filter filter) {
        try {
            IJavaElement[] iJavaElementArray = parent.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element instanceof IType) {
                    IType type = (IType)element;
                    if (type.isClass() && type.isStructureKnown() && !type.isAnonymous() && !type.isLocal() && !Flags.isAbstract((int)type.getFlags()) && Flags.isPublic((int)type.getFlags()) && (filter == null || filter.accept(type))) {
                        types.add(type);
                    }
                } else if (!(!(element instanceof IParent) || element.getPath().toString().contains("/test/") || element instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)element).isExternal())) {
                    Util.populateClasses(shell, (IParent)element, types, filter);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.error(e);
        }
    }

    private static void populateResources(Shell shell, IContainer container, List<IResource> resources) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    Util.populateResources(shell, (IContainer)resource, resources);
                } else {
                    resources.add(resource);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean projectHasCamelResource(IProject project) {
        try {
            boolean isValidCamel;
            IResource item;
            File testFile;
            ArrayList<IResource> xmlResources = Util.getAllXMLFilesInProject(project);
            Iterator<IResource> iterator = xmlResources.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(testFile = new File((item = iterator.next()).getLocationURI())).exists() || !(isValidCamel = CamelFileTypeHelper.isSupportedCamelFile(project, item.getProjectRelativePath().toPortableString())));
            return true;
        }
        catch (Exception exception) {}
        return false;
    }

    private static void recursivelyFindFilesWithExtension(ArrayList<IResource> allFiles, IPath path, IWorkspaceRoot wsRoot, String extension) {
        IContainer container = wsRoot.getContainerForLocation(path);
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (extension.equalsIgnoreCase(resource.getFileExtension())) {
                    allFiles.add(resource);
                }
                if (resource.getType() == 2) {
                    IPath tempPath = resource.getLocation();
                    Util.recursivelyFindFilesWithExtension(allFiles, tempPath, wsRoot, extension);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static final PaintListener roundedRectanglePainter(final int arc, final Color background) {
        return new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.setBackground(background);
                Rectangle bounds = ((Composite)event.widget).getClientArea();
                event.gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, arc, arc);
            }
        };
    }

    public static IResource selectCamelResourceFromWorkspace(Shell shell, IProject project) {
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        CamelResourceClasspathSelectionDialog dialog = javaProject == null ? new CamelResourceClasspathSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), "xml") : new CamelResourceClasspathSelectionDialog(shell, (IContainer)javaProject.getProject(), "xml");
        dialog.setTitle("Select Camel XML File from Project");
        dialog.setInitialPattern("*.xml");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    public static IResource selectDozerResourceFromWorkspace(Shell shell, IProject project) {
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        DozerResourceClasspathSelectionDialog dialog = javaProject == null ? new DozerResourceClasspathSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), "xml") : new DozerResourceClasspathSelectionDialog(shell, (IContainer)javaProject.getProject(), "xml");
        dialog.setTitle("Select Transformation File from Project");
        dialog.setInitialPattern("*.xml");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    public static IType selectClass(Shell shell, IProject project) {
        return Util.selectClass(shell, project, null);
    }

    public static IType selectClass(Shell shell, IProject project, Filter filter) {
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x800 | 0x40;
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dlg.setTitle("Select Custom Operation(s) Class");
        dlg.setMessage("Select a custom operation(s) class");
        dlg.setMatchEmptyString(true);
        dlg.setHelpAvailable(false);
        ArrayList<IType> types = new ArrayList<IType>();
        Util.populateClasses(shell, (IParent)JavaCore.create((IProject)project), types, filter);
        dlg.setElements(types.toArray());
        return dlg.open() == 0 ? (IType)dlg.getFirstResult() : null;
    }

    public static String selectFile(Shell shell, IProject project, String schemaType) {
        int flags = JavaElementLabelProvider.SHOW_DEFAULT | 0x800 | 0x40;
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags){

            public String getText(Object element) {
                return String.valueOf(super.getText(element)) + " - " + ((IResource)element).getParent().getFullPath().makeRelative();
            }
        });
        dlg.setTitle("Select " + schemaType);
        dlg.setMessage("Select the " + schemaType + " file for the transformation");
        dlg.setMatchEmptyString(true);
        dlg.setHelpAvailable(false);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        Util.populateResources(shell, (IContainer)project, resources);
        dlg.setElements(resources.toArray());
        return dlg.open() == 0 ? ((IFile)dlg.getFirstResult()).getProjectRelativePath().toString() : null;
    }

    public static IResource selectResourceFromWorkspace(Shell shell, String extension, IProject project) {
        IJavaProject javaProject = null;
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        ClasspathResourceSelectionDialog dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), "xml") : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), "xml");
        dialog.setTitle("Select Camel XML File from Project");
        dialog.setInitialPattern("*.xml");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IFile)) {
            return null;
        }
        return (IFile)result[0];
    }

    public static boolean type(org.jboss.tools.fuse.transformation.model.Model model) {
        return !model.isCollection() && !model.getChildren().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateMavenDependencies(List<Dependency> dependencies, IProject project) throws CoreException {
        IFile pomIFile = project.getProject().getFile("pom.xml");
        File pomFile = new File(pomIFile.getLocationURI());
        Model pom = MavenPlugin.getMaven().readModel(pomFile);
        ArrayList<Dependency> missingDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            boolean found = false;
            for (org.apache.maven.model.Dependency pomDependency : pom.getDependencies()) {
                if (!pomDependency.getGroupId().equalsIgnoreCase(dependency.getGroupId()) || !pomDependency.getArtifactId().equalsIgnoreCase(dependency.getArtifactId())) continue;
                if (!pomDependency.getVersion().equalsIgnoreCase(dependency.getVersion())) {
                    pomDependency.setVersion(dependency.getVersion());
                }
                found = true;
                break;
            }
            if (found) continue;
            missingDependencies.add(dependency);
        }
        for (Dependency dependency : missingDependencies) {
            org.apache.maven.model.Dependency pomDependency = new org.apache.maven.model.Dependency();
            pomDependency.setGroupId(dependency.getGroupId());
            pomDependency.setArtifactId(dependency.getArtifactId());
            pomDependency.setVersion(dependency.getVersion());
            pom.addDependency(pomDependency);
        }
        if (!missingDependencies.isEmpty()) {
            try {
                Throwable throwable = null;
                Iterator<Object> iterator = null;
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(pomFile));){
                    MavenPlugin.getMaven().writeModel(pom, (OutputStream)stream);
                    pomIFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable2) {
                    void var6_14;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var6_14;
                }
            }
            catch (Exception exception) {
                Activator.error(exception);
            }
        }
    }

    public static String getCamelVersion(IProject project) {
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        File pomFile = new File(pomPath);
        try {
            Model model = MavenPlugin.getMaven().readModel(pomFile);
            List deps = model.getDependencies();
            for (org.apache.maven.model.Dependency dependency : deps) {
                if (!dependency.getArtifactId().equals("camel-core")) continue;
                return dependency.getVersion();
            }
        }
        catch (CoreException coreException) {}
        return org.fusesource.ide.camel.editor.Activator.getDefault().getCamelVersion();
    }

    public static boolean validSourceAndTarget(Object source, Object target, TransformationConfig config) {
        org.jboss.tools.fuse.transformation.model.Model targetModel;
        org.jboss.tools.fuse.transformation.model.Model sourceModel = source instanceof org.jboss.tools.fuse.transformation.model.Model ? (org.jboss.tools.fuse.transformation.model.Model)source : null;
        org.jboss.tools.fuse.transformation.model.Model model = targetModel = target instanceof org.jboss.tools.fuse.transformation.model.Model ? (org.jboss.tools.fuse.transformation.model.Model)target : null;
        if (sourceModel != null && Util.type(sourceModel)) {
            return false;
        }
        if (targetModel != null && Util.type(targetModel)) {
            return false;
        }
        if (sourceModel != null && targetModel != null) {
            if (config.getMapping(sourceModel, targetModel) != null) {
                return false;
            }
            if (sourceModel.isCollection() && targetModel.isCollection()) {
                return false;
            }
        }
        return true;
    }

    private Util() {
    }

    public static interface Colors {
        public static final Color BACKGROUND = Activator.color(255, 255, 255);
        public static final Color DROP_TARGET_BACKGROUND = Activator.color(0, 0, 255);
        public static final Color DROP_TARGET_FOREGROUND = Activator.color(255, 255, 255);
        public static final Color EXPRESSION = Activator.color(192, 0, 192);
        public static final Color FOREGROUND = Activator.color(0, 0, 0);
        public static final Color FUNCTION = Activator.color(192, 255, 192);
        public static final Color FUNCTION_ALTERNATE = Activator.color(128, 255, 128);
        public static final Color MODEL = Activator.color(192, 192, 192);
        public static final Color POTENTIAL_DROP_TARGET1 = Activator.color(0, 0, 128);
        public static final Color POTENTIAL_DROP_TARGET2 = Activator.color(32, 32, 160);
        public static final Color POTENTIAL_DROP_TARGET3 = Activator.color(64, 64, 192);
        public static final Color POTENTIAL_DROP_TARGET4 = Activator.color(92, 92, 224);
        public static final Color POTENTIAL_DROP_TARGET5 = Activator.color(128, 128, 255);
        public static final Color POTENTIAL_DROP_TARGET6 = Activator.color(92, 92, 224);
        public static final Color POTENTIAL_DROP_TARGET7 = Activator.color(64, 64, 192);
        public static final Color POTENTIAL_DROP_TARGET8 = Activator.color(32, 32, 160);
        public static final Color SELECTED = Activator.color(180, 213, 255);
        public static final Color SELECTED_NO_FOCUS = Activator.color(212, 212, 212);
        public static final Color VARIABLE = Activator.color(0, 0, 192);
    }

    public static interface Decorations {
        public static final ImageDescriptor ADD = Activator.imageDescriptor("addOverlay.gif");
        public static final ImageDescriptor COLLECTION = Activator.imageDescriptor("collectionOverlay.gif");
        public static final ImageDescriptor MAPPED = Activator.imageDescriptor("mappedOverlay.gif");
    }

    public static interface Filter {
        public boolean accept(IType var1);
    }

    public static interface Images {
        public static final Image ADD_FUNCTION = Activator.imageDescriptor("addFunction16.gif").createImage();
        public static final Image ADD = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        public static final Image ATTRIBUTE = Activator.imageDescriptor("attribute16.gif").createImage();
        public static final Image CHANGE = Activator.imageDescriptor("change16.gif").createImage();
        public static final Image CLEAR = Activator.imageDescriptor("clear16.gif").createImage();
        public static final Image COLLAPSE_ALL = Activator.imageDescriptor("collapseAll16.gif").createImage();
        public static final Image DELETE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE");
        public static final Image ELEMENT = Activator.imageDescriptor("element16.gif").createImage();
        public static final Image FILTER = Activator.imageDescriptor("filter16.gif").createImage();
        public static final Image HIDE_MAPPED = Activator.imageDescriptor("hideMapped16.gif").createImage();
        public static final Image MAPPED = Activator.imageDescriptor("mapped16.gif").createImage();
        public static final Image MENU = Activator.imageDescriptor("menu10x5.gif").createImage();
        public static final Image SEARCH = Activator.imageDescriptor("search16.gif").createImage();
        public static final Image TREE = Activator.imageDescriptor("tree16.gif").createImage();
        public static final Image VARIABLE = Activator.imageDescriptor("variable16.gif").createImage();
    }
}

