/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.viewers.IViewerObservable;
import org.eclipse.jface.internal.databinding.swt.WidgetListenerUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class SWTValueUpdater
implements Listener,
IDisposeListener,
IValueChangeListener {
    private Control control;
    private final Binding binding;
    private final IObservable target;
    private boolean dirty;
    private boolean updating;

    public static Binding attach(Binding binding) {
        new SWTValueUpdater(binding);
        return binding;
    }

    private SWTValueUpdater(Binding binding) {
        this.binding = binding;
        this.target = binding.getTarget();
        if (this.target instanceof ISWTObservable && ((ISWTObservable)binding.getTarget()).getWidget() instanceof Control) {
            this.control = (Control)((ISWTObservable)binding.getTarget()).getWidget();
        } else if (this.target instanceof IViewerObservable) {
            this.control = ((IViewerObservable)this.target).getViewer().getControl();
        } else {
            throw new IllegalArgumentException("target of binding must be an ISWTObservable whose widget is a Control.");
        }
        this.addListeners();
    }

    private void addListeners() {
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)2, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)16, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)15, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)14, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)13, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this.control, (int)12, (Listener)this);
        this.target.addDisposeListener((IDisposeListener)this);
        ((IObservableValue)this.target).addValueChangeListener((IValueChangeListener)this);
    }

    public void handleEvent(Event event) {
        if (this.updating) {
            return;
        }
        if (event.type == 2) {
            if (event.keyCode == 27) {
                if (this.binding.isDisposed()) {
                    this.dispose();
                    return;
                }
                this.updating = true;
                try {
                    this.binding.updateModelToTarget();
                }
                finally {
                    this.updating = false;
                }
                if (this.control instanceof Text) {
                    ((Text)this.control).setSelection(0, ((Text)this.control).getCharCount());
                }
                this.dirty = false;
            }
        } else if (event.type == 16 || event.type == 14 || event.type == 13) {
            if (this.binding.isDisposed()) {
                this.dispose();
                return;
            }
            if (((IStatus)this.binding.getValidationStatus().getValue()).getSeverity() == 4) {
                this.control.setFocus();
                return;
            }
            if (this.dirty) {
                this.updating = true;
                try {
                    this.binding.updateTargetToModel();
                }
                finally {
                    this.updating = false;
                }
                this.dirty = false;
            }
        } else if (event.type == 15) {
            this.dirty = false;
        } else if (event.type == 12) {
            this.dispose();
        }
    }

    public void handleValueChange(ValueChangeEvent event) {
        if (this.updating) {
            return;
        }
        this.dirty = true;
    }

    public void handleDispose(DisposeEvent event) {
        this.dispose();
    }

    private synchronized void dispose() {
        if (this.control != null) {
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)2, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)16, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)15, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)14, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)13, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this.control, (int)12, (Listener)this);
            this.control = null;
            this.target.removeDisposeListener((IDisposeListener)this);
            ((IObservableValue)this.target).removeValueChangeListener((IValueChangeListener)this);
        }
    }
}

