/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.ModelTabFolder;
import org.jboss.tools.fuse.transformation.editor.internal.ModelViewer;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.model.Model;

public final class TargetTabFolder
extends ModelTabFolder {
    final TransformationConfig config;

    public TargetTabFolder(TransformationConfig config, Composite parent, List<PotentialDropTarget> potentialDropTargets) {
        super(config, parent, "Target", config.getTargetModel(), potentialDropTargets);
        this.config = config;
    }

    @Override
    protected ModelViewer constructModelViewer(final TransformationConfig config, List<PotentialDropTarget> potentialDropTargets) {
        ModelViewer modelViewer = new ModelViewer(config, (Composite)this, config.getTargetModel(), potentialDropTargets);
        modelViewer.treeViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)modelViewer.treeViewer){

            public boolean performDrop(Object data) {
                try {
                    Object source = ((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).getFirstElement();
                    if (source instanceof Model) {
                        boolean targetIsOrInCollection;
                        Model sourceModel = (Model)source;
                        Model targetModel = (Model)this.getCurrentTarget();
                        boolean sourceIsOrInCollection = Util.isOrInCollection(sourceModel);
                        if (sourceIsOrInCollection == (targetIsOrInCollection = Util.isOrInCollection(targetModel))) {
                            config.mapField(sourceModel, targetModel, null, null);
                        } else {
                            List<Integer> sourceIndexes = sourceIsOrInCollection ? Util.indexes(TargetTabFolder.this.getShell(), sourceModel, true) : null;
                            List<Integer> targetIndexes = targetIsOrInCollection ? Util.indexes(TargetTabFolder.this.getShell(), targetModel, false) : null;
                            config.mapField(sourceModel, targetModel, sourceIndexes, targetIndexes);
                        }
                    } else {
                        Variable variable = (Variable)source;
                        Model targetModel = (Model)this.getCurrentTarget();
                        List<Integer> indexes = Util.isOrInCollection(targetModel) ? Util.indexes(TargetTabFolder.this.getShell(), targetModel, false) : null;
                        config.mapVariable(variable, targetModel, indexes);
                    }
                    config.save();
                    return true;
                }
                catch (Exception e) {
                    Activator.error(e);
                    return false;
                }
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return this.getCurrentLocation() == 3 && Util.draggingFromValidSource(config) && Util.validSourceAndTarget(Util.draggedObject(), target, config);
            }
        });
        potentialDropTargets.add(new PotentialDropTarget((Control)modelViewer.treeViewer.getTree()){

            @Override
            public boolean valid() {
                return Util.draggingFromValidSource(config);
            }
        });
        return modelViewer;
    }
}

