/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.model.Model;

public class ModelViewer
extends Composite {
    final TransformationConfig config;
    Model rootModel;
    boolean showFieldTypes;
    boolean hideMappedFields;
    final Map<String, List<Model>> searchMap = new HashMap<String, List<Model>>();
    final Set<Model> searchResults = new HashSet<Model>();
    protected boolean showMappedFieldsButton = true;
    private ToolItem filterMappedFieldsButton;
    protected boolean showSearchField = true;
    private Text searchText;
    private Label searchLabel;
    private Label clearSearchLabel;
    protected final TreeViewer treeViewer;

    public ModelViewer(TransformationConfig config, Composite parent, Model rootModel, final List<PotentialDropTarget> potentialDropTargets) {
        super(parent, 2048);
        this.setBackground(Util.Colors.BACKGROUND);
        this.setViewOptions();
        this.config = config;
        this.rootModel = rootModel;
        this.updateSearchMap(rootModel);
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        ToolBar toolBar = new ToolBar((Composite)this, 0);
        toolBar.setBackground(this.getBackground());
        ToolItem collapseAllButton = new ToolItem(toolBar, 8);
        collapseAllButton.setImage(Util.Images.COLLAPSE_ALL);
        ToolItem filterTypesButton = new ToolItem(toolBar, 32);
        filterTypesButton.setImage(Util.Images.FILTER);
        filterTypesButton.setToolTipText("Show types");
        if (this.showMappedFieldsButton) {
            this.filterMappedFieldsButton = new ToolItem(toolBar, 32);
            this.filterMappedFieldsButton.setImage(Util.Images.HIDE_MAPPED);
            this.filterMappedFieldsButton.setToolTipText("Hide mapped fields");
        }
        if (this.showSearchField) {
            Composite searchPane = new Composite((Composite)this, 0);
            searchPane.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            searchPane.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
            searchPane.setToolTipText("Search");
            searchPane.setBackground(this.getBackground());
            this.searchLabel = new Label(searchPane, 0);
            this.searchLabel.setImage(Util.Images.SEARCH);
            this.searchLabel.setToolTipText("Search");
            this.searchLabel.setBackground(this.getBackground());
            this.searchText = new Text(searchPane, 0);
            this.searchText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.searchText.setToolTipText("Search");
            this.clearSearchLabel = new Label(searchPane, 0);
            this.clearSearchLabel.setImage(Util.Images.CLEAR);
            this.clearSearchLabel.setToolTipText("Search");
            this.clearSearchLabel.setBackground(this.getBackground());
            searchPane.addPaintListener(Util.ovalBorderPainter());
        }
        this.treeViewer = new TreeViewer((Composite)this, 770);
        this.treeViewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object model1, Object model2) {
                if (model1 instanceof Model && model2 instanceof Model) {
                    return ((Model)model1).getName().compareTo(((Model)model2).getName());
                }
                return 0;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        if (this.showSearchField) {
            this.treeViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return ModelViewer.this.show(element, !ModelViewer.this.searchText.getText().trim().isEmpty());
                }
            });
        }
        if (potentialDropTargets != null) {
            this.treeViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){
                Color color;
                List<Control> controls = new ArrayList<Control>();
                private final MouseMoveListener mouseMoveListener = new MouseMoveListener(){

                    public void mouseMove(MouseEvent event) {
                        for (Control control : controls) {
                            control.redraw();
                        }
                        color = color == Util.Colors.POTENTIAL_DROP_TARGET1 ? Util.Colors.POTENTIAL_DROP_TARGET2 : (color == Util.Colors.POTENTIAL_DROP_TARGET2 ? Util.Colors.POTENTIAL_DROP_TARGET3 : (color == Util.Colors.POTENTIAL_DROP_TARGET3 ? Util.Colors.POTENTIAL_DROP_TARGET4 : (color == Util.Colors.POTENTIAL_DROP_TARGET4 ? Util.Colors.POTENTIAL_DROP_TARGET5 : (color == Util.Colors.POTENTIAL_DROP_TARGET5 ? Util.Colors.POTENTIAL_DROP_TARGET6 : (color == Util.Colors.POTENTIAL_DROP_TARGET6 ? Util.Colors.POTENTIAL_DROP_TARGET7 : (color == Util.Colors.POTENTIAL_DROP_TARGET7 ? Util.Colors.POTENTIAL_DROP_TARGET8 : Util.Colors.POTENTIAL_DROP_TARGET1))))));
                    }
                };
                private final PaintListener paintListener = new PaintListener(){

                    public void paintControl(PaintEvent event) {
                        event.gc.setForeground(color);
                        Rectangle bounds = ((Control)event.widget).getBounds();
                        event.gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                    }
                };

                public void dragFinished(DragSourceEvent event) {
                    ModelViewer.this.treeViewer.getTree().removeMouseMoveListener(this.mouseMoveListener);
                    for (Control control : this.controls) {
                        control.removePaintListener(this.paintListener);
                        control.redraw();
                    }
                    this.controls.clear();
                }

                public void dragStart(DragSourceEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)ModelViewer.this.treeViewer.getSelection();
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                    this.color = Util.Colors.POTENTIAL_DROP_TARGET1;
                    for (PotentialDropTarget potentialDropTarget : potentialDropTargets) {
                        if (!potentialDropTarget.valid()) continue;
                        this.controls.add(potentialDropTarget.control);
                        potentialDropTarget.control.addPaintListener(this.paintListener);
                    }
                    ModelViewer.this.treeViewer.getTree().addMouseMoveListener(this.mouseMoveListener);
                }
            });
        }
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelViewer.this.treeViewer.collapseAll();
            }
        });
        filterTypesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                ModelViewer.this.showFieldTypes = item.getSelection();
                item.setToolTipText(String.valueOf(ModelViewer.this.showFieldTypes ? "Hide" : "Show") + " types");
                ModelViewer.this.treeViewer.refresh();
            }
        });
        if (this.showMappedFieldsButton) {
            this.filterMappedFieldsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ToolItem item = (ToolItem)event.widget;
                    ModelViewer.this.hideMappedFields = item.getSelection();
                    item.setToolTipText(String.valueOf(ModelViewer.this.hideMappedFields ? "Show" : "Hide") + " mapped fields");
                    ModelViewer.this.treeViewer.refresh();
                }
            });
        }
        if (this.showSearchField) {
            this.searchLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    ModelViewer.this.searchText.setFocus();
                }
            });
            this.clearSearchLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    ModelViewer.this.searchText.setText("");
                }
            });
            this.searchText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ModelViewer.this.searchResults.clear();
                    List<Model> models = ModelViewer.this.searchMap.get(ModelViewer.this.searchText.getText().trim().toLowerCase());
                    if (models != null) {
                        for (Model model : models) {
                            ModelViewer.this.searchResults.add(model);
                            Model parent = model.getParent();
                            while (parent != null) {
                                ModelViewer.this.searchResults.add(parent);
                                parent = parent.getParent();
                            }
                        }
                    }
                    ModelViewer.this.treeViewer.refresh();
                }
            });
        }
        if (rootModel != null) {
            this.treeViewer.setInput((Object)"root");
        }
        if (config != null) {
            config.addListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals("mapping") && !ModelViewer.this.treeViewer.getControl().isDisposed()) {
                        ModelViewer.this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    private void expand(Model model) {
        if (model == null) {
            return;
        }
        this.expand(model.getParent());
        this.treeViewer.expandToLevel((Object)model, 0);
    }

    boolean mapped(Model model) {
        if (this.config == null) {
            return false;
        }
        return this.rootModel.equals((Object)this.config.getSourceModel()) ? !this.config.getMappingsForSource(model).isEmpty() : !this.config.getMappingsForTarget(model).isEmpty();
    }

    private boolean mappedOrFullyMappedParent(Model model) {
        List children = model.getChildren();
        for (Model child : children) {
            if (this.mappedOrFullyMappedParent(child)) continue;
            return false;
        }
        return this.mapped(model) ? true : !children.isEmpty();
    }

    void select(Model model) {
        if (model == null) {
            return;
        }
        List<Model> models = this.searchMap.get(model.getName().toLowerCase());
        if (models == null) {
            return;
        }
        for (Model actualModel : models) {
            if (!actualModel.equals((Object)model)) continue;
            this.expand(actualModel.getParent());
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)actualModel), true);
            return;
        }
    }

    public void setModel(Model model) {
        this.rootModel = model;
        if (model != null) {
            this.treeViewer.setInput((Object)"root");
        } else {
            this.treeViewer.setInput(null);
        }
    }

    boolean show(Object element, boolean searching) {
        if (this.hideMappedFields && this.mappedOrFullyMappedParent((Model)element)) {
            return false;
        }
        return !searching || this.searchResults.contains(element);
    }

    void updateSearchMap(Model model) {
        if (model == null) {
            return;
        }
        StringCharacterIterator iter = new StringCharacterIterator(model.getName().toLowerCase());
        StringBuilder builder = new StringBuilder();
        char chr = iter.first();
        while (chr != '\uffff') {
            builder.append(chr);
            String key = builder.toString();
            List<Model> models = this.searchMap.get(key);
            if (models == null) {
                models = new ArrayList<Model>();
                this.searchMap.put(key, models);
            }
            models.add(model);
            chr = iter.next();
        }
        for (Model child : model.getChildren()) {
            this.updateSearchMap(child);
        }
    }

    protected void setViewOptions() {
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((Model)parentElement).getChildren().toArray();
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{ModelViewer.this.rootModel};
        }

        public Object getParent(Object element) {
            return element instanceof Model ? ((Model)element).getParent() : null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LabelProvider
    extends StyledCellLabelProvider {
        private static final String LIST_OF = "list of ";

        LabelProvider() {
        }

        private Image getImage(Object element) {
            Image img;
            Model model = (Model)element;
            Image image = img = model.getChildren() != null && model.getChildren().size() > 0 ? Util.Images.ELEMENT : Util.Images.ATTRIBUTE;
            if (model.isCollection()) {
                img = new DecorationOverlayIcon(img, Util.Decorations.COLLECTION, 3).createImage();
            }
            if (ModelViewer.this.mapped((Model)element)) {
                return new DecorationOverlayIcon(img, Util.Decorations.MAPPED, 1).createImage();
            }
            return img;
        }

        private String getText(Object element, StyledString text, boolean showFieldTypesInLabel) {
            Model model = (Model)element;
            text.append(model.getName());
            if (showFieldTypesInLabel) {
                String type = model.getType();
                if (type.startsWith("[")) {
                    text.append(":", StyledString.DECORATIONS_STYLER);
                    text.append(" list of ", StyledString.QUALIFIER_STYLER);
                    text.append(type.substring(1, type.length() - 1), StyledString.DECORATIONS_STYLER);
                } else {
                    text.append(": " + type, StyledString.DECORATIONS_STYLER);
                }
            }
            return text.getString();
        }

        public String getToolTipText(Object element) {
            return this.getText(element, new StyledString(), true);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString();
            cell.setImage(this.getImage(element));
            cell.setText(this.getText(element, text, ModelViewer.this.showFieldTypes));
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }
    }
}

