/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.MappingType;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.TransformationEditor;
import org.jboss.tools.fuse.transformation.editor.internal.MappingSummary;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.model.Model;

public class MappingsViewer
extends Composite {
    final TransformationEditor editor;
    final ToolItem deleteButton;
    ScrolledComposite scroller;
    Composite summaryPane;
    Composite sourcePane;
    Composite mapsToPane;
    Composite targetPane;
    Text prevTargetText;
    TraversalListener prevTraversalListener;
    MappingSummary selectedMappingSummary;
    final List<MappingSummary> mappingSummaries = new ArrayList<MappingSummary>();
    private final List<PotentialDropTarget> potentialDropTargets;

    public MappingsViewer(final TransformationConfig config, TransformationEditor editor, Composite parent, List<PotentialDropTarget> potentialDropTargets) {
        super(parent, 0);
        int width;
        this.editor = editor;
        this.potentialDropTargets = potentialDropTargets;
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.setBackground(parent.getParent().getBackground());
        Label title = new Label((Composite)this, 0x1000000);
        title.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        title.setText("Transformations");
        ToolBar toolBar = new ToolBar((Composite)this, 0);
        ToolItem addButton = new ToolItem(toolBar, 8);
        addButton.setImage(new DecorationOverlayIcon(Util.Images.MAPPED, Util.Decorations.ADD, 1).createImage());
        addButton.setToolTipText("Add a new mapping");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                config.newMapping();
            }
        });
        this.deleteButton = new ToolItem(toolBar, 8);
        this.deleteButton.setImage(Util.Images.DELETE);
        this.deleteButton.setToolTipText("Delete the selected mapping");
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    config.removeMapping(MappingsViewer.this.selectedMappingSummary.mapping);
                    config.save();
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
        });
        this.scroller = new ScrolledComposite((Composite)this, 512);
        this.scroller.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.setBackground(this.getBackground());
        this.summaryPane = new Composite((Composite)this.scroller, 0);
        this.scroller.setContent((Control)this.summaryPane);
        this.summaryPane.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(0, 0).create());
        this.summaryPane.setBackground(this.getBackground());
        this.sourcePane = new Composite(this.summaryPane, 0);
        this.sourcePane.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.sourcePane.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.sourcePane.setBackground(this.getBackground());
        this.mapsToPane = new Composite(this.summaryPane, 0);
        int margin = this.sourcePane.computeSize((int)-1, (int)-1).y / 2;
        this.mapsToPane.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(margin, margin).spacing(0, 0).create());
        Composite tempPane = new Composite(this.mapsToPane, 0);
        tempPane.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        tempPane.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Label tempLabel = new Label(tempPane, 0);
        tempLabel.setImage(Util.Images.MAPPED);
        int mapsToPaneWidth = this.mapsToPane.computeSize((int)-1, (int)-1).x;
        tempLabel.dispose();
        tempPane.dispose();
        this.mapsToPane.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).hint(mapsToPaneWidth, -1).create());
        this.mapsToPane.setBackground(this.getBackground());
        this.targetPane = new Composite(this.summaryPane, 0);
        this.targetPane.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.targetPane.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.targetPane.setBackground(this.getBackground());
        for (MappingOperation<?, ?> mapping : config.getMappings()) {
            if (mapping.getType() != MappingType.EXPRESSION && mapping.getType() != MappingType.VARIABLE && ((Model)mapping.getSource()).isCollection() && ((Model)mapping.getTarget()).isCollection()) continue;
            this.mappingSummaries.add(new MappingSummary(config, mapping, this, potentialDropTargets));
        }
        ((GridData)this.sourcePane.getLayoutData()).widthHint = width = Math.max(this.sourcePane.computeSize((int)-1, (int)-1).x, this.targetPane.computeSize((int)-1, (int)-1).x);
        ((GridData)this.targetPane.getLayoutData()).widthHint = width;
        this.scroller.setMinSize(this.summaryPane.computeSize(-1, -1));
        config.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (!event.getPropertyName().equals("mapping")) {
                    return;
                }
                MappingOperation mapping = (MappingOperation)event.getNewValue();
                if (mapping != null) {
                    MappingsViewer.this.addMappingSummary(config, mapping);
                }
            }
        });
    }

    void addMappingSummary(TransformationConfig config, MappingOperation<?, ?> mapping) {
        MappingSummary mappingSummary = new MappingSummary(config, mapping, this, this.potentialDropTargets);
        this.mappingSummaries.add(mappingSummary);
        this.layoutPanes();
        this.scroller.setMinSize(this.summaryPane.computeSize(-1, -1));
        this.scroller.setOrigin(0, this.scroller.getSize().y);
        mappingSummary.sourceText.setFocus();
    }

    private void focusOnMappingSummary(int index) {
        MappingSummary mappingSummary = this.mappingSummaries.get(index);
        if (this.selectedMappingSummary.sourceText.isFocusControl()) {
            mappingSummary.sourceText.setFocus();
        } else {
            mappingSummary.targetText.setFocus();
        }
    }

    void layoutPanes() {
        this.sourcePane.layout();
        this.mapsToPane.layout();
        this.targetPane.layout();
    }

    void removeMappingSummary(MappingSummary mappingSummary) {
        this.mappingSummaries.remove(mappingSummary);
        if (mappingSummary == this.selectedMappingSummary) {
            this.selectedMappingSummary = null;
            this.deleteButton.setEnabled(false);
        }
        this.layoutPanes();
        this.scroller.setMinSize(this.summaryPane.computeSize(-1, -1));
    }

    void selected(MappingSummary mappingSummary) {
        if (this.selectedMappingSummary != null && mappingSummary != this.selectedMappingSummary) {
            this.selectedMappingSummary.deselect();
        }
        this.selectedMappingSummary = mappingSummary;
        this.deleteButton.setEnabled(true);
        this.editor.selected(mappingSummary.mapping);
    }

    void selectNextMappingSummary() {
        int ndx = this.mappingSummaries.indexOf((Object)this) + 1;
        if (ndx < this.mappingSummaries.size()) {
            this.focusOnMappingSummary(ndx);
        }
    }

    void selectPreviousMappingSummary() {
        int ndx = this.mappingSummaries.indexOf((Object)this) - 1;
        if (ndx >= 0) {
            this.focusOnMappingSummary(ndx);
        }
    }

    static interface CustomFunctionListener {
        public void functionChanged(String var1);
    }

    static final class TraversalListener
    implements TraverseListener {
        Text prevText;
        Text nextText;
        TraversalListener prevTraversalListener;
        TraversalListener nextTraversalListener;

        TraversalListener(Text prevText, Text nextText) {
            this.prevText = prevText;
            this.nextText = nextText;
        }

        public void keyTraversed(TraverseEvent event) {
            if (event.detail == 16) {
                if (this.nextText != null) {
                    event.detail = 0;
                    event.doit = false;
                    this.nextText.setFocus();
                }
            } else if (event.detail == 8 && this.prevText != null) {
                event.detail = 0;
                event.doit = false;
                this.prevText.setFocus();
            }
        }
    }
}

