/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.CustomMapping;
import org.jboss.tools.fuse.transformation.FieldMapping;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.MappingType;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.AddCustomFunctionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.ExpressionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.MappingViewer;
import org.jboss.tools.fuse.transformation.editor.internal.ModelViewer;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.util.BaseDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.model.Model;

public final class MappingDetailViewer
extends MappingViewer {
    final ScrolledComposite scroller;
    final Point imageButtonLabelSize;

    public MappingDetailViewer(TransformationConfig config, Composite parent, List<PotentialDropTarget> potentialDropTargets) {
        super(config, potentialDropTargets);
        this.scroller = new ScrolledComposite(parent, 768);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.setBackground(parent.getDisplay().getSystemColor(1));
        Label label = new Label((Composite)parent.getShell(), 0);
        label.setImage(Util.Images.MENU);
        this.imageButtonLabelSize = label.computeSize(-1, -1);
        label.dispose();
        config.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                MappingDetailViewer.this.configEvent(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
        });
    }

    void addCustomFunction() throws Exception {
        AddCustomFunctionDialog dlg = new AddCustomFunctionDialog(this.scroller.getShell(), this.config.project(), ((Model)this.mapping.getSource()).getType());
        if (dlg.open() != 0) {
            return;
        }
        this.mapping = this.config.customizeMapping((FieldMapping)this.mapping, dlg.type.getFullyQualifiedName(), dlg.method.getElementName());
        this.config.save();
    }

    void configEvent(String eventType, Object oldValue, Object newValue) {
        switch (eventType) {
            case "mapping": {
                if (this.equals(this.mapping, oldValue)) {
                    this.scroller.setContent(null);
                    break;
                }
                if (newValue == null) break;
                this.update((MappingOperation)newValue);
                break;
            }
            case "mappingCustomize": 
            case "mappingSource": 
            case "mappingTarget": {
                if (!this.equals(this.mapping, oldValue)) break;
                this.update((MappingOperation)newValue);
                break;
            }
            case "variableValue": {
                this.variableValueUpdated((Variable)newValue);
            }
        }
    }

    private void createCustomSourcePane(Composite parent) {
        Composite pane = this.createRoundedPane(parent, Util.Colors.FUNCTION);
        pane.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        new ControlWithMenuPane(this, pane){

            @Override
            Control constructControl() {
                Label functionLabel = new Label((Composite)this, 0);
                CustomMapping customMapping = (CustomMapping)mapping;
                functionLabel.setText(customMapping.getMappingOperation());
                functionLabel.setToolTipText(String.valueOf(customMapping.getMappingClass()) + '.' + customMapping.getMappingOperation());
                this.addMenuItem("Remove custom function", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.removeCustomFunction();
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                return functionLabel;
            }
        };
        Label label = new Label(pane, 0);
        label.setText("(");
        this.createSourcePane(pane);
        label = new Label(pane, 0);
        label.setText(")");
    }

    private Composite createDetailPane(Composite parent, Model model) {
        Composite pane = this.createRoundedPane(parent, Util.Colors.MODEL);
        Label label = new Label(pane, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).create());
        label.setText(model.getName());
        label.setBackground(pane.getForeground());
        return pane;
    }

    private Composite createRoundedPane(Composite parent, Color color) {
        Composite pane = new Composite(parent, 0);
        pane.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        pane.setBackground(parent.getForeground());
        pane.setForeground(color);
        pane.addPaintListener(Util.roundedRectanglePainter(10, pane.getForeground()));
        return pane;
    }

    private void createSourcePane(Composite parent) {
        new ControlWithMenuPane(this, parent){

            @Override
            Control constructControl() {
                this.createSourceText(this, 0);
                sourceText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                this.addMenuItem("Set field", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.setField(true);
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                this.addMenuItem("Set variable", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    boolean enabled() {
                        return mapping.getType() != MappingType.CUSTOM;
                    }

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.setVariable();
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                this.addMenuItem("Set expression", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    boolean enabled() {
                        return mapping.getType() != MappingType.CUSTOM;
                    }

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.setExpression();
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                this.addMenuItem("Add custom function", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    boolean enabled() {
                        return mapping.getType() == MappingType.FIELD;
                    }

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.addCustomFunction();
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                return sourceText;
            }
        };
    }

    private void createTargetPane(Composite parent) {
        new ControlWithMenuPane(this, parent){

            @Override
            Control constructControl() {
                this.createTargetText(this);
                targetText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                this.addMenuItem("Set field", new ControlWithMenuPane.MenuItemHandler(this){

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        try {
                            this.setField(false);
                        }
                        catch (Exception e) {
                            Activator.error(e);
                        }
                    }
                });
                return targetText;
            }
        };
    }

    @Override
    Text createText(Composite parent, int style) {
        final Text text = super.createText(parent, style);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                text.selectAll();
            }
        });
        return text;
    }

    protected void finalize() throws Throwable {
        this.sourceDropTarget.dispose();
        this.targetDropTarget.dispose();
        super.finalize();
    }

    void removeCustomFunction() throws Exception {
        this.config.uncustomizeMapping((CustomMapping)this.mapping);
        this.config.save();
    }

    void setExpression() throws Exception {
        ExpressionDialog dlg = new ExpressionDialog(this.sourceText.getShell(), this.mapping, this.config.project());
        if (dlg.open() != 0) {
            return;
        }
        Util.updateMavenDependencies(dlg.getLanguage().getDependencies(), this.config.project());
        Model targetModel = (Model)this.mapping.getTarget();
        List<Integer> indexes = targetModel != null && Util.isOrInCollection(targetModel) ? Util.indexes(this.sourceText.getShell(), targetModel, false) : null;
        this.mapping = this.config.setSourceExpression(this.mapping, dlg.getLanguage().getName(), dlg.getExpression(), indexes);
        this.config.save();
    }

    void setField(boolean source) throws Exception {
        FieldDialog dlg = new FieldDialog(source ? this.config.getSourceModel() : this.config.getTargetModel());
        if (dlg.open() != 0) {
            return;
        }
        if (source) {
            this.setSource(dlg.field);
        } else {
            this.setTarget(dlg.field);
        }
    }

    void setVariable() throws Exception {
        VariableDialog dlg = new VariableDialog();
        if (dlg.open() != 0) {
            return;
        }
        Model targetModel = (Model)this.mapping.getTarget();
        List<Integer> indexes = targetModel != null && Util.isOrInCollection(targetModel) ? Util.indexes(this.sourceText.getShell(), targetModel, false) : null;
        this.mapping = this.config.setSource(this.mapping, dlg.variable, null, indexes);
        this.config.save();
    }

    public void update(MappingOperation<?, ?> mapping) {
        this.mapping = mapping;
        if (this.sourceDropTarget != null) {
            this.dispose();
        }
        Composite contentPane = new Composite((Composite)this.scroller, 0);
        this.scroller.setContent((Control)contentPane);
        contentPane.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        contentPane.setBackground(this.scroller.getBackground());
        contentPane.setForeground(contentPane.getBackground());
        Composite sourceDetailPane = this.createDetailPane(contentPane, this.config.getSourceModel());
        sourceDetailPane.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(true, true).create());
        if (mapping instanceof CustomMapping) {
            this.createCustomSourcePane(sourceDetailPane);
        } else {
            this.createSourcePane(sourceDetailPane);
        }
        Label mapsToLabel = new Label(contentPane, 0);
        mapsToLabel.setImage(Util.Images.MAPPED);
        mapsToLabel.setBackground(contentPane.getBackground());
        Composite targetDetailPane = this.createDetailPane(contentPane, this.config.getTargetModel());
        targetDetailPane.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(true, true).create());
        this.createTargetPane(targetDetailPane);
        this.scroller.setMinSize(contentPane.computeSize(-1, -1));
        contentPane.layout();
    }

    private abstract class ControlWithMenuPane
    extends Composite {
        final Map<String, MenuItemHandler> menuItems;

        ControlWithMenuPane(Composite parent) {
            super(parent, 0);
            this.menuItems = new LinkedHashMap<String, MenuItemHandler>();
            this.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(1, 5).create());
            this.setBackground(parent.getForeground());
            Label spacer = new Label((Composite)this, 0);
            spacer.setLayoutData((Object)GridDataFactory.swtDefaults().hint(MappingDetailViewer.this.imageButtonLabelSize).create());
            spacer.setBackground(this.getBackground());
            Control control = this.constructControl();
            final Label menuLabel = new Label((Composite)this, 0);
            menuLabel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(MappingDetailViewer.this.imageButtonLabelSize).align(1, 1024).create());
            menuLabel.setBackground(this.getBackground());
            MouseTrackAdapter mouseOverListener = new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent event) {
                    menuLabel.setImage(Util.Images.MENU);
                }

                public void mouseExit(MouseEvent event) {
                    menuLabel.setImage(null);
                }
            };
            this.addMouseTrackListener((MouseTrackListener)mouseOverListener);
            spacer.addMouseTrackListener((MouseTrackListener)mouseOverListener);
            control.addMouseTrackListener((MouseTrackListener)mouseOverListener);
            menuLabel.addMouseTrackListener((MouseTrackListener)mouseOverListener);
            menuLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    ControlWithMenuPane.this.popupMenu(menuLabel, event.x, event.y);
                }
            });
        }

        void addMenuItem(String item, MenuItemHandler handler) {
            this.menuItems.put(item, handler);
        }

        abstract Control constructControl();

        void popupMenu(Label menuLabel, int xPos, int yPos) {
            Point size = menuLabel.getSize();
            if (xPos < 0 || xPos > size.x || yPos < 0 || yPos > size.y) {
                return;
            }
            Menu popupMenu = new Menu((Control)menuLabel);
            menuLabel.setMenu(popupMenu);
            for (Map.Entry<String, MenuItemHandler> entry : this.menuItems.entrySet()) {
                MenuItem item = new MenuItem(popupMenu, 0);
                item.setText(entry.getKey());
                item.addSelectionListener((SelectionListener)entry.getValue());
                item.setEnabled(entry.getValue().enabled());
            }
            popupMenu.setLocation(this.toDisplay(menuLabel.getLocation().x, menuLabel.getLocation().y + size.y + 5));
            popupMenu.setVisible(true);
        }

        abstract class MenuItemHandler
        extends SelectionAdapter {
            MenuItemHandler() {
            }

            boolean enabled() {
                return true;
            }

            public final void widgetDefaultSelected(SelectionEvent event) {
            }

            public abstract void widgetSelected(SelectionEvent var1);
        }
    }

    final class FieldDialog
    extends BaseDialog {
        private final Model rootModel;
        Model field;

        FieldDialog(Model rootModel) {
            super(MappingDetailViewer.this.sourceText.getShell());
            this.rootModel = rootModel;
            if (MappingDetailViewer.this.mapping.getSource() instanceof Model) {
                this.field = rootModel.equals((Object)MappingDetailViewer.this.config.getSourceModel()) ? (Model)MappingDetailViewer.this.mapping.getSource() : (Model)MappingDetailViewer.this.mapping.getTarget();
            }
        }

        @Override
        protected void constructContents(Composite parent) {
            parent.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
            final ModelViewer modelViewer = new ModelViewer(MappingDetailViewer.this.config, parent, this.rootModel, null);
            modelViewer.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
            if (this.field != null) {
                modelViewer.select(this.field);
            }
            modelViewer.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)modelViewer.treeViewer.getSelection();
                    FieldDialog.this.field = (Model)selection.getFirstElement();
                    FieldDialog.this.validate();
                }
            });
        }

        @Override
        protected String message() {
            return "Select a field.";
        }

        @Override
        protected String title() {
            return "Field";
        }

        void validate() {
            boolean enabled;
            boolean bl = enabled = this.field != null && !Util.type(this.field);
            if (enabled) {
                enabled = this.rootModel.equals((Object)MappingDetailViewer.this.config.getSourceModel()) ? Util.validSourceAndTarget(this.field, MappingDetailViewer.this.mapping.getTarget(), MappingDetailViewer.this.config) : Util.validSourceAndTarget(MappingDetailViewer.this.mapping.getSource(), this.field, MappingDetailViewer.this.config);
            }
            this.setErrorMessage(enabled ? null : "Invalid field");
            this.getButton(0).setEnabled(enabled);
        }
    }

    final class VariableDialog
    extends BaseDialog {
        Variable variable;

        VariableDialog() {
            super(MappingDetailViewer.this.sourceText.getShell());
            if (MappingDetailViewer.this.mapping.getSource() instanceof Variable) {
                this.variable = (Variable)MappingDetailViewer.this.mapping.getSource();
            }
        }

        @Override
        protected void constructContents(Composite parent) {
            parent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
            Label label = new Label(parent, 0);
            label.setText("Variable:");
            final ComboViewer comboViewer = new ComboViewer(parent, 8);
            comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return Util.Images.VARIABLE;
                }

                public String getText(Object element) {
                    return ((Variable)element).getName();
                }
            });
            comboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
                    VariableDialog.this.variable = (Variable)selection.getFirstElement();
                    VariableDialog.this.validate();
                }
            });
            comboViewer.setInput(MappingDetailViewer.this.config.getVariables());
            if (this.variable != null) {
                comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.variable));
            }
        }

        @Override
        protected String message() {
            return "Select a variable.";
        }

        @Override
        protected String title() {
            return "Variable";
        }

        void validate() {
            this.getButton(0).setEnabled(this.variable != null);
        }
    }
}

