/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.camel.model.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.catalog.languages.Language;
import org.jboss.tools.fuse.transformation.Expression;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.editor.internal.util.BaseDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.ClasspathResourceSelectionDialog;

public class ExpressionDialog
extends BaseDialog {
    final List<Language> languages = new ArrayList<Language>();
    private Language language;
    private String expression;
    private Button browseBtn;
    private ComboViewer languageComboViewer;
    private Text expressionText;
    private Expression expressionInstance = null;
    private Button valueOption;
    private Button scriptOption;
    private ComboViewer scriptTypeComboViewer;
    private Text pathText;
    private IProject project;

    public ExpressionDialog(Shell shell, MappingOperation<?, ?> mapping, IProject project) {
        super(shell);
        this.project = project;
        String languageName = null;
        if (mapping.getSource() instanceof Expression) {
            this.expressionInstance = (Expression)mapping.getSource();
            this.expression = this.expressionInstance.getExpression();
            languageName = this.expressionInstance.getLanguage();
        }
        String version = (String)CamelModelFactory.getSupportedCamelVersions().get(0);
        for (Language language : CamelModelFactory.getModelForVersion((String)version).getLanguageModel().getSupportedLanguages()) {
            String name = language.getName();
            if (name.equals("bean") || name.equals("file") || name.equals("sql") || name.equals("xtokenize") || name.equals("tokenize") || name.equals("spel")) continue;
            if (languageName != null && name.equals(languageName)) {
                this.language = language;
            }
            this.languages.add(language);
        }
    }

    @Override
    protected void constructContents(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        Label label = new Label(parent, 0);
        label.setText("Language:");
        this.languageComboViewer = new ComboViewer(parent, 8);
        this.languageComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageComboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                return ((Language)object1).getTitle().compareTo(((Language)object2).getTitle());
            }
        });
        this.languageComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Language)element).getTitle();
            }
        });
        this.languageComboViewer.getCombo().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).create());
        Group detailsGroup = new Group(parent, 0);
        detailsGroup.setText("Details");
        detailsGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        detailsGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        this.valueOption = new Button((Composite)detailsGroup, 16);
        this.valueOption.setText("Value");
        this.valueOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.valueOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.scriptTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)""));
                ExpressionDialog.this.pathText.setText("");
                ExpressionDialog.this.expression = "";
                ExpressionDialog.this.expressionText.setText(ExpressionDialog.this.expression.replace("\\${", "${"));
                ExpressionDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)detailsGroup, 0);
        label.setText("Expression:");
        label.setLayoutData((Object)GridDataFactory.fillDefaults().indent(20, 0).create());
        this.expressionText = new Text((Composite)detailsGroup, 2048);
        this.expressionText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(20, 0).grab(true, false).span(2, 1).create());
        if (this.expression != null) {
            this.expressionText.setText(this.expression.replace("\\${", "${"));
        }
        this.scriptOption = new Button((Composite)detailsGroup, 16);
        this.scriptOption.setText("Script");
        this.scriptOption.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.scriptOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)detailsGroup, 0);
        label.setText("Source:");
        label.setLayoutData((Object)GridDataFactory.fillDefaults().indent(20, 0).create());
        this.scriptTypeComboViewer = new ComboViewer((Composite)detailsGroup, 8);
        this.scriptTypeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.scriptTypeComboViewer.getCombo().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(20, 0).span(1, 1).create());
        this.scriptTypeComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.scriptTypeComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExpressionDialog.this.updateExpression();
            }
        });
        WritableList sourceList = new WritableList();
        sourceList.add((Object)"classpath");
        sourceList.add((Object)"file");
        sourceList.add((Object)"http");
        sourceList.add((Object)"");
        this.scriptTypeComboViewer.setInput((Object)sourceList);
        this.browseBtn = new Button((Composite)detailsGroup, 8);
        this.browseBtn.setText("...");
        this.browseBtn.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = ExpressionDialog.this.selectResourceFromWorkspace(ExpressionDialog.this.browseBtn.getShell(), "");
                if (path != null) {
                    ExpressionDialog.this.pathText.setText(path);
                    ExpressionDialog.this.pathText.notifyListeners(24, null);
                }
            }
        });
        label = new Label((Composite)detailsGroup, 0);
        label.setText("Path:");
        label.setLayoutData((Object)GridDataFactory.fillDefaults().indent(20, 0).create());
        this.pathText = new Text((Composite)detailsGroup, 2048);
        this.pathText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(20, 0).span(2, 1).create());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionDialog.this.updateExpression();
            }
        });
        this.languageComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ExpressionDialog.this.languageComboViewer.getSelection();
                ExpressionDialog.this.language = (Language)selection.getFirstElement();
                ExpressionDialog.this.expressionText.setFocus();
                ExpressionDialog.this.validate();
                if (!ExpressionDialog.this.scriptOption.getSelection() && !ExpressionDialog.this.valueOption.getSelection()) {
                    ExpressionDialog.this.valueOption.setSelection(true);
                    ExpressionDialog.this.valueOption.notifyListeners(13, null);
                }
            }
        });
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String expr = ExpressionDialog.this.expressionText.getText().trim();
                int ndx = expr.indexOf("${");
                while (ndx >= 0) {
                    if (ndx == 0 || expr.charAt(ndx - 1) != '\\') {
                        expr = String.valueOf(expr.substring(0, ndx)) + '\\' + expr.substring(ndx);
                        ndx += 3;
                    } else if (expr.charAt(ndx - 1) == '\\') {
                        ndx += 3;
                    }
                    ndx = expr.indexOf("${", ndx);
                }
                ExpressionDialog.this.expression = expr;
                ExpressionDialog.this.validate();
            }
        });
        this.languageComboViewer.setInput(this.languages);
        if (this.language != null) {
            this.languageComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.language));
        }
        if (this.expression != null) {
            String part0 = this.getParameterPart(this.expression, 0);
            this.valueOption.setSelection(true);
            this.scriptOption.setSelection(false);
            if (part0.contentEquals("resource")) {
                this.valueOption.setSelection(false);
                this.scriptOption.setSelection(true);
                String part1 = this.getParameterPart(this.expression, 1);
                this.scriptTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)part1));
                String part2 = this.getParameterPart(this.expression, 2);
                this.pathText.setText(part2.replace("\\${", "${"));
            }
        }
    }

    private void updateExpression() {
        if (this.expression != null) {
            this.getParameterPart(this.expression, 0);
            if (this.scriptOption.getSelection()) {
                IStructuredSelection selection = (IStructuredSelection)this.scriptTypeComboViewer.getSelection();
                String value = (String)selection.getFirstElement();
                this.expression = "resource:" + value + ":" + this.pathText.getText().trim();
                this.expressionText.setText(this.expression.replace("\\${", "${"));
            } else {
                this.expressionText.setText(this.expression.replace("\\${", "${"));
            }
        }
    }

    @Override
    public void create() {
        super.create();
        this.validate();
    }

    @Override
    protected String message() {
        return "Select the expression language, then specify details for the expression.";
    }

    @Override
    protected String title() {
        return "Expression";
    }

    private String getParameterPart(String expression, int idx) {
        String part = null;
        String[] parts = expression.split(":");
        if (parts.length > idx) {
            part = parts[idx];
        }
        return part;
    }

    void validate() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.language != null && this.expression != null && !this.expression.isEmpty());
        }
        if (this.expressionText != null && !this.expressionText.isDisposed()) {
            this.browseBtn.setEnabled(false);
            this.expressionText.setEnabled(this.valueOption.getSelection());
            this.pathText.setEnabled(this.scriptOption.getSelection());
            this.scriptTypeComboViewer.getCombo().setEnabled(this.scriptOption.getSelection());
            IStructuredSelection selection = (IStructuredSelection)this.scriptTypeComboViewer.getSelection();
            String value = (String)selection.getFirstElement();
            this.browseBtn.setEnabled(value != null && value.equalsIgnoreCase("classpath") && this.scriptOption.getSelection());
        }
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    private String selectResourceFromWorkspace(Shell shell, String extension) {
        IJavaProject javaProject = null;
        if (this.project != null) {
            javaProject = JavaCore.create((IProject)this.project);
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), extension) : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), extension);
        dialog.setTitle("Select " + extension.toUpperCase() + " From Project");
        dialog.setInitialPattern("*." + extension);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        return ((IResource)result[0]).getProjectRelativePath().toPortableString();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Fuse Transformation");
    }
}

