/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.camel.CamelConfigBuilder;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelConfigurationHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

public class CamelEndpointSelectionDialog
extends TitleAreaDialog {
    String camelFilePath;
    String endpointID;
    IProject project;
    boolean updateCamelBuilder = false;
    String errMessage;
    CamelConfigBuilder camelConfigBuilder = null;
    ComboViewer endpointCombo;

    public CamelEndpointSelectionDialog(Shell parentShell, IProject project, String camelFilePath) {
        super(parentShell);
        this.project = project;
        this.camelFilePath = camelFilePath;
        this.endpointID = null;
        this.errMessage = null;
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Specify Camel Config and Endpoint ID");
        this.setMessage("Please specify path to the Camel configuration file \nand the ID of the endpoint to update with new transformation details.");
        this.getShell().setText("Update Camel Endpoint");
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Camel File path: ");
        label.setToolTipText("Path to the Camel configuration file.");
        final Text camelFilePathText = new Text(composite, 2048);
        camelFilePathText.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).grab(true, false).align(4, 0x1000000).create());
        camelFilePathText.setToolTipText(label.getToolTipText());
        camelFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CamelEndpointSelectionDialog.this.camelFilePath = camelFilePathText.getText();
                CamelEndpointSelectionDialog.this.updateCamelBuilder = true;
                CamelEndpointSelectionDialog.this.getButton(0).setEnabled(CamelEndpointSelectionDialog.this.validate());
            }
        });
        Button camelPathButton = new Button(composite, 0);
        camelPathButton.setText("...");
        camelPathButton.setToolTipText("Browse to select an available Camel file.");
        camelPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IResource res = Util.selectResourceFromWorkspace(CamelEndpointSelectionDialog.this.getShell(), ".xml", CamelEndpointSelectionDialog.this.project);
                if (res != null) {
                    IPath respath = JavaUtil.getJavaPathForResource(res);
                    String relpath = respath.makeRelative().toString();
                    try {
                        File camelFile = new File(CamelEndpointSelectionDialog.this.project.getFile(relpath).getLocationURI());
                        if (!camelFile.exists() && (camelFile = new File(CamelEndpointSelectionDialog.this.project.getFile("src/main/resources/" + relpath).getLocationURI())).exists()) {
                            CamelEndpointSelectionDialog.this.camelFilePath = relpath;
                            camelFilePathText.setText(relpath);
                            CamelEndpointSelectionDialog.this.updateCamelBuilder = true;
                            CamelEndpointSelectionDialog.this.getButton(0).setEnabled(CamelEndpointSelectionDialog.this.validate());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("Endpoint:");
        label.setToolTipText("The Endpoint ID used in the Camel configuration");
        this.endpointCombo = new ComboViewer(composite, 2056);
        this.endpointCombo.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).grab(true, false).align(4, 0x1000000).create());
        this.endpointCombo.getControl().setToolTipText(label.getToolTipText());
        this.endpointCombo.setLabelProvider((IBaseLabelProvider)new EndpointLabelProvider());
        this.endpointCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ISelection sel = arg0.getSelection();
                if (sel != null && !sel.isEmpty()) {
                    IStructuredSelection ssel = (IStructuredSelection)sel;
                    CamelEndpointSelectionDialog.this.endpointID = (String)ssel.getFirstElement();
                }
                CamelEndpointSelectionDialog.this.getButton(0).setEnabled(CamelEndpointSelectionDialog.this.validate());
            }
        });
        this.validate();
        this.setErrorMessage(null);
        return parent;
    }

    public String getCamelFilePath() {
        return this.camelFilePath;
    }

    public String getEndpointID() {
        return this.endpointID;
    }

    boolean validate() {
        this.errMessage = null;
        if (this.camelFilePath == null || this.camelFilePath.trim().isEmpty()) {
            this.errMessage = "A Camel file path must be supplied";
        } else {
            try {
                File testFile = new File(this.project.getFile(this.camelFilePath).getLocationURI());
                if (!testFile.exists() && (testFile = new File(this.project.getFile("src/main/resources/" + this.camelFilePath).getLocationURI())).exists()) {
                    this.camelFilePath = "src/main/resources/" + this.camelFilePath;
                    CamelConfigBuilder testBuilder = CamelConfigurationHelper.load(testFile).getConfigBuilder();
                    if (this.updateCamelBuilder) {
                        this.camelConfigBuilder = testBuilder;
                    }
                }
            }
            catch (Exception exception) {
                this.errMessage = "The Camel file path must refer to a valid Camel file";
            }
        }
        if (this.camelConfigBuilder != null && this.updateCamelBuilder) {
            this.endpointCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.endpointCombo.setInput((Object)this.camelConfigBuilder.getTransformEndpointIds());
        }
        this.updateCamelBuilder = false;
        if (this.endpointID == null || this.endpointID.toString().trim().isEmpty()) {
            this.errMessage = "An endpoint must be selected";
        } else {
            String id = this.endpointID.trim();
            if (this.camelConfigBuilder != null && this.camelConfigBuilder.getEndpoint(id) == null) {
                this.errMessage = "An endpoint does not exist with the specified id";
            }
        }
        this.setErrorMessage(this.errMessage);
        return this.getErrorMessage() == null;
    }

    class EndpointLabelProvider
    extends LabelProvider {
        EndpointLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return super.getText(element);
        }
    }
}

