/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.camel.model.catalog.CamelModelFactory;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.camel.CamelEndpoint;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.MappingDetailViewer;
import org.jboss.tools.fuse.transformation.editor.internal.MappingsViewer;
import org.jboss.tools.fuse.transformation.editor.internal.PotentialDropTarget;
import org.jboss.tools.fuse.transformation.editor.internal.SourceTabFolder;
import org.jboss.tools.fuse.transformation.editor.internal.TargetTabFolder;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

public class TransformationEditor
extends EditorPart
implements ISaveablePart2 {
    private static final int SASH_COLOR = 16;
    private static final int SASH_WIDTH = 3;
    TransformationConfig config;
    URLClassLoader loader;
    File camelConfigFile;
    CamelEndpoint camelEndpoint;
    MappingsViewer mappingsViewer;
    Text helpText;
    SourceTabFolder sourceTabFolder;
    TargetTabFolder targetTabFolder;
    MappingDetailViewer mappingDetailViewer;
    ToolItem sourceViewerButton;
    ToolItem targetViewerButton;
    final List<PotentialDropTarget> potentialDropTargets = new ArrayList<PotentialDropTarget>();

    void configEvent() {
        this.firePropertyChange(257);
    }

    public void createPartControl(Composite parent) {
        SashForm verticalSplitter = new SashForm(parent, 512);
        verticalSplitter.setBackground(parent.getDisplay().getSystemColor(16));
        verticalSplitter.setSashWidth(3);
        Composite pane = new Composite((Composite)verticalSplitter, 0);
        pane.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        pane.setBackground(Util.Colors.BACKGROUND);
        ToolBar toolBar = new ToolBar(pane, 0);
        toolBar.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 1024).create());
        this.sourceViewerButton = new ToolItem(toolBar, 32);
        this.sourceViewerButton.setImage(Util.Images.TREE);
        this.helpText = new Text(pane, 66);
        this.helpText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.helpText.setEditable(false);
        this.helpText.setBackground(pane.getBackground());
        toolBar = new ToolBar(pane, 0);
        toolBar.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1024).create());
        this.targetViewerButton = new ToolItem(toolBar, 32);
        this.targetViewerButton.setImage(Util.Images.TREE);
        final SashForm horizontalSplitter = new SashForm(pane, 256);
        horizontalSplitter.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, true).create());
        horizontalSplitter.setBackground(parent.getDisplay().getSystemColor(16));
        horizontalSplitter.setSashWidth(3);
        this.sourceTabFolder = new SourceTabFolder(this.config, (Composite)horizontalSplitter, this.potentialDropTargets);
        this.sourceTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransformationEditor.this.updateHelpText();
            }
        });
        this.mappingsViewer = new MappingsViewer(this.config, this, (Composite)horizontalSplitter, this.potentialDropTargets);
        this.targetTabFolder = new TargetTabFolder(this.config, (Composite)horizontalSplitter, this.potentialDropTargets);
        this.mappingDetailViewer = new MappingDetailViewer(this.config, (Composite)verticalSplitter, this.potentialDropTargets);
        verticalSplitter.setWeights(new int[]{75, 25});
        horizontalSplitter.setWeights(new int[]{33, 34, 33});
        this.sourceViewerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransformationEditor.this.sourceTabFolder.setVisible(TransformationEditor.this.sourceViewerButton.getSelection());
                horizontalSplitter.layout();
                TransformationEditor.this.sourceViewerButton.setToolTipText(TransformationEditor.this.sourceViewerButton.getSelection() ? "Hide the source/variables viewers" : "Show the source/variables viewers");
                TransformationEditor.this.updateHelpText();
            }
        });
        this.sourceViewerButton.setSelection(true);
        this.targetViewerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransformationEditor.this.targetTabFolder.setVisible(TransformationEditor.this.targetViewerButton.getSelection());
                horizontalSplitter.layout();
                TransformationEditor.this.targetViewerButton.setToolTipText(TransformationEditor.this.targetViewerButton.getSelection() ? "Hide the target viewer" : "Show the target viewer");
                TransformationEditor.this.updateHelpText();
            }
        });
        this.targetViewerButton.setSelection(true);
        this.config.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                TransformationEditor.this.configEvent();
            }
        });
        this.updateHelpText();
    }

    public void dispose() {
        super.dispose();
        if (this.loader != null) {
            try {
                this.loader.close();
            }
            catch (IOException e) {
                Activator.error(e);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IContentType contentType = Platform.getContentTypeManager().getContentType("org.jboss.tools.fuse.transformation.editor.dozer-config-content-type");
        if (!contentType.isAssociatedWith(input.getName())) {
            throw new PartInitException("The Fuse Transformation editor can only be opened with a Dozer configuration file.");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        IFile configFile = ((FileEditorInput)this.getEditorInput()).getFile();
        IJavaProject javaProject = JavaCore.create((IProject)configFile.getProject());
        try {
            this.loader = (URLClassLoader)JavaUtil.getProjectClassLoader(javaProject, ((Object)((Object)this)).getClass().getClassLoader());
            this.config = new TransformationConfig(configFile, this.loader);
        }
        catch (Exception e) {
            throw new PartInitException("Unable to load transformation configuration file", (Throwable)e);
        }
        CamelModelFactory.initializeModels();
    }

    public boolean isDirty() {
        return this.config.hasMappingPlaceholders();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public int promptToSaveOnClose() {
        return this.config.hasMappingPlaceholders() && !MessageDialog.openConfirm((Shell)this.mappingsViewer.getShell(), (String)"Confirm", (String)"Are you sure?\n\nAll incomplete mappings will be lost when the editor is closed.") ? 2 : 1;
    }

    public void selected(MappingOperation<?, ?> mapping) {
        this.sourceTabFolder.select(mapping.getSource());
        this.targetTabFolder.select(mapping.getTarget());
        this.mappingDetailViewer.update(mapping);
    }

    public void setFocus() {
        this.mappingsViewer.setFocus();
    }

    void updateHelpText() {
        if (this.sourceViewerButton.getSelection() && this.targetViewerButton.getSelection()) {
            if (this.sourceTabFolder.getSelectionIndex() == 0) {
                this.helpText.setText("Create a new mapping below by dragging a field in source " + this.config.getSourceModel().getName() + " on the left to a field in target " + this.config.getTargetModel().getName() + " on the right.");
            } else {
                this.helpText.setText("Create a new mapping below by dragging a variable from the list of variables on the left to a field in target " + this.config.getTargetModel().getName() + " on the right.");
            }
        } else {
            this.helpText.setText("");
        }
    }
}

