/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.composite;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Property;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.editor.diagram.shared.DomainPropertyInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.SCAPropertyTable;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class CompositePropertiesComposite
extends AbstractModelComposite<Composite>
implements ResourceSetListener {
    private Composite _composite;
    private TransactionalEditingDomain _domain = null;
    private SCAPropertyTable _compositeProperties = null;

    public CompositePropertiesComposite(ICompositeContainer container, org.eclipse.swt.widgets.Composite parent, int style) {
        super(Composite.class, container, parent, style);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        this._compositeProperties = new SCAPropertyTable(this, 2){

            @Override
            protected void removeFromList() {
                Property toRemove;
                final IStructuredSelection ssel = CompositePropertiesComposite.this._compositeProperties.getStructuredSelection();
                if (ssel != null && !ssel.isEmpty() && ssel.size() > 1) {
                    if (ssel != null && CompositePropertiesComposite.this._domain != null) {
                        CompositePropertiesComposite.this._domain.getCommandStack().execute((Command)new RecordingCommand(CompositePropertiesComposite.this._domain){

                            protected void doExecute() {
                                for (Property toRemove : ssel) {
                                    CompositePropertiesComposite.this.removeDomainProperty(toRemove);
                                }
                            }
                        });
                    }
                } else if (ssel != null && ssel.size() == 1 && (toRemove = CompositePropertiesComposite.this._compositeProperties.getTableSelection()) != null) {
                    CompositePropertiesComposite.this.removeDomainProperty(toRemove);
                }
            }

            @Override
            protected void addPropertyTypeToList() {
                DomainPropertyInputDialog dialog = new DomainPropertyInputDialog(Display.getCurrent().getActiveShell());
                int rtn_value = dialog.open();
                if (rtn_value == 0) {
                    String name = dialog.getPropertyName();
                    String value = dialog.getPropertyValue();
                    CompositePropertiesComposite.this.addDomainProperty(name, value);
                }
            }
        };
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this._compositeProperties.setLayoutData(data);
        this.adaptChildren((Control)this._compositeProperties);
        this.addDomainListener();
    }

    @Override
    public void refresh() {
        Composite composite = (Composite)this.getTargetObject();
        if (composite != null) {
            this._composite = composite;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (CompositePropertiesComposite.this._compositeProperties != null && !CompositePropertiesComposite.this._compositeProperties.isDisposed()) {
                        CompositePropertiesComposite.this._compositeProperties.setSelection((EList<Property>)CompositePropertiesComposite.this._composite.getProperty());
                        CompositePropertiesComposite.this._compositeProperties.setTargetObject((EObject)CompositePropertiesComposite.this._composite);
                    }
                }
            });
        }
    }

    public NotificationFilter getFilter() {
        return null;
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent arg0) {
        this.refresh();
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent arg0) throws RollbackException {
        return null;
    }

    private void addDomainListener() {
        if (this._domain == null) {
            this._domain = (TransactionalEditingDomainImpl)SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
            this._domain.addResourceSetListener((ResourceSetListener)this);
        }
    }

    private void removeDomainListener() {
        if (this._domain != null) {
            this._domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public void dispose() {
        this.removeDomainListener();
        super.dispose();
    }

    private void removeDomainProperty(final Property property) {
        EList properties;
        if (this._composite != null && (properties = this._composite.getProperty()) != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    properties.remove((Object)property);
                }
            });
        }
    }

    private void addDomainProperty(final String name, final String value) {
        if (this._composite != null) {
            this._domain.getCommandStack().execute((Command)new RecordingCommand(this._domain){

                protected void doExecute() {
                    EList properties = CompositePropertiesComposite.this._composite.getProperty();
                    Property newProperty = ScaFactory.eINSTANCE.createProperty();
                    newProperty.setName(name);
                    newProperty.setValue(value);
                    properties.add((Object)newProperty);
                }
            });
        }
    }
}

