/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.PropertyValue;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.switchyard.tools.ui.editor.Messages;

public abstract class SCAPropertyValueTable
extends org.eclipse.swt.widgets.Composite
implements ICellModifier {
    private TreeViewer _propertyTreeTable;
    public static final String NAME_COLUMN = "name";
    public static final String VALUE_COLUMN = "value";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public SCAPropertyValueTable(org.eclipse.swt.widgets.Composite parent, int style) {
        this(parent, style, false);
    }

    public SCAPropertyValueTable(org.eclipse.swt.widgets.Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this._propertyTreeTable = new TreeViewer((org.eclipse.swt.widgets.Composite)this, 0x10A40 | style | additionalStyles);
        this._propertyTreeTable.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true, 1, 5);
        gd11.heightHint = 100;
        this._propertyTreeTable.getTree().setLayoutData((Object)gd11);
        this._propertyTreeTable.getTree().setHeaderVisible(true);
        this._propertyTreeTable.getTree().setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(this._propertyTreeTable.getTree(), 16384);
        nameColumn.setText(Messages.label_name);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this._propertyTreeTable.getTree(), 16384);
        valueColumn.setText(Messages.label_value);
        valueColumn.setWidth(200);
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTypeTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTypeTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        this._propertyTreeTable.setCellEditors(new CellEditor[]{new TextCellEditor((org.eclipse.swt.widgets.Composite)this._propertyTreeTable.getTree()), new TextCellEditor((org.eclipse.swt.widgets.Composite)this._propertyTreeTable.getTree())});
        this._mAddButton = new Button((org.eclipse.swt.widgets.Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCAPropertyValueTable.this.addPropertyTypeToList();
                SCAPropertyValueTable.this._propertyTreeTable.refresh();
                SCAPropertyValueTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCAPropertyValueTable.this.updatePropertyTypeButtons();
            }
        });
        this._mRemoveButton = new Button((org.eclipse.swt.widgets.Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCAPropertyValueTable.this.removeFromList();
                SCAPropertyValueTable.this._propertyTreeTable.refresh();
                SCAPropertyValueTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyTypeButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected abstract void addPropertyTypeToList();

    protected abstract void removeFromList();

    public EList<PropertyValue> getSelection() {
        if (this._propertyTreeTable != null && this._propertyTreeTable.getInput() != null) {
            return (EList)this._propertyTreeTable.getInput();
        }
        return null;
    }

    public PropertyValue getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof PropertyValue) {
            return (PropertyValue)ssel.getFirstElement();
        }
        return null;
    }

    public IStructuredSelection getStructuredSelection() {
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty()) {
            IStructuredSelection ssel = (IStructuredSelection)this._propertyTreeTable.getSelection();
            return ssel;
        }
        return null;
    }

    public void updatePropertyTypeButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public void setSelection(EList<PropertyValue> properties) {
        this._propertyTreeTable.setInput(properties);
        this.updatePropertyTypeButtons();
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected void setFeatureValue(EObject eObject, String featureId, Object value) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                eObject.eSet(eStructuralFeature, value);
                break;
            }
            ++i;
        }
    }

    public boolean canModify(Object element, String value) {
        return element instanceof PropertyValue && (value.equalsIgnoreCase(VALUE_COLUMN) || NAME_COLUMN.equalsIgnoreCase(value));
    }

    public Object getValue(Object element, String value) {
        if (element instanceof PropertyValue) {
            if (value.equalsIgnoreCase(VALUE_COLUMN)) {
                return ((PropertyValue)element).getValue();
            }
            if (NAME_COLUMN.equalsIgnoreCase(value)) {
                return ((PropertyValue)element).getName();
            }
        }
        return null;
    }

    public void modify(Object element, final String propvalue, final Object value) {
        if (element instanceof TreeItem) {
            final TreeItem ti = (TreeItem)element;
            if (this.getTargetObject() instanceof Composite) {
                Composite composite = (Composite)this.getTargetObject();
                if (composite.eContainer() != null) {
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)composite);
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            PropertyValue parm = (PropertyValue)ti.getData();
                            SCAPropertyValueTable.this.setFeatureValue((EObject)parm, propvalue, value);
                            SCAPropertyValueTable.this.getTreeViewer().refresh(true);
                        }
                    });
                } else {
                    PropertyValue parm = (PropertyValue)ti.getData();
                    this.setFeatureValue((EObject)parm, propvalue, value);
                    this.getTreeViewer().refresh(true);
                }
            } else if (this.getTargetObject() instanceof Component) {
                Component component = (Component)this.getTargetObject();
                if (component.eContainer() != null) {
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)component);
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            PropertyValue parm = (PropertyValue)ti.getData();
                            SCAPropertyValueTable.this.setFeatureValue((EObject)parm, propvalue, value);
                            SCAPropertyValueTable.this.getTreeViewer().refresh(true);
                        }
                    });
                } else {
                    PropertyValue parm = (PropertyValue)ti.getData();
                    this.setFeatureValue((EObject)parm, propvalue, value);
                    this.getTreeViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TreeViewer getTreeViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTypeTreeContentProvider
    implements ITreeContentProvider {
        private EList<PropertyValue> _properties;

        private PropertyTypeTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof EList) {
                this._properties = (EList)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                return this._properties.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyValue[]) {
                return new Object[]{this._properties.toArray()};
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof PropertyValue) {
                return ((PropertyValue)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EList) {
                return ((EList)element).size() > 0;
            }
            return false;
        }
    }

    private class PropertyTypeTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String value) {
            if (element instanceof PropertyValue && value.equalsIgnoreCase(SCAPropertyValueTable.NAME_COLUMN)) {
                return true;
            }
            return element instanceof PropertyValue && value.equalsIgnoreCase(SCAPropertyValueTable.VALUE_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PropertyValue && columnIndex == 0) {
                return ((PropertyValue)element).getName();
            }
            if (element instanceof PropertyValue && columnIndex == 1) {
                PropertyValue tp = (PropertyValue)element;
                return tp.getValue();
            }
            return null;
        }
    }
}

