/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.compositereference;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class SCADiagramResizeCompositeReferenceFeature
extends DefaultResizeShapeFeature {
    public SCADiagramResizeCompositeReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        GraphicsAlgorithm textGa;
        super.resizeShape(context);
        GraphicsAlgorithm containerGA = context.getPictogramElement().getGraphicsAlgorithm();
        int width = containerGA.getWidth();
        int height = containerGA.getHeight();
        PictogramElement pictogramElement = context.getPictogramElement();
        Polygon polygon = null;
        if (!(pictogramElement.getGraphicsAlgorithm() instanceof Polygon)) {
            EList childGAs = pictogramElement.getGraphicsAlgorithm().getGraphicsAlgorithmChildren();
            for (GraphicsAlgorithm graphicsAlgorithm : childGAs) {
                if (!(graphicsAlgorithm instanceof Polygon)) continue;
                polygon = (Polygon)graphicsAlgorithm;
                break;
            }
        } else {
            polygon = (Polygon)pictogramElement.getGraphicsAlgorithm();
        }
        EList points = polygon.getPoints();
        float maxX = 0.0f;
        float maxY = 0.0f;
        for (Point point : points) {
            if ((float)point.getX() > maxX) {
                maxX = point.getX();
            }
            if (!((float)point.getY() > maxY)) continue;
            maxY = point.getY();
        }
        float scaleX = (float)width / maxX;
        float scaleY = (float)height / maxY;
        int left = 0;
        int right = width;
        if (scaleX != 1.0f || scaleY != 1.0f) {
            int i = -1;
            for (Point point : points) {
                int newX = Math.round((float)point.getX() * scaleX);
                if (++i == 1) {
                    right = newX;
                }
                if (i == 5) {
                    left = newX;
                }
                point.setX(newX);
                int newY = Math.round((float)point.getY() * scaleY);
                point.setY(newY);
            }
        }
        if ((textGa = this.findChildGA(pictogramElement.getGraphicsAlgorithm(), Text.class)) != null) {
            IGaService gaService = Graphiti.getGaService();
            Text text = (Text)textGa;
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            gaService.setLocationAndSize((GraphicsAlgorithm)text, left + 10, 0, right - left - 10, height);
        }
        this.layoutPictogramElement((PictogramElement)((Shape)pictogramElement).getContainer());
    }

    private GraphicsAlgorithm findChildGA(GraphicsAlgorithm parent, Class<?> gaSearchType) {
        EList childGAs = parent.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithm : childGAs) {
            if (graphicsAlgorithm.getClass().getCanonicalName().contentEquals(gaSearchType.getCanonicalName())) {
                return graphicsAlgorithm;
            }
            if (graphicsAlgorithm.getClass() != gaSearchType && gaSearchType.isAssignableFrom(graphicsAlgorithm.getClass())) {
                return graphicsAlgorithm;
            }
            if (graphicsAlgorithm.getGraphicsAlgorithmChildren().size() <= 0) continue;
            return this.findChildGA(graphicsAlgorithm, gaSearchType);
        }
        return null;
    }
}

