/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.wsdl.Port;
import org.switchyard.tools.models.switchyard1_0.soap.BasicAuthenticationType;
import org.switchyard.tools.models.switchyard1_0.soap.NTLMAuthenticationType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPBindingType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPFactory;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.WSDLPortSelectionDialog;

public class SOAPAuthenticationComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private SOAPBindingType _binding = null;
    private ComboViewer _authTypeCombo;
    private Text _authUserText;
    private Text _authPasswordText;
    private Text _authDomainText;
    private WritableValue _bindingValue;

    SOAPAuthenticationComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_authenticationDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_soapAuthenticationDetails;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getAuthenticationControl(this._panel);
        this.bindControls(context);
    }

    private Control getAuthenticationControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._authTypeCombo = this.createLabelAndComboViewer(composite, Messages.label_authenticationType, true);
        this._authTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._authTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] authTypes = new String[]{"Basic", "NTLM"};
        this._authTypeCombo.setInput((Object)authTypes);
        this._authUserText = this.createLabelAndText(composite, Messages.label_user);
        this._authPasswordText = this.createLabelAndText(composite, Messages.label_password);
        this._authDomainText = this.createLabelAndText(composite, Messages.label_domain);
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof SOAPBindingType) {
            this.setTargetObject(switchYardBindingType.eContainer());
            this._binding = (SOAPBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    public Port browse(Shell shell, IJavaProject project, String initialPattern) {
        Port result;
        WSDLPortSelectionDialog dialog = new WSDLPortSelectionDialog(shell, (IContainer)(project == null ? ResourcesPlugin.getWorkspace().getRoot() : project.getProject()));
        dialog.setInitialPattern(initialPattern);
        if (dialog.open() == 0 && (result = dialog.getSelectedPort()) != null) {
            return result;
        }
        return null;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._authTypeCombo.getCombo().getDisplay());
        this._bindingValue = new WritableValue(realm, null, SOAPBindingType.class);
        WritableValue authType = new WritableValue(realm, null, String.class);
        WritableValue basicAuthUser = new WritableValue(realm, null, String.class);
        WritableValue basicAuthPwd = new WritableValue(realm, null, String.class);
        WritableValue ntlmAuthDomain = new WritableValue(realm, null, String.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._authTypeCombo.getCombo()), (IObservableValue)authType);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authUserText, (int)24), (IObservableValue)basicAuthUser, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authPasswordText, (int)24), (IObservableValue)basicAuthPwd, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authDomainText, (int)24), (IObservableValue)ntlmAuthDomain, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        AuthComputedValue computed = new AuthComputedValue((IObservableValue)authType, (IObservableValue)basicAuthUser, (IObservableValue)basicAuthPwd, (IObservableValue)ntlmAuthDomain);
        final IObservableValue ntlmValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__NTLM);
        final IObservableValue basicValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__BASIC);
        final org.eclipse.core.databinding.Binding ntlmBinding = context.bindValue((IObservableValue)computed, ntlmValue, (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        final org.eclipse.core.databinding.Binding basicBinding = context.bindValue((IObservableValue)computed, basicValue, (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        final IValueChangeListener changeListener = new IValueChangeListener((IObservableValue)computed){
            private boolean _updating = false;
            private final /* synthetic */ IObservableValue val$computed;
            {
                this.val$computed = iObservableValue3;
            }

            public void handleValueChange(ValueChangeEvent event) {
                if (!this._updating) {
                    this._updating = true;
                    if (event.getSource() == ntlmValue || event.getSource() == basicValue) {
                        if (ntlmValue.getValue() == null) {
                            basicBinding.updateModelToTarget();
                        } else {
                            ntlmBinding.updateModelToTarget();
                        }
                    } else if (this.val$computed.getValue() instanceof NTLMAuthenticationType) {
                        ntlmBinding.updateTargetToModel();
                        basicValue.setValue(null);
                    } else {
                        basicBinding.updateTargetToModel();
                        ntlmValue.setValue(null);
                    }
                    this._updating = false;
                }
            }
        };
        IDisposeListener disposeListener = new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                ((IObservableValue)event.getSource()).removeValueChangeListener(changeListener);
            }
        };
        computed.addValueChangeListener(changeListener);
        ntlmValue.addValueChangeListener(changeListener);
        basicValue.addValueChangeListener(changeListener);
        computed.addDisposeListener(disposeListener);
        ntlmValue.addDisposeListener(disposeListener);
        basicValue.addDisposeListener(disposeListener);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }

    class AuthComputedValue
    extends ComputedValue {
        private IObservableValue _authType = null;
        private IObservableValue _basicAuthUser = null;
        private IObservableValue _basicAuthPwd = null;
        private IObservableValue _ntlmAuthDomain = null;

        public AuthComputedValue(IObservableValue authType, IObservableValue user, IObservableValue pwd, IObservableValue domain) {
            this._authType = authType;
            this._basicAuthUser = user;
            this._basicAuthPwd = pwd;
            this._ntlmAuthDomain = domain;
        }

        protected Object calculate() {
            String authTypeStr = (String)this._authType.getValue();
            String user = (String)this._basicAuthUser.getValue();
            String pwd = (String)this._basicAuthPwd.getValue();
            String domain = (String)this._ntlmAuthDomain.getValue();
            boolean isBasic = false;
            boolean isNtlm = false;
            if (authTypeStr == null) {
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            if (authTypeStr.equalsIgnoreCase("Basic")) {
                isBasic = true;
                if (user != null || pwd != null) {
                    BasicAuthenticationType basicAuth = SOAPFactory.eINSTANCE.createBasicAuthenticationType();
                    basicAuth.setUser(user);
                    basicAuth.setPassword(pwd);
                    this.updateControls(isBasic, isNtlm);
                    return basicAuth;
                }
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            if (authTypeStr.equalsIgnoreCase("NTLM")) {
                isNtlm = true;
                if (user != null || pwd != null || domain != null) {
                    NTLMAuthenticationType ntlmAuth = SOAPFactory.eINSTANCE.createNTLMAuthenticationType();
                    ntlmAuth.setUser(user);
                    ntlmAuth.setPassword(pwd);
                    ntlmAuth.setDomain(domain);
                    this.updateControls(isBasic, isNtlm);
                    return ntlmAuth;
                }
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            return null;
        }

        protected void doSetValue(Object value) {
            if (value instanceof NTLMAuthenticationType) {
                this._authType.setValue((Object)"NTLM");
                NTLMAuthenticationType ntlmAuth = (NTLMAuthenticationType)value;
                this._basicAuthPwd.setValue((Object)ntlmAuth.getPassword());
                this._basicAuthUser.setValue((Object)ntlmAuth.getUser());
                this._ntlmAuthDomain.setValue((Object)ntlmAuth.getDomain());
            } else if (value instanceof BasicAuthenticationType) {
                BasicAuthenticationType basicAuth = (BasicAuthenticationType)value;
                this._authType.setValue((Object)"Basic");
                this._basicAuthPwd.setValue((Object)basicAuth.getPassword());
                this._basicAuthUser.setValue((Object)basicAuth.getUser());
                this._ntlmAuthDomain.setValue(null);
            } else {
                this._authType.setValue(null);
                this._basicAuthPwd.setValue(null);
                this._basicAuthUser.setValue(null);
                this._ntlmAuthDomain.setValue(null);
            }
            this.getValue();
        }

        private void updateControls(boolean isBasic, boolean isNtlm) {
            SOAPAuthenticationComposite.this._authDomainText.setEnabled(isNtlm);
            SOAPAuthenticationComposite.this._authPasswordText.setEnabled(isBasic || isNtlm);
            SOAPAuthenticationComposite.this._authUserText.setEnabled(isBasic || isNtlm);
        }
    }
}

