/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.sql;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.sql.CamelSqlBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.sql.SqlPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyLongValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class CamelSQLComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelSqlBindingType _binding = null;
    private Text _nameText;
    private Text _queryText;
    private Text _dataSourceRefText;
    private Text _placeholderText;
    private OperationSelectorComposite _opSelectorComposite;
    private Text _periodText;
    private Text _initialDelayText;
    private WritableValue _bindingValue;

    CamelSQLComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_sqlBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_sqlBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelSqlBindingType) {
            this._binding = (CamelSqlBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
                this._opSelectorComposite.setTargetObject(this.getTargetObject());
            }
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
                this._opSelectorComposite.setBinding((Binding)this._binding);
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getSQLTabControl(this._panel);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service && this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        this.bindControls(context);
    }

    private Control getSQLTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._queryText = this.createLabelAndText(composite, Messages.label_queryStar);
        this._dataSourceRefText = this.createLabelAndText(composite, Messages.label_dataSourceStar);
        this._placeholderText = this.createLabelAndText(composite, "Placeholder:");
        if (this.getTargetObject() instanceof Service) {
            this._periodText = this.createLabelAndText(composite, Messages.label_periodStar);
            this._initialDelayText = this.createLabelAndText(composite, Messages.label_initialDelay);
        }
        if (this.getTargetObject() instanceof Service) {
            this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
            this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
            this._opSelectorComposite.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CamelSQLComposite.this.handleModify((Control)CamelSQLComposite.this._opSelectorComposite);
                }
            });
        }
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals((Object)this._opSelectorComposite)) {
            this.fireChangedEvent((Object)this._opSelectorComposite);
        }
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelSqlBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SQL binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SQL binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._queryText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SqlPackage.Literals.CAMEL_SQL_BINDING_TYPE__QUERY), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_emptyQuery)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._dataSourceRefText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SqlPackage.Literals.CAMEL_SQL_BINDING_TYPE__DATA_SOURCE_REF), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_emptyDataSourceReference)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._placeholderText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SqlPackage.Literals.CAMEL_SQL_BINDING_TYPE__PLACEHOLDER), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this._periodText != null && !this._periodText.isDisposed()) {
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._periodText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SqlPackage.Literals.CAMEL_SQL_BINDING_TYPE__PERIOD), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Period may not be empty.")), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        }
        if (this._initialDelayText != null && !this._initialDelayText.isDisposed()) {
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._initialDelayText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SqlPackage.Literals.CAMEL_SQL_BINDING_TYPE__INITIAL_DELAY), new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyLongValidator("Initial Delay must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        }
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.bindControls(domain, context);
        }
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

