/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.IBindingTypeExtension;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;

public final class BindingTypeExtensionManager {
    private static final BindingTypeExtensionManager INSTANCE = new BindingTypeExtensionManager();
    private Map<Class<? extends Binding>, IBindingTypeExtension> _cache = new HashMap<Class<? extends Binding>, IBindingTypeExtension>();
    private List<IBindingTypeExtension> _extensions = new ArrayList<IBindingTypeExtension>();
    private IBindingTypeExtension _defaultExtension = new DefaultBindingTypeExtension();

    public static BindingTypeExtensionManager instance() {
        return INSTANCE;
    }

    private BindingTypeExtensionManager() {
        this.loadExtensions();
    }

    public IBindingTypeExtension getExtensionFor(Class<? extends Binding> type) {
        if (this._cache.containsKey(type)) {
            return this._cache.get(type);
        }
        for (IBindingTypeExtension extension : this._extensions) {
            if (!extension.supports(type)) continue;
            this._cache.put(type, extension);
            return extension;
        }
        this._cache.put(type, this._defaultExtension);
        return this._defaultExtension;
    }

    public Collection<IBindingTypeExtension> getExtensions() {
        return Collections.unmodifiableCollection(this._extensions);
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.switchyard.tools.ui.editor", "editorExtension");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension pluginExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = pluginExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("bindingExtension".equals(element.getName())) {
                    try {
                        this._extensions.add((IBindingTypeExtension)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final class DefaultBindingComposite
    extends AbstractSYBindingComposite {
        private Composite _composite;

        private DefaultBindingComposite(FormToolkit toolkit) {
            super(toolkit);
        }

        @Override
        public String getTitle() {
            return Messages.constant_unknownBindingType;
        }

        @Override
        public String getDescription() {
            return Messages.constant_description_unknownBindingType;
        }

        @Override
        protected boolean validate() {
            return true;
        }

        @Override
        protected void handleModify(Control control) {
        }

        @Override
        public Composite getPanel() {
            return this._composite;
        }

        @Override
        public void createContents(Composite parent, int style, DataBindingContext context) {
            this._composite = this.getToolkit().createComposite(parent, style);
        }
    }

    private static final class DefaultBindingTypeExtension
    implements IBindingTypeExtension {
        private DefaultBindingTypeExtension() {
        }

        @Override
        public ICreateFeature[] newCreateFeatures(IFeatureProvider fp) {
            return new ICreateFeature[0];
        }

        public ImageDecorator getImageDecorator(Binding binding) {
            return new ImageDecorator(ImageProvider.IMG_16_UNKNOWN_IMPL);
        }

        @Override
        public boolean supports(Class<? extends Binding> type) {
            return false;
        }

        @Override
        public List<IBindingComposite> createComposites(FormToolkit toolkit, Binding binding) {
            return Collections.singletonList(new DefaultBindingComposite(toolkit));
        }

        @Override
        public List<String> getRequiredCapabilities(Binding object) {
            return Collections.emptyList();
        }

        @Override
        public String getTypeName(Binding object) {
            return Messages.constant_unknown;
        }
    }
}

