/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.switchyard.tools.ui.common.ILayoutUtilities;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.SwitchYardSettingsGroup;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.wizards.NewSwitchYardProjectWizard;

public class ProjectConfigurationWizardPage
extends WizardPage
implements ILayoutUtilities {
    private static final String DEFAULT_GROUP_ID = "com.example.switchyard";
    private Text _artifactIdText;
    private Text _groupIdText;
    private Text _namespaceText;
    private Text _packageNameText;
    private Button _isBundleCheckbox;
    private Button _useSwitchYardDependencyBOMCheckbox;
    private SwitchYardSettingsGroup _settingsGroup;
    private boolean _isInitialized;
    private String _groupId = "";
    private String _packageName = "";
    private String _namespace = "";
    private boolean _isBundled = false;
    private boolean _doesUseSwitchYardDependencyBOM;

    public ProjectConfigurationWizardPage() {
        super(ProjectConfigurationWizardPage.class.getSimpleName());
        this.setTitle(Messages.ProjectConfigurationWizardPage_wizardPageTitle);
        this.setDescription(Messages.ProjectConfigurationWizardPage_wizardPageDescription);
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public boolean isBundled() {
        return this._isBundled;
    }

    public boolean isSwitchYardBOMEnabled() {
        return this._doesUseSwitchYardDependencyBOM;
    }

    public ArtifactVersion getRuntimeVersion() {
        ISelection runtimeVersionListSelection = this._settingsGroup.getRuntimeVersionsList().getSelection();
        if (runtimeVersionListSelection.isEmpty()) {
            return null;
        }
        return (ArtifactVersion)((IStructuredSelection)runtimeVersionListSelection).getFirstElement();
    }

    public IRuntimeComponent getTargetRuntime() {
        return this._settingsGroup.getSelectedTargetRuntime();
    }

    public IProjectFacetVersion getConfigurationVersion() {
        return this._settingsGroup.getSelectedConfigurationVersion();
    }

    public Set<ISwitchYardComponentExtension> getSelectedComponents() {
        return this._settingsGroup.getSelectedComponents();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        Composite projectDetails = new Composite(content, 0);
        projectDetails.setLayout((Layout)new GridLayout(2, false));
        projectDetails.setLayoutData((Object)new GridData(768));
        Label label = new Label(projectDetails, 131072);
        label.setText(Messages.ProjectConfigurationWizardPage_labelArtifactID);
        this._artifactIdText = new Text(projectDetails, 2052);
        this._artifactIdText.setLayoutData((Object)new GridData(768));
        this._artifactIdText.setEnabled(false);
        label = new Label(projectDetails, 131072);
        label.setText(Messages.ProjectConfigurationWizardPage_labelGroupID);
        this._groupIdText = new Text(projectDetails, 2052);
        this._groupIdText.setLayoutData((Object)new GridData(768));
        this._groupIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String oldGroupId = ProjectConfigurationWizardPage.this._groupId;
                ProjectConfigurationWizardPage.this._groupId = ProjectConfigurationWizardPage.this._groupIdText.getText();
                ProjectConfigurationWizardPage.this.updatePackageName(oldGroupId, ProjectConfigurationWizardPage.this._groupId);
                ProjectConfigurationWizardPage.this.updateNamespaceGroup(oldGroupId, ProjectConfigurationWizardPage.this._groupId);
                ProjectConfigurationWizardPage.this.validate();
            }
        });
        label = new Label(projectDetails, 131072);
        label.setText(Messages.ProjectConfigurationWizardPage_labelTNS);
        this._namespaceText = new Text(projectDetails, 2052);
        this._namespaceText.setLayoutData((Object)new GridData(768));
        this._namespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ProjectConfigurationWizardPage.this._namespace = ProjectConfigurationWizardPage.this._namespaceText.getText();
                ProjectConfigurationWizardPage.this.validate();
            }
        });
        label = new Label(projectDetails, 131072);
        label.setText(Messages.ProjectConfigurationWizardPage_labelPackageName);
        this._packageNameText = new Text(projectDetails, 2052);
        this._packageNameText.setLayoutData((Object)new GridData(768));
        this._packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ProjectConfigurationWizardPage.this._packageName = ProjectConfigurationWizardPage.this._packageNameText.getText();
                ProjectConfigurationWizardPage.this.validate();
            }
        });
        label = new Label(projectDetails, 131072);
        this._isBundleCheckbox = new Button(projectDetails, 32);
        this._isBundleCheckbox.setText(Messages.ProjectConfigurationWizardPage_OSGIBundleCheckbox);
        GridData cbGD = new GridData(768);
        this._isBundleCheckbox.setLayoutData((Object)cbGD);
        this._isBundleCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigurationWizardPage.this._isBundled = ProjectConfigurationWizardPage.this._isBundleCheckbox.getSelection();
                ProjectConfigurationWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(projectDetails, 131072);
        this._useSwitchYardDependencyBOMCheckbox = new Button(projectDetails, 32);
        this._useSwitchYardDependencyBOMCheckbox.setText(Messages.ProjectConfigurationWizardPage_BOMCheckbox);
        GridData cb2GD = new GridData(768);
        this._useSwitchYardDependencyBOMCheckbox.setLayoutData((Object)cb2GD);
        this._useSwitchYardDependencyBOMCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectConfigurationWizardPage.this._doesUseSwitchYardDependencyBOM = ProjectConfigurationWizardPage.this._useSwitchYardDependencyBOMCheckbox.getSelection();
                ProjectConfigurationWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite settingsContent = new Composite(content, 0);
        settingsContent.setLayout((Layout)new GridLayout());
        settingsContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this._settingsGroup = new SwitchYardSettingsGroup(settingsContent, this, (IRunnableContext)this.getContainer());
        this._settingsGroup.getRuntimeVersionsList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectConfigurationWizardPage.this.validate();
            }
        });
        this._settingsGroup.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean testRuntimeVersion = ProjectConfigurationWizardPage.this.isSelectedRuntimeV2();
                boolean testConfigVersion = ProjectConfigurationWizardPage.this.isSelectedConfigurationVersionOkForRuntime();
                boolean isKaraf = ProjectConfigurationWizardPage.this.isKarafRuntime();
                ProjectConfigurationWizardPage.this._useSwitchYardDependencyBOMCheckbox.setEnabled(testRuntimeVersion);
                ProjectConfigurationWizardPage.this._doesUseSwitchYardDependencyBOM = testRuntimeVersion;
                ProjectConfigurationWizardPage.this._useSwitchYardDependencyBOMCheckbox.setSelection(ProjectConfigurationWizardPage.this._doesUseSwitchYardDependencyBOM & testConfigVersion);
                ProjectConfigurationWizardPage.this._isBundleCheckbox.setSelection(isKaraf);
                ProjectConfigurationWizardPage.this._isBundled = isKaraf;
                ProjectConfigurationWizardPage.this.validate();
            }
        });
        this.setControl((Control)content);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String projectName = ((NewSwitchYardProjectWizard)this.getWizard()).getProjectName();
            if (!this._isInitialized) {
                this.initRuntimeVersionsList();
                this._packageNameText.setText(this.normalizePackageName(projectName));
                this._namespaceText.setText("urn::" + projectName + ":1.0");
                this._groupIdText.setText(DEFAULT_GROUP_ID);
                this._useSwitchYardDependencyBOMCheckbox.setSelection(this._doesUseSwitchYardDependencyBOM);
                this._useSwitchYardDependencyBOMCheckbox.setEnabled(this._doesUseSwitchYardDependencyBOM);
                this.validate();
                this.setErrorMessage(null);
                this._isInitialized = true;
            } else if (!this._packageNameText.getText().contentEquals(this.normalizePackageName(projectName))) {
                this._packageNameText.setText(this.normalizePackageName(projectName));
                this._namespaceText.setText("urn::" + projectName + ":1.0");
            }
            this._artifactIdText.setText(projectName);
        }
        super.setVisible(visible);
    }

    private void initRuntimeVersionsList() {
        this._settingsGroup.getAvailableVersions();
        if (this.getRuntimeVersion() == null) {
            this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection((Object)new DefaultArtifactVersion("2.0.0.Final")));
        }
    }

    private void validate() {
        this.setMessage(null);
        this.setErrorMessage(null);
        IStatus packageNameStatus = JavaConventions.validatePackageName((String)this._packageName, (String)"1.6", (String)"1.6");
        if (!packageNameStatus.isOK()) {
            StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)packageNameStatus);
        } else if (this.getErrorMessage() == null) {
            ArtifactVersion version = this.getRuntimeVersion();
            if (version == null) {
                this.setErrorMessage(Messages.ProjectConfigurationWizardPage_errorMessage_pleaseSpecifySwitchYardVersion);
            }
            if (!this.isSelectedConfigurationVersionOkForRuntime()) {
                if (this.getRuntimeVersion() != null) {
                    String configVersion = this.getMajorMinorFromVersion(this.getRuntimeVersion().toString());
                    this.setErrorMessage("The Configuration Version must be " + configVersion + " or lower to work with Library Version " + this.getRuntimeVersion().toString() + ".");
                } else {
                    this.setErrorMessage("The Configuration and Library Versions must be set to work with the SwitchYard Runtime.");
                }
            }
            if (this._doesUseSwitchYardDependencyBOM && !this.isSelectedRuntimeV2()) {
                this.setErrorMessage(Messages.ProjectConfigurationWizardPage_errorMessage_bomRequiresVersion2);
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private boolean isKarafRuntime() {
        String label;
        IRuntimeComponent runtime = this._settingsGroup.getSelectedTargetRuntime();
        return runtime != null && (label = runtime.getProperty("switchyard.label")).contains("SwitchYard: Karaf Extension");
    }

    private boolean isSelectedRuntimeV2() {
        String versionString;
        ArtifactVersion artversion = this.getRuntimeVersion();
        if (artversion != null && (versionString = artversion.toString()).indexOf(46) > -1) {
            String majorVersionString = versionString.substring(0, versionString.indexOf(46));
            try {
                long major = Long.decode(majorVersionString);
                return major >= 2L;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private float convertVersionStringToLong(String strVersion) {
        float version;
        try {
            version = Float.parseFloat(strVersion);
        }
        catch (NumberFormatException numberFormatException) {
            version = -1.0f;
        }
        return version;
    }

    private String getMajorMinorFromVersion(String inString) {
        try {
            String[] versionSplit = inString.split("\\.");
            if (versionSplit.length > 1) {
                return String.valueOf(versionSplit[0]) + "." + versionSplit[1];
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private boolean isSelectedConfigurationVersionOkForRuntime() {
        float runtimeVersion;
        String runtimeVersionStr;
        String majorMinorRuntime;
        float configVersion;
        String configVersionStr = this.getConfigurationVersion().getVersionString();
        String majorMinorConfig = this.getMajorMinorFromVersion(configVersionStr);
        return majorMinorConfig != null && (configVersion = this.convertVersionStringToLong(configVersionStr)) > -1.0f && this.getRuntimeVersion() != null && (majorMinorRuntime = this.getMajorMinorFromVersion(runtimeVersionStr = this.getRuntimeVersion().toString())) != null && (runtimeVersion = this.convertVersionStringToLong(majorMinorRuntime)) > -1.0f && configVersion <= runtimeVersion;
    }

    private void updateNamespaceGroup(String oldGroupId, String newGroupId) {
        String namespaceGroup;
        while (oldGroupId.endsWith(".")) {
            oldGroupId = oldGroupId.substring(0, oldGroupId.length() - 1);
        }
        while (newGroupId.endsWith(".")) {
            newGroupId = newGroupId.substring(0, newGroupId.length() - 1);
        }
        if (oldGroupId.equals(newGroupId)) {
            return;
        }
        Matcher matcher = Pattern.compile("urn:([^:]*)(:.*)").matcher(this._namespace);
        if (matcher.matches() && oldGroupId.equals(namespaceGroup = matcher.group(1))) {
            this._namespaceText.setText("urn:" + newGroupId + matcher.group(2));
        }
    }

    private void updatePackageName(String oldGroupId, String newGroupId) {
        while (oldGroupId.endsWith(Messages.ProjectConfigurationWizardPage_18)) {
            oldGroupId = oldGroupId.substring(0, oldGroupId.length() - 1);
        }
        while (newGroupId.endsWith(".")) {
            newGroupId = newGroupId.substring(0, newGroupId.length() - 1);
        }
        if ((oldGroupId = this.normalizePackageName(oldGroupId)).equals(newGroupId = this.normalizePackageName(newGroupId))) {
            return;
        }
        if (!this._packageName.startsWith(oldGroupId)) {
            return;
        }
        if (oldGroupId.length() == 0) {
            if (this._packageName.length() == 0) {
                this._packageNameText.setText(newGroupId);
            } else {
                this._packageNameText.setText(String.valueOf(newGroupId) + '.' + this._packageName);
            }
        } else if (this._packageName.equals(oldGroupId)) {
            this._packageNameText.setText(newGroupId);
        } else if (this._packageName.charAt(oldGroupId.length()) == '.') {
            this._packageNameText.setText(String.valueOf(newGroupId) + this._packageName.substring(oldGroupId.length() + (newGroupId.length() == 0 ? 1 : 0)));
        } else {
            this._packageNameText.setText(String.valueOf(newGroupId) + '.' + this._packageName.substring(oldGroupId.length()));
        }
    }

    private String normalizePackageName(String proposedPackageName) {
        return proposedPackageName.replaceAll("[^\\w\\.]", "_");
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

