/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.wizards.NewServiceTestClassWizardPage;

public abstract class AbstractSwitchYardServiceWizard
extends BasicNewResourceWizard {
    private NewServiceTestClassWizardPage _newTestClassPage;
    private boolean _initNewTestClassPage = true;
    private Contract _serviceContract;
    private String _serviceName;
    private String _serviceInterfaceType;
    private String _testTypeName;
    private IPackageFragment _testPackageFragment;

    public AbstractSwitchYardServiceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this._newTestClassPage = new NewServiceTestClassWizardPage();
        this._newTestClassPage.init(this.selection);
        this.addPage((IWizardPage)this._newTestClassPage);
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        int count = pages.length - 1;
        while (i < count) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return !this.getCreateTestClass() || this._newTestClassPage.isPageComplete() && this._serviceContract != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage != this._newTestClassPage) {
            return nextPage;
        }
        if (!this.getCreateTestClass()) {
            return null;
        }
        this._serviceContract = this.getServiceContract();
        if (this._initNewTestClassPage || !this._serviceName.equals(this._serviceContract.getName()) || !this._serviceInterfaceType.equals(this.getServiceInterfaceType()) || !this.getJavaProject().equals(this._newTestClassPage.getJavaProject())) {
            this._serviceName = this._serviceContract.getName();
            this._serviceInterfaceType = this.getServiceInterfaceType();
            this._initNewTestClassPage = false;
            IPackageFragment origTestPackageFragment = this._newTestClassPage.getPackageFragment();
            IJavaProject javaProject = this.getJavaProject();
            this._newTestClassPage.init((IStructuredSelection)(javaProject == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)javaProject)));
            this._newTestClassPage.setServiceContract(this._serviceContract, false);
            if (this._testTypeName == null || this._testTypeName.equals(this._newTestClassPage.getTypeName())) {
                this._testTypeName = String.valueOf(this._serviceName) + "Test";
                this._newTestClassPage.setTypeName(this._testTypeName, true);
            }
            if (this._testPackageFragment == null || origTestPackageFragment == null || this._testPackageFragment.equals(origTestPackageFragment)) {
                IPackageFragment packageFragment = this.getPackageFragment();
                if (packageFragment == null) {
                    this._newTestClassPage.setPackageFragment(this._testPackageFragment, this._newTestClassPage.getPackageFragmentRoot() != null);
                } else {
                    this._newTestClassPage.setPackageFragment(packageFragment, this._newTestClassPage.getPackageFragmentRoot() != null);
                }
                this._testPackageFragment = this._newTestClassPage.getPackageFragment();
            }
        }
        return this._newTestClassPage;
    }

    protected NewServiceTestClassWizardPage getNewServiceTestClassWizardPage() {
        return this._newTestClassPage;
    }

    protected abstract Contract getServiceContract();

    protected abstract IJavaProject getJavaProject();

    protected abstract boolean getCreateTestClass();

    private String getServiceInterfaceType() {
        if (this._serviceContract.getInterface() instanceof JavaInterface) {
            return ((JavaInterface)this._serviceContract.getInterface()).getInterface();
        }
        return "";
    }

    private IPackageFragment getPackageFragment() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        Interface intf = this._serviceContract.getInterface();
        if (intf instanceof JavaInterface && ((JavaInterface)intf).getInterface() != null) {
            try {
                IType serviceType = project.findType(((JavaInterface)intf).getInterface());
                return serviceType == null ? null : serviceType.getPackageFragment();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        IJavaElement possiblePackage = JavaUtil.getInitialPackageForProject(project);
        if (possiblePackage.getElementType() == 4) {
            return (IPackageFragment)possiblePackage;
        }
        return null;
    }
}

