/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.switchyard.tools.models.switchyard1_0.switchyard.EsbInterface;

public final class InterfaceOpsUtil {
    private InterfaceOpsUtil() {
    }

    private static String[] getOperationsForWSDLInterface(WSDLPortType intfc) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        final IResource wsdlfile = (IResource)Platform.getAdapterManager().loadAdapter((Object)intfc, IResource.class.getCanonicalName());
        String wsdlToFind = intfc.getInterface();
        String portBreak = "#wsdl.porttype(";
        int portStart = wsdlToFind.indexOf(portBreak) + portBreak.length();
        int portEnd = wsdlToFind.lastIndexOf(41);
        String portTypeStr = wsdlToFind.substring(portStart, portEnd);
        final Definition[] holder = new Definition[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.getResource(URI.createPlatformResourceURI((String)wsdlfile.getFullPath().toString(), (boolean)true), true);
                    holder[0] = resource.getDefinition();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        if (holder != null && holder.length == 1 && holder[0] != null) {
            Definition definition = holder[0];
            Map portTypes = definition.getPortTypes();
            Collection ports = portTypes.values();
            for (PortType portType : ports) {
                if (!portType.getQName().getLocalPart().equals(portTypeStr)) continue;
                List ops = portType.getOperations();
                for (Operation operation : ops) {
                    String opName = operation.getName();
                    list.add(opName);
                }
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] getOperationsForJavaInterface(JavaInterface intfc) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        IResource javafile = (IResource)Platform.getAdapterManager().loadAdapter((Object)intfc, IResource.class.getCanonicalName());
        if (javafile != null && javafile.getProject() != null) {
            IProject project = javafile.getProject();
            String classToFind = intfc.getInterface();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IType findType = javaProject.findType(classToFind);
                if (findType != null) {
                    IMethod[] methods = findType.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        IMethod method = methods[i];
                        list.add(method.getElementName());
                        ++i;
                    }
                }
            }
            catch (JavaModelException e1) {
                e1.fillInStackTrace();
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] gatherOperations(Contract contract) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        Interface intfc = contract.getInterface();
        Service svc = null;
        if (contract instanceof Service) {
            svc = (Service)contract;
        }
        if (intfc == null && svc != null && svc.getPromote() != null) {
            intfc = svc.getPromote().getInterface();
        }
        if (intfc != null && intfc instanceof JavaInterface) {
            JavaInterface javaIntfc = (JavaInterface)intfc;
            String[] ops = InterfaceOpsUtil.getOperationsForJavaInterface(javaIntfc);
            return ops;
        }
        if (intfc != null && intfc instanceof WSDLPortType) {
            WSDLPortType wsdlIntfc = (WSDLPortType)intfc;
            String[] ops = InterfaceOpsUtil.getOperationsForWSDLInterface(wsdlIntfc);
            return ops;
        }
        if (intfc != null && intfc instanceof EsbInterface) {
            String[] ops = new String[]{""};
            return ops;
        }
        return list.toArray(new String[list.size()]);
    }
}

