/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.facets;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.switchyard.tools.ui.M2EUtils;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.facets.ISwitchYardFacetConstants;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardFacetInstallConfigFactory
extends FacetInstallDataModelProvider
implements ISwitchYardFacetConstants {
    private List<ArtifactVersion> _versions;
    private Set<IRuntime> _originalRuntimes;
    private ArtifactVersion _defaultVersion = new DefaultArtifactVersion("2.0.0.Final");
    private ISwitchYardProject _switchYardProject;

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("SwitchYard.RUNTIME_PROVIDED");
        names.add("SwitchYard.RUNTIME_VERSION");
        names.add("SwitchYard.RUNTIME_COMPONENTS");
        names.add("SwitchYard.RUNTIME_TARGET");
        names.add("SwitchYard.SWITCHYARD_PROJECT");
        return names;
    }

    private void projectWorkingCopyUpdated(IFacetedProjectWorkingCopy ifpwc) {
        String versionString;
        try {
            this.loadDefaults(ifpwc);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (this._defaultVersion == null) {
            ListIterator<ArtifactVersion> lit = this._versions.listIterator(this._versions.size());
            while (lit.hasPrevious()) {
                ArtifactVersion version;
                this._defaultVersion = version = lit.previous();
                if (version.toString().endsWith("-SNAPSHOT")) continue;
                this._defaultVersion = version;
                break;
            }
        }
        if (this._switchYardProject != null && (versionString = this._switchYardProject.getVersion()) != null && versionString.length() > 0) {
            this.getDataModel().setProperty("SwitchYard.RUNTIME_VERSION", (Object)new DefaultArtifactVersion(versionString));
            this.getDataModel().setProperty("SwitchYard.RUNTIME_COMPONENTS", this._switchYardProject.getComponents());
        }
        this.getDataModel().setProperty("SwitchYard.SWITCHYARD_PROJECT", (Object)this._switchYardProject);
        if (ifpwc.getPrimaryRuntime() != null) {
            for (IRuntimeComponent component : ifpwc.getPrimaryRuntime().getRuntimeComponents()) {
                if (!"switchyard.runtime".equals(component.getRuntimeComponentType().getId()) && !"fuseServiceWorks.runtime".equals(component.getRuntimeComponentType().getId())) continue;
                this.getDataModel().setProperty("SwitchYard.RUNTIME_TARGET", (Object)component);
                break;
            }
        }
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IFacetDataModelProperties.FACET_ID".equals(propertyName)) {
            return "switchyard.core";
        }
        if ("SwitchYard.RUNTIME_PROVIDED".equals(propertyName)) {
            return true;
        }
        if ("SwitchYard.RUNTIME_VERSION".equals(propertyName)) {
            return this._defaultVersion;
        }
        if ("SwitchYard.RUNTIME_COMPONENTS".equals(propertyName)) {
            return Collections.emptySet();
        }
        if ("SwitchYard.RUNTIME_TARGET".equals(propertyName)) {
            return null;
        }
        if ("SwitchYard.SWITCHYARD_PROJECT".equals(propertyName)) {
            return null;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("SwitchYard.RUNTIME_PROVIDED".equals(propertyName)) {
            return true;
        }
        if ("SwitchYard.RUNTIME_VERSION".equals(propertyName)) {
            return true;
        }
        if ("SwitchYard.RUNTIME_COMPONENTS".equals(propertyName)) {
            return true;
        }
        if ("SwitchYard.SWITCHYARD_PROJECT".equals(propertyName)) {
            return false;
        }
        if ("SwitchYard.RUNTIME_TARGET".equals(propertyName)) {
            IFacetedProjectWorkingCopy ifpwc = (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            if (ifpwc != null) {
                IRuntime primaryRuntime = ifpwc.getPrimaryRuntime();
                if (primaryRuntime != null && !this._originalRuntimes.contains(primaryRuntime)) {
                    ifpwc.removeTargetedRuntime(primaryRuntime);
                }
                if (propertyValue != null) {
                    ifpwc.addTargetedRuntime(((IRuntimeComponent)propertyValue).getRuntime());
                    ifpwc.setPrimaryRuntime(((IRuntimeComponent)propertyValue).getRuntime());
                }
            }
            return true;
        }
        if ("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY".equals(propertyName)) {
            this.projectWorkingCopyUpdated((IFacetedProjectWorkingCopy)propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        if ("SwitchYard.RUNTIME_PROVIDED".equals(name)) {
            return Status.OK_STATUS;
        }
        if ("SwitchYard.RUNTIME_VERSION".equals(name)) {
            Object version = this.getProperty("SwitchYard.RUNTIME_VERSION");
            if (version instanceof ArtifactVersion) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardFacetInstallConfigFactory_statusMessage_MustSpecifySYVersion);
        }
        if ("SwitchYard.RUNTIME_COMPONENTS".equals(name)) {
            return Status.OK_STATUS;
        }
        return super.validate(name);
    }

    private void loadDefaults(IFacetedProjectWorkingCopy ifpwc) throws InvocationTargetException, InterruptedException {
        if (ifpwc != null && ifpwc.getProject() != null && ifpwc.getProject().exists()) {
            this._switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(ifpwc.getProject());
        }
        if (this._switchYardProject != null && this._switchYardProject.needsLoading()) {
            this._switchYardProject.load((IProgressMonitor)new NullProgressMonitor());
            try {
                this._versions = M2EUtils.resolveSwitchYardVersionRange((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                this._versions = new ArrayList<ArtifactVersion>();
            }
        } else {
            try {
                this._versions = M2EUtils.resolveSwitchYardVersionRange((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                this._versions = new ArrayList<ArtifactVersion>();
            }
        }
        this._originalRuntimes = ifpwc.getTargetedRuntimes();
    }
}

