/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateBeanServiceOperation;
import org.switchyard.tools.ui.wizards.AbstractSwitchYardServiceWizard;
import org.switchyard.tools.ui.wizards.NewBeanServiceClassWizardPage;

public class NewBeanServiceWizard
extends AbstractSwitchYardServiceWizard {
    private NewBeanServiceClassWizardPage _newClassPage;
    private ComponentService _serviceInterface;
    private IFile _newClassFile;
    private boolean _updateSwitchYardFile;
    private boolean _openAfterCreate;

    public NewBeanServiceWizard() {
        this(true, true);
    }

    public NewBeanServiceWizard(boolean udpateSwitchYardFile, boolean openAfterCreate) {
        this._updateSwitchYardFile = udpateSwitchYardFile;
        this._openAfterCreate = openAfterCreate;
        this.setNeedsProgressMonitor(true);
    }

    @Override
    public void addPages() {
        this.setWindowTitle(Messages.NewBeanServiceWizard_windowTitle);
        this._newClassPage = new NewBeanServiceClassWizardPage();
        this._newClassPage.init(this.selection);
        if (this._serviceInterface != null) {
            this._newClassPage.forceServiceInterfaceType(this._serviceInterface);
        }
        this.addPage((IWizardPage)this._newClassPage);
        super.addPages();
    }

    public void forceServiceInterfaceType(ComponentService serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public IFile getNewClassFile() {
        return this._newClassFile;
    }

    public IType getNewClass() {
        return this._newClassPage.getCreatedType();
    }

    @Override
    protected Contract getServiceContract() {
        return this._newClassPage.getServiceContract();
    }

    @Override
    protected IJavaProject getJavaProject() {
        return this._newClassPage.getJavaProject();
    }

    @Override
    protected boolean getCreateTestClass() {
        return this._newClassPage.getCreateTestClass();
    }

    public boolean performFinish() {
        IResource testResource;
        final CreateBeanServiceOperation op = new CreateBeanServiceOperation(this._newClassPage, this._newClassPage.getCreateTestClass() ? this.getNewServiceTestClassWizardPage() : null, this._updateSwitchYardFile, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewBeanServiceWizard_logMessage_errorCreatingBeanServiceClass, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewBeanServiceWizard_errorMessage_errorCreatingBeanService, (String)realException.getMessage());
            if (!this._newClassPage.getModifiedResource().exists()) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IResource resource = this._newClassPage.getModifiedResource();
        if (resource instanceof IFile) {
            this._newClassFile = (IFile)resource;
        }
        IResource iResource = testResource = this.getCreateTestClass() ? this.getNewServiceTestClassWizardPage().getModifiedResource() : null;
        if (this._newClassFile != null && this._newClassFile.exists()) {
            this.selectAndReveal((IResource)this._newClassFile);
            if (!this._openAfterCreate) {
                return true;
            }
            final IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IFile)NewBeanServiceWizard.this._newClassFile, (boolean)true);
                            if (testResource instanceof IFile && testResource.exists()) {
                                IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)testResource), (boolean)true);
                            }
                        }
                        catch (PartInitException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewBeanServiceWizard_logMessage_errorOpeningBeanServiceSource, (Throwable)e));
                        }
                    }
                });
            }
        }
        return true;
    }
}

