/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.facets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardRuntimeComponentProvider
extends RuntimeFacetComponentProviderDelegate {
    private static final Pattern DEPLOY_JAR_NAME_PATTERN = Pattern.compile("switchyard-deploy-(jboss-as7|wildfly)-(.*?)\\.jar");
    private static final String SWITCHYARD_AS_DEPLOY_MODULE_PATH = "modules/system/layers/soa/org/switchyard/main";
    private static final String FSW_PRODUCT_MANIFEST_PATH = "modules/system/layers/soa/org/jboss/as/product/soa/dir/META-INF/MANIFEST.MF";
    private static final String FUSE_BUNDLE_INFO_FILE = "bundle.info";
    private static final String FUSE_DATA_DIR = "data";
    private static final String FUSE_DATA_CACHE_DIR = "cache";
    private static final Attributes.Name JBOSS_PRODUCT_RELEASE_NAME = new Attributes.Name("JBoss-Product-Release-Name");
    private static final Attributes.Name JBOSS_PRODUCT_RELEASE_VERSION = new Attributes.Name("JBoss-Product-Release-Version");

    public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        IPath runtimeLocation = runtime.getLocation();
        IRuntimeComponent switchYardRuntime = null;
        SwitchYardRuntimeMetaData switchYardMetaData = null;
        if (runtimeLocation == null) {
            switchYardRuntime = this.getDefaultRuntimeComponent(null);
        } else {
            block27: {
                if (runtime.getRuntimeType().getId().startsWith("org.fusesource.ide")) {
                    switchYardMetaData = this.getSwitchYardVersionFromKarafRuntime(runtimeLocation);
                } else {
                    switchYardMetaData = this.getSwitchYardVersionFromRuntime(runtimeLocation);
                    File productManifest = runtimeLocation.append(FSW_PRODUCT_MANIFEST_PATH).toFile();
                    if (productManifest.exists()) {
                        try {
                            FileInputStream is = new FileInputStream(productManifest);
                            try {
                                try {
                                    String productName;
                                    Manifest manifest = new Manifest(is);
                                    if (manifest.getMainAttributes().containsKey(JBOSS_PRODUCT_RELEASE_NAME) && (productName = (String)String.class.cast(manifest.getMainAttributes().get(JBOSS_PRODUCT_RELEASE_NAME))).matches(".* Fuse Service Works")) {
                                        switchYardMetaData._name = productName;
                                        if (manifest.getMainAttributes().containsKey(JBOSS_PRODUCT_RELEASE_VERSION)) {
                                            switchYardMetaData._runtimeVersion = (String)String.class.cast(manifest.getMainAttributes().get(SwitchYardRuntimeComponentProvider.JBOSS_PRODUCT_RELEASE_VERSION));
                                        }
                                        if (switchYardMetaData._runtimeVersion != null) {
                                            if (switchYardMetaData._runtimeVersion.startsWith("6.0.")) {
                                                switchYardRuntime = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getVersion("6.0"), this.createRuntimeComponentProperties(switchYardMetaData));
                                            } else if (switchYardMetaData._runtimeVersion.startsWith("6.1.")) {
                                                switchYardRuntime = RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getVersion("6.1"), this.createRuntimeComponentProperties(switchYardMetaData));
                                            }
                                        }
                                        if (switchYardRuntime == null) {
                                            switchYardRuntime = this.getDefaultFSWRuntimeComponent(null);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.fillInStackTrace();
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (IOException e2) {
                                        e2.fillInStackTrace();
                                    }
                                    break block27;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException e) {
                                    e.fillInStackTrace();
                                }
                                throw throwable;
                            }
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException e) {
                                e.fillInStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.fillInStackTrace();
                        }
                    }
                }
            }
            if (switchYardRuntime == null && switchYardMetaData != null) {
                switchYardRuntime = switchYardMetaData._runtimeVersion.startsWith("1.0.") || switchYardMetaData._runtimeVersion.startsWith("0.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("1.0"), this.createRuntimeComponentProperties(switchYardMetaData)) : (switchYardMetaData._runtimeVersion.startsWith("1.1.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("1.1"), this.createRuntimeComponentProperties(switchYardMetaData)) : (switchYardMetaData._runtimeVersion.startsWith("2.0.") ? RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getVersion("2.0"), this.createRuntimeComponentProperties(switchYardMetaData)) : this.getDefaultRuntimeComponent(switchYardMetaData)));
            }
        }
        if (switchYardRuntime == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(switchYardRuntime);
    }

    private IRuntimeComponent getDefaultRuntimeComponent(SwitchYardRuntimeMetaData switchYardVersion) {
        try {
            return RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"switchyard.runtime").getLatestVersion(), this.createRuntimeComponentProperties(switchYardVersion));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IRuntimeComponent getDefaultFSWRuntimeComponent(SwitchYardRuntimeMetaData switchYardMetaData) {
        try {
            return RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)RuntimeManager.getRuntimeComponentType((String)"fuseServiceWorks.runtime").getLatestVersion(), this.createRuntimeComponentProperties(switchYardMetaData));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<String, String> createRuntimeComponentProperties(SwitchYardRuntimeMetaData switchYardMetaData) {
        if (switchYardMetaData == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("switchyard.label", switchYardMetaData.createLabel());
        properties.put("switchyard.version", switchYardMetaData._libraryVersion);
        return properties;
    }

    private String readBundleInfoFileForSwitchYardAPIString(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.contains("org.switchyard")) {
                    String string = line;
                    return string;
                }
                line = br.readLine();
            }
            return null;
        }
        finally {
            br.close();
        }
    }

    private File findNamedDir(String name, File dir, int depth) {
        if (name.equals(dir.getName())) {
            return dir;
        }
        if (depth == 0) {
            return null;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                File innerDir;
                if ((innerDir = this.findNamedDir(name, files[i++], depth - 1)) == null) continue;
                return innerDir;
            }
        }
        return null;
    }

    private SwitchYardRuntimeMetaData getSwitchYardVersionFromKarafRuntime(IPath runtimeLocation) {
        File cacheDir;
        File rootDir = runtimeLocation.toFile();
        File dataDir = this.findNamedDir(FUSE_DATA_DIR, rootDir, 2);
        if (dataDir != null && (cacheDir = this.findNamedDir(FUSE_DATA_CACHE_DIR, dataDir, 2)) != null) {
            File[] folders = cacheDir.listFiles();
            if (folders == null || folders.length == 0) {
                return null;
            }
            File[] fileArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                File[] fileList = folder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equalsIgnoreCase(SwitchYardRuntimeComponentProvider.FUSE_BUNDLE_INFO_FILE);
                    }
                });
                if (fileList != null && fileList.length == 1) {
                    try {
                        String[] splitStr;
                        String contents = this.readBundleInfoFileForSwitchYardAPIString(fileList[0]);
                        if (contents != null && (splitStr = contents.split("/")) != null && splitStr.length > 1) {
                            SwitchYardRuntimeMetaData metadata = new SwitchYardRuntimeMetaData();
                            String version = splitStr[splitStr.length - 1];
                            metadata._runtimeVersion = version;
                            metadata._name = "SwitchYard: Karaf Extension";
                            metadata._libraryVersion = version;
                            return metadata;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SwitchYardRuntimeMetaData getSwitchYardVersionFromRuntime(IPath runtimeLocation) {
        File mainDirectory = runtimeLocation.append(SWITCHYARD_AS_DEPLOY_MODULE_PATH).toFile();
        String[] files = mainDirectory.list();
        if (files == null) {
            return null;
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Matcher matcher = DEPLOY_JAR_NAME_PATTERN.matcher(file);
            if (matcher.matches()) {
                try {
                    JarFile runtimeJar = new JarFile(new File(mainDirectory, file));
                    try {
                        Manifest manifest = runtimeJar.getManifest();
                        if (manifest != null) {
                            SwitchYardRuntimeMetaData metadata = new SwitchYardRuntimeMetaData();
                            if (manifest.getMainAttributes().containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
                                metadata._libraryVersion = (String)String.class.cast(manifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_VERSION));
                                metadata._runtimeVersion = metadata._libraryVersion;
                            } else {
                                metadata._libraryVersion = matcher.group(1);
                                metadata._runtimeVersion = metadata._libraryVersion;
                            }
                            metadata._name = (String)String.class.cast(manifest.getMainAttributes().get(Attributes.Name.IMPLEMENTATION_TITLE));
                            SwitchYardRuntimeMetaData switchYardRuntimeMetaData = metadata;
                            return switchYardRuntimeMetaData;
                        }
                    }
                    catch (IOException iOException) {
                        SwitchYardRuntimeMetaData metadata2 = new SwitchYardRuntimeMetaData();
                        metadata2._name = Messages.SwitchYardRuntimeComponentProvider_label_runtimeComponentName;
                        metadata2._libraryVersion = matcher.group(1);
                        metadata2._runtimeVersion = metadata2._libraryVersion;
                        SwitchYardRuntimeMetaData switchYardRuntimeMetaData2 = metadata2;
                        return switchYardRuntimeMetaData2;
                    }
                    finally {
                        try {
                            runtimeJar.close();
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private static final class SwitchYardRuntimeMetaData {
        private String _libraryVersion;
        private String _name;
        private String _runtimeVersion;

        private SwitchYardRuntimeMetaData() {
        }

        private String createLabel() {
            String version = this._runtimeVersion == null || this._runtimeVersion.length() == 0 ? (this._libraryVersion == null || this._libraryVersion.length() == 0 ? null : this._libraryVersion) : this._runtimeVersion;
            return this._name + ' ' + version;
        }
    }
}

