/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.facets;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.osgi.service.prefs.BackingStoreException;
import org.switchyard.tools.ui.common.ISwitchYardProject;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.AbstractSwitchYardProjectOperation;

public class SwitchYardFacetInstallActionDelegate
implements IDelegate {
    public void execute(final IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IDataModel dataModel = (IDataModel)config;
        IFacetedProjectWorkingCopy ifpwc = (IFacetedProjectWorkingCopy)dataModel.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        ISwitchYardProject switchYardProject = (ISwitchYardProject)dataModel.getProperty("SwitchYard.SWITCHYARD_PROJECT");
        if (switchYardProject == null && ifpwc != null) {
            switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(ifpwc.getProject());
        }
        if (switchYardProject == null) {
            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardFacetInstallActionDelegate_exceptionMessage_cannotResolveSYProject));
        }
        Object versionObject = dataModel.getProperty("SwitchYard.RUNTIME_VERSION");
        String versionString = versionObject instanceof ArtifactVersion ? ((ArtifactVersion)versionObject).toString() : null;
        final ISwitchYardProjectWorkingCopy workingCopy = switchYardProject.createWorkingCopy();
        workingCopy.setRuntimeVersion(versionString);
        workingCopy.addComponents((Collection)dataModel.getProperty("SwitchYard.RUNTIME_COMPONENTS"));
        new AbstractSwitchYardProjectOperation(workingCopy, (IFacetedProjectBase)ifpwc, false, Messages.SwitchYardFacetInstallActionDelegate_operationLabel_installingSYFacet, null){

            @Override
            protected void execute(IProgressMonitor monitor) throws CoreException {
                IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().getProject(this.getProject());
                if (projectFacade == null || projectFacade.getMavenProject() == null) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.SwitchYardFacetInstallActionDelegate_errorMessage_notAMavenProject));
                }
                WTPProjectsUtil.removeTestFolderLinks((IProject)this.getProject(), (MavenProject)workingCopy.getMavenProject(), (IProgressMonitor)monitor, (String)"/");
            }

            @Override
            protected IProject getProject() {
                return project;
            }
        }.run(monitor);
        workingCopy.dispose();
        if (this.isOpenShiftProject(project)) {
            this.handleOpenShiftStandaloneUpdates(project);
        }
        IScopeContext[] contexts = this.createPreferenceScopes(null);
        Boolean honorAllSchemaLocationsBoolean = Platform.getPreferencesService().getBoolean(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), "honourAllSchemaLocations", true, contexts);
        if (honorAllSchemaLocationsBoolean.booleanValue()) {
            IEclipsePreferences node = contexts[0].getNode(XMLCorePlugin.getDefault().getBundle().getSymbolicName());
            node.putBoolean("honourAllSchemaLocations", false);
            if (contexts[0] instanceof ProjectScope) {
                node.putBoolean("use-project-settings", true);
            }
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui", e.getLocalizedMessage()));
            }
        }
    }

    protected IScopeContext[] createPreferenceScopes(IProject project) {
        if (project != null) {
            return new IScopeContext[]{new ProjectScope(project), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    private Element createModule(Namespace ns, String identifier, String implClass) {
        Element newModule = new Element("module", ns);
        newModule.setAttribute("identifier", identifier);
        newModule.setAttribute("implClass", implClass);
        return newModule;
    }

    private boolean switchyardExtensionExists(Element extensions) {
        List extensionList = extensions.getChildren("extension", extensions.getNamespace());
        for (Element extension : extensionList) {
            if (extension.getAttribute("module") == null || !extension.getAttributeValue("module").equalsIgnoreCase("org.switchyard")) continue;
            return true;
        }
        return false;
    }

    private boolean switchyardSubsystemExists(Element profile) {
        List subsystemList = profile.getChildren();
        for (Element subsystem : subsystemList) {
            if (subsystem.getNamespace() == null || !subsystem.getNamespace().getURI().equalsIgnoreCase("urn:jboss:domain:switchyard:1.0")) continue;
            return true;
        }
        return false;
    }

    private boolean isOpenShiftProject(IProject project) throws CoreException {
        IFile configFile;
        if (project == null) {
            return false;
        }
        IFolder openshiftFolder = project.getFolder(".openshift");
        return openshiftFolder != null && (configFile = openshiftFolder.getFolder("config").getFile("standalone.xml")) != null;
    }

    private void handleOpenShiftStandaloneUpdates(IProject project) throws CoreException {
        if (project == null) {
            return;
        }
        IFolder openshiftFolder = project.getFolder(".openshift");
        if (openshiftFolder != null) {
            IFile configFile = openshiftFolder.getFolder("config").getFile("standalone.xml");
            SAXBuilder builder = new SAXBuilder();
            File xmlFile = new File(configFile.getLocationURI());
            if (!xmlFile.exists()) {
                return;
            }
            try {
                Element profiles;
                Document doc = builder.build(xmlFile);
                Element rootNode = doc.getRootElement();
                boolean madeChanges = false;
                Element extensions = rootNode.getChild("extensions", rootNode.getNamespace());
                if (extensions != null && !this.switchyardExtensionExists(extensions)) {
                    Element sy_extension = new Element("extension", extensions.getNamespace());
                    sy_extension.setAttribute("module", "org.switchyard");
                    extensions.addContent((Content)sy_extension);
                    madeChanges = true;
                }
                if ((profiles = rootNode.getChild("profile", rootNode.getNamespace())) != null && !this.switchyardSubsystemExists(profiles)) {
                    Namespace syNamespace = Namespace.getNamespace((String)"urn:jboss:domain:switchyard:1.0");
                    Element sySubsystem = new Element("subsystem", syNamespace);
                    Element syModules = new Element("modules", syNamespace);
                    Element beanModule = this.createModule(syNamespace, "org.switchyard.component.bean", "org.switchyard.component.bean.deploy.BeanComponent");
                    syModules.addContent((Content)beanModule);
                    Element soapModule = this.createModule(syNamespace, "org.switchyard.component.soap", "org.switchyard.component.soap.deploy.SOAPComponent");
                    syModules.addContent((Content)soapModule);
                    Element camelModule = this.createModule(syNamespace, "org.switchyard.component.camel.core", "org.switchyard.component.camel.core.deploy.CamelCoreComponent");
                    syModules.addContent((Content)camelModule);
                    Element rulesModule = this.createModule(syNamespace, "org.switchyard.component.rules", "org.switchyard.component.rules.deploy.RulesComponent");
                    syModules.addContent((Content)rulesModule);
                    Element bpmModule = this.createModule(syNamespace, "org.switchyard.component.bpm", "org.switchyard.component.bpm.deploy.BPMComponent");
                    syModules.addContent((Content)bpmModule);
                    Element bpelModule = this.createModule(syNamespace, "org.switchyard.component.bpel", "org.switchyard.component.bpel.deploy.BPELComponent");
                    syModules.addContent((Content)bpelModule);
                    Element restModule = this.createModule(syNamespace, "org.switchyard.component.resteasy", "org.switchyard.component.resteasy.deploy.RESTEasyComponent");
                    syModules.addContent((Content)restModule);
                    Element httpModule = this.createModule(syNamespace, "org.switchyard.component.http", "org.switchyard.component.http.deploy.HttpComponent");
                    syModules.addContent((Content)httpModule);
                    sySubsystem.addContent((Content)syModules);
                    profiles.addContent((Content)sySubsystem);
                    madeChanges = true;
                }
                if (madeChanges) {
                    XMLOutputter xmlOutput = new XMLOutputter();
                    xmlOutput.setFormat(Format.getPrettyFormat());
                    xmlOutput.output(doc, (Writer)new FileWriter(xmlFile.getAbsolutePath()));
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

