/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.common.impl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.common.IInterfaceControlAdapter;
import org.switchyard.tools.ui.common.WSDLPortTypeSelectionDialog;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.wizards.Java2WSDLWizard;
import org.switchyard.tools.ui.wizards.NewWSDLFileWizard;

public class WSDLInterfaceControlAdapter
implements IInterfaceControlAdapter {
    private WSDLPortType _interface = ScaFactory.eINSTANCE.createWSDLPortType();
    private Interface _related;

    @Override
    public Interface getInterface() {
        return this._interface;
    }

    @Override
    public void setRelatedInterface(Interface related) {
        this._related = related;
    }

    @Override
    public void init(Interface intf) {
        String typeString = intf == null ? null : ((WSDLPortType)intf).getInterface();
        this._interface = ScaFactory.eINSTANCE.createWSDLPortType();
        this._interface.setInterface(typeString);
    }

    @Override
    public boolean browse(Shell shell, IJavaElement element) {
        WSDLPortTypeSelectionDialog dialog = new WSDLPortTypeSelectionDialog(shell, (IContainer)(element == null ? ResourcesPlugin.getWorkspace().getRoot() : element.getJavaProject().getProject()));
        dialog.setInitialPattern("*.wsdl");
        if (dialog.open() == 0) {
            PortType result = dialog.getSelectedPortType();
            Object[] selectedFile = dialog.getResult();
            if (result != null) {
                IFile wsdlFile = null;
                if (selectedFile != null && selectedFile.length > 0) {
                    wsdlFile = (IFile)selectedFile[0];
                }
                this._interface.setInterface(this.getInterfaceURL(element, result, wsdlFile));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean open(Shell shell, IJavaProject project, boolean useRelated) {
        if (useRelated && this._related instanceof JavaInterface) {
            return this.openJava2WSDLWizard(shell, project);
        }
        return this.openNewWSDLFileWizard(shell, project);
    }

    private boolean openNewWSDLFileWizard(Shell shell, IJavaProject project) {
        IResource container = JavaUtil.getFirstResourceRoot(project);
        StructuredSelection selectionToPass = container == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)container);
        NewWSDLFileWizard newWizard = new NewWSDLFileWizard();
        newWizard.setOpenOnFinish(false);
        newWizard.setStartingFileName("MyService.wsdl");
        newWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selectionToPass);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)newWizard);
        if (dialog.open() == 0) {
            return this.updateInterfaceFromNewFile(newWizard.getNewFile(), project);
        }
        return false;
    }

    private boolean openJava2WSDLWizard(Shell shell, IJavaProject project) {
        Java2WSDLWizard newWizard = new Java2WSDLWizard();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)newWizard);
        newWizard.init(PlatformUI.getWorkbench(), this.getResourceForInterface((JavaInterface)this._related));
        if (dialog.open() == 0 && newWizard.getWSDLFile() != null && newWizard.getWSDLFile().exists()) {
            return this.updateInterfaceFromNewFile(newWizard.getWSDLFile(), project);
        }
        return false;
    }

    private IStructuredSelection getResourceForInterface(JavaInterface javaIntf) {
        IResource file = (IResource)Platform.getAdapterManager().loadAdapter((Object)javaIntf, IResource.class.getCanonicalName());
        if (file == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)file);
    }

    private boolean updateInterfaceFromNewFile(IFile newFile, IJavaProject project) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        WSDLResourceImpl resource = (WSDLResourceImpl)resourceSet.getResource(URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true), true);
        Definition definition = resource.getDefinition();
        EList portTypes = definition.getEPortTypes();
        if (portTypes.size() > 0) {
            this._interface.setInterface(this.getInterfaceURL((IJavaElement)project, (PortType)portTypes.get(0), newFile));
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this._interface.getInterface() == null) {
            return "";
        }
        return this._interface.getInterface();
    }

    @Override
    public IStatus validate(IJavaProject project) {
        if (this._interface.getInterface() == null) {
            return new Status(4, "org.switchyard.tools.ui", Messages.WSDLInterfaceControlAdapter_statusMessage_selectPortType);
        }
        IResource wsdlResource = SwitchYardModelUtils.getJavaResource(project == null ? null : project.getProject(), this._interface.getInterface());
        if (wsdlResource == null) {
            return new Status(2, "org.switchyard.tools.ui", Messages.WSDLInterfaceControlAdapter_statusMessage_selectedWSDLNotOnClasspath);
        }
        return Status.OK_STATUS;
    }

    private String getInterfaceURL(IJavaElement element, PortType portType, Object selectedFile) {
        IFile resource = (IFile)selectedFile;
        IPath filePath = JavaUtil.getJavaPathForResource((IResource)resource);
        return String.valueOf(filePath.toString()) + "#wsdl.porttype(" + portType.getQName().getLocalPart() + ")";
    }
}

