/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.cxf;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.OperationProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.PortTypeProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.switchyard.tools.cxf.Messages;

public class SwitchYardWSDLToJavaProcessor
extends WSDLToJavaProcessor {
    public void process() {
        ServiceInfo serviceInfo = (ServiceInfo)this.context.get(ServiceInfo.class);
        InterfaceInfo interfaceInfo = serviceInfo.getInterface();
        if (interfaceInfo == null) {
            return;
        }
        HashMap<QName, Boolean> seenOperations = new HashMap<QName, Boolean>();
        JavaModel javaModel = null;
        LinkedHashMap<QName, JavaModel> map = (LinkedHashMap<QName, JavaModel>)this.context.get(MODEL_MAP);
        if (map == null) {
            map = new LinkedHashMap<QName, JavaModel>();
            this.context.put(MODEL_MAP, map);
        }
        if (map.containsKey(serviceInfo.getName())) {
            javaModel = (JavaModel)map.get(serviceInfo.getName());
        } else {
            javaModel = new JavaModel();
            map.put(serviceInfo.getName(), javaModel);
        }
        JavaInterface intf = PortTypeProcessor.getInterface((ToolContext)this.context, (ServiceInfo)serviceInfo, (InterfaceInfo)interfaceInfo);
        intf.setJavaModel(javaModel);
        Collection operations = interfaceInfo.getOperations();
        for (OperationInfo operation : operations) {
            JavaInterface dummyInterface = new JavaInterface();
            if (seenOperations.put(operation.getName(), Boolean.TRUE) != null) {
                LOG.log(Level.WARNING, Messages.SwitchYardWSDLToJavaProcessor_warning_SkipOverloadedOperation, operation.getName());
                continue;
            }
            OperationProcessor operationProcessor = new OperationProcessor(this.context);
            dummyInterface.setPackageName(intf.getPackageName());
            dummyInterface.setJavaModel(javaModel);
            operationProcessor.process(dummyInterface, operation);
            String trueMethodName = operation.getName().getLocalPart();
            for (JavaMethod method : dummyInterface.getMethods()) {
                int length = ProcessorUtil.mangleNameToVariableName((String)trueMethodName).length();
                method.setName(String.valueOf(trueMethodName) + method.getName().substring(length));
                method.setInterface(intf);
                intf.addMethod(method);
            }
        }
        javaModel.addInterface(intf.getName(), intf);
        this.context.setJavaModel(javaModel);
    }
}

