/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.wizards;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.catalog.Dependency;
import org.jboss.tools.fuse.transformation.camel.CamelConfigBuilder;
import org.jboss.tools.fuse.transformation.camel.CamelEndpoint;
import org.jboss.tools.fuse.transformation.dozer.DozerMapperConfiguration;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.JSONPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.JavaPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.OtherPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.StartPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XMLPage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;
import org.jboss.tools.fuse.transformation.model.json.JsonModelGenerator;
import org.jboss.tools.fuse.transformation.model.xml.XmlModelGenerator;

public class NewTransformationWizard
extends Wizard
implements INewWizard {
    private static final String JAVA_PATH = "src/main/java/";
    public static final String CAMEL_CONFIG_PATH = "src/main/resources/META-INF/spring/camel-context.xml";
    private static final String OBJECT_FACTORY_NAME = "ObjectFactory";
    private Model uiModel = new Model();
    private DataFormatDefinition sourceFormat;
    private DataFormatDefinition targetFormat;
    private CamelEndpoint endpoint;
    private boolean saveCamelConfig = true;
    private Endpoint routeEndpoint;
    public StartPage start;
    public JavaPage javaSource;
    public JavaPage javaTarget;
    public XMLPage xmlSource;
    public XMLPage xmlTarget;
    public JSONPage jsonSource;
    public JSONPage jsonTarget;
    public OtherPage otherSource;
    public OtherPage otherTarget;
    public URLClassLoader loader;

    public boolean performFinish() {
        final IFile file = this.uiModel.getProject().getFile("src/main/resources/" + this.uiModel.getFilePath());
        if (file.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)"Confirm", (String)("Overwrite existing transformation file (\"" + file.getFullPath() + "\")?"))) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                DozerMapperConfiguration dozerConfigBuilder = DozerMapperConfiguration.newConfig();
                File newFile = new File(file.getLocationURI());
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (FileOutputStream configStream = new FileOutputStream(newFile);){
                        if (NewTransformationWizard.this.uiModel.getSourceFilePath() != null) {
                            String sourceClassName = NewTransformationWizard.this.generateModel(NewTransformationWizard.this.uiModel.getSourceFilePath(), NewTransformationWizard.this.uiModel.getSourceType(), true);
                            String targetClassName = NewTransformationWizard.this.generateModel(NewTransformationWizard.this.uiModel.getTargetFilePath(), NewTransformationWizard.this.uiModel.getTargetType(), false);
                            IPath resourcesPath = NewTransformationWizard.this.uiModel.getProject().getFolder("src/main/resources/").getFullPath();
                            CamelConfigBuilder configBuilder = ((NewTransformationWizard)NewTransformationWizard.this).uiModel.camelConfig.getConfigBuilder();
                            if (ModelType.OTHER.equals((Object)NewTransformationWizard.this.uiModel.getSourceType())) {
                                NewTransformationWizard.this.sourceFormat = configBuilder.getDataFormat(NewTransformationWizard.this.uiModel.getSourceDataFormatid());
                            } else {
                                NewTransformationWizard.this.sourceFormat = configBuilder.createDataFormat(((NewTransformationWizard)NewTransformationWizard.this).uiModel.getSourceType().transformType, sourceClassName, CamelConfigBuilder.MarshalType.UNMARSHALLER);
                            }
                            if (ModelType.OTHER.equals((Object)NewTransformationWizard.this.uiModel.getTargetType())) {
                                NewTransformationWizard.this.targetFormat = configBuilder.getDataFormat(NewTransformationWizard.this.uiModel.getTargetDataFormatid());
                            } else {
                                NewTransformationWizard.this.targetFormat = configBuilder.createDataFormat(((NewTransformationWizard)NewTransformationWizard.this).uiModel.getTargetType().transformType, targetClassName, CamelConfigBuilder.MarshalType.MARSHALLER);
                            }
                            NewTransformationWizard.this.endpoint = configBuilder.createEndpoint(NewTransformationWizard.this.uiModel.getId(), file.getFullPath().makeRelativeTo(resourcesPath).toString(), sourceClassName, targetClassName, NewTransformationWizard.this.sourceFormat, NewTransformationWizard.this.targetFormat);
                            NewTransformationWizard.this.addCamelDozerDependency();
                            NewTransformationWizard.this.addDataFormatDefinitionDependency(NewTransformationWizard.this.sourceFormat);
                            NewTransformationWizard.this.addDataFormatDefinitionDependency(NewTransformationWizard.this.targetFormat);
                            if (NewTransformationWizard.this.saveCamelConfig) {
                                File camelFile = new File(NewTransformationWizard.this.uiModel.getProject().getFile("src/main/resources/" + NewTransformationWizard.this.uiModel.getCamelFilePath()).getLocationURI());
                                ((NewTransformationWizard)NewTransformationWizard.this).uiModel.camelConfig.save(camelFile);
                            }
                            dozerConfigBuilder.addClassMapping(sourceClassName, targetClassName);
                        }
                        dozerConfigBuilder.saveConfig((OutputStream)configStream);
                        if (!NewTransformationWizard.this.saveCamelConfig) {
                            RouteContainer routeContainer = org.fusesource.ide.camel.editor.Activator.getDiagramEditor().getModel();
                            CamelContextFactoryBean camelContext = routeContainer.getModel().getContextElement();
                            NewTransformationWizard.this.addCamelContextEndpoint(camelContext, NewTransformationWizard.this.endpoint.asSpringEndpoint());
                            if (NewTransformationWizard.this.sourceFormat != null) {
                                NewTransformationWizard.this.addDataFormat(camelContext, NewTransformationWizard.this.sourceFormat);
                            }
                            if (NewTransformationWizard.this.targetFormat != null) {
                                NewTransformationWizard.this.addDataFormat(camelContext, NewTransformationWizard.this.targetFormat);
                            }
                            NewTransformationWizard.this.routeEndpoint = new Endpoint("ref:" + NewTransformationWizard.this.endpoint.getId());
                        }
                        NewTransformationWizard.this.uiModel.getProject().refreshLocal(2, null);
                        try {
                            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                        }
                        catch (InterruptedException interruptedException) {}
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getEditors(file.getName(), Platform.getContentTypeManager().getContentType("org.jboss.tools.fuse.transformation.editor.dozer-config-content-type"))[0];
                        NewTransformationWizard.this.uiModel.getProject().refreshLocal(2, null);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.fillInStackTrace();
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return false;
    }

    public Endpoint getRouteEndpoint() {
        return this.routeEndpoint;
    }

    public void addPages() {
        if (this.start == null) {
            this.start = new StartPage(this.uiModel);
        }
        this.addPage((IWizardPage)this.start);
        if (this.javaSource == null) {
            this.javaSource = new JavaPage("SourceJava", this.uiModel, true);
        }
        this.addPage((IWizardPage)this.javaSource);
        if (this.javaTarget == null) {
            this.javaTarget = new JavaPage("TargetJava", this.uiModel, false);
        }
        this.addPage((IWizardPage)this.javaTarget);
        if (this.xmlSource == null) {
            this.xmlSource = new XMLPage("SourceXml", this.uiModel, true);
        }
        this.addPage((IWizardPage)this.xmlSource);
        if (this.xmlTarget == null) {
            this.xmlTarget = new XMLPage("TargetXml", this.uiModel, false);
        }
        this.addPage((IWizardPage)this.xmlTarget);
        if (this.jsonSource == null) {
            this.jsonSource = new JSONPage("Sourcejson", this.uiModel, true);
        }
        this.addPage((IWizardPage)this.jsonSource);
        if (this.jsonTarget == null) {
            this.jsonTarget = new JSONPage("Targetjson", this.uiModel, false);
        }
        this.addPage((IWizardPage)this.jsonTarget);
        if (this.otherSource == null) {
            this.otherSource = new OtherPage("Sourceother", this.uiModel, true);
        }
        this.addPage((IWizardPage)this.otherSource);
        if (this.otherTarget == null) {
            this.otherTarget = new OtherPage("Targetother", this.uiModel, false);
        }
        this.addPage((IWizardPage)this.otherTarget);
    }

    public String getWindowTitle() {
        return "New Fuse Transformation";
    }

    public void setSelectedProject(IProject project) {
        this.uiModel.setProject(project);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            this.loader = (URLClassLoader)JavaUtil.getProjectClassLoader(javaProject, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public URLClassLoader getLoader() {
        if (this.loader == null && this.uiModel.getProject() != null) {
            this.setSelectedProject(this.uiModel.getProject());
        }
        return this.loader;
    }

    public void setCamelFilePath(String path) {
        this.uiModel.setCamelFilePath(path);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Iterator<IProject> iter = this.uiModel.projects.iterator();
        while (iter.hasNext()) {
            if (iter.next().findMember(CAMEL_CONFIG_PATH) != null) continue;
            iter.remove();
        }
        if (this.uiModel.projects.size() == 1) {
            this.uiModel.setProject(this.uiModel.projects.get(0));
        } else {
            IStructuredSelection resourceSelection = (IStructuredSelection)workbench.getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.ui.navigator.ProjectExplorer");
            if (resourceSelection == null || resourceSelection.size() != 1) {
                return;
            }
            IProject project = ((IResource)((IAdaptable)resourceSelection.getFirstElement()).getAdapter(IResource.class)).getProject();
            if (this.uiModel.projects.contains(project)) {
                this.uiModel.setProject(project);
            }
        }
    }

    private void resetPage(IWizardPage page) {
        if (page != null && page instanceof XformWizardPage) {
            ((XformWizardPage)page).resetFinish();
        }
    }

    public void resetSourceAndTargetPages() {
        this.resetPage((IWizardPage)this.javaSource);
        this.resetPage((IWizardPage)this.javaTarget);
        this.resetPage((IWizardPage)this.xmlSource);
        this.resetPage((IWizardPage)this.xmlTarget);
        this.resetPage((IWizardPage)this.jsonSource);
        this.resetPage((IWizardPage)this.jsonTarget);
        this.resetPage((IWizardPage)this.otherSource);
        this.resetPage((IWizardPage)this.otherTarget);
    }

    public boolean canFinish() {
        if (this.start != null && this.start.getSourcePage() != null && this.start.getTargetPage() != null) {
            ((XformWizardPage)this.start.getSourcePage()).notifyListeners();
            ((XformWizardPage)this.start.getTargetPage()).notifyListeners();
            if (this.start.isPageComplete() && this.start.getSourcePage().isPageComplete() && this.start.getTargetPage().isPageComplete()) {
                return true;
            }
        } else {
            return false;
        }
        return super.canFinish();
    }

    private String generateModel(String filePath, ModelType type, boolean isSource) throws Exception {
        StringBuilder className = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(filePath.substring(filePath.lastIndexOf(47) + 1, filePath.lastIndexOf(46)));
        boolean wordStart = true;
        char chr = iter.first();
        while (chr != '\uffff') {
            if (className.length() == 0) {
                if (Character.isJavaIdentifierStart(chr)) {
                    className.append(wordStart ? Character.toUpperCase(chr) : chr);
                    wordStart = false;
                }
            } else if (Character.isJavaIdentifierPart(chr)) {
                className.append(wordStart ? Character.toUpperCase(chr) : chr);
                wordStart = false;
            } else {
                wordStart = true;
            }
            chr = iter.next();
        }
        int sequencer = 1;
        String pkgName = className.toString();
        while (this.uiModel.getProject().exists((IPath)new Path(JAVA_PATH + pkgName))) {
            pkgName = String.valueOf(className.toString()) + sequencer++;
        }
        pkgName = pkgName.toLowerCase();
        File targetClassesFolder = new File(this.uiModel.getProject().getFolder(JAVA_PATH).getLocationURI());
        switch (type) {
            case CLASS: 
            case OTHER: {
                IJavaProject javaProject = JavaCore.create((IProject)this.uiModel.getProject());
                IType pkg = javaProject.findType(filePath, (IProgressMonitor)new NullProgressMonitor());
                if (pkg != null) {
                    return pkg.getFullyQualifiedName();
                }
                return null;
            }
            case JAVA: {
                IJavaProject javaProject = JavaCore.create((IProject)this.uiModel.getProject());
                IType pkg = javaProject.findType(filePath, (IProgressMonitor)new NullProgressMonitor());
                if (pkg != null) {
                    return pkg.getFullyQualifiedName();
                }
                return null;
            }
            case JSON: {
                JsonModelGenerator generator = new JsonModelGenerator();
                generator.generateFromInstance(className.toString(), pkgName, this.uiModel.getProject().findMember(filePath).getLocationURI().toURL(), targetClassesFolder);
                return String.valueOf(pkgName) + "." + className;
            }
            case JSON_SCHEMA: {
                JsonModelGenerator generator = new JsonModelGenerator();
                generator.generateFromSchema(className.toString(), pkgName, this.uiModel.getProject().findMember(filePath).getLocationURI().toURL(), targetClassesFolder);
                return String.valueOf(pkgName) + "." + className;
            }
            case XSD: {
                XmlModelGenerator generator = new XmlModelGenerator();
                File schemaFile = new File(this.uiModel.getProject().findMember(filePath).getLocationURI());
                JCodeModel model = generator.generateFromSchema(schemaFile, pkgName, targetClassesFolder);
                String elementName = null;
                elementName = isSource ? this.uiModel.getSourceClassName() : this.uiModel.getTargetClassName();
                String modelClass = null;
                Map mappings = generator.elementToClassMapping(model);
                modelClass = mappings != null && !mappings.isEmpty() ? (String)mappings.get(elementName) : this.selectModelClass(model);
                if (modelClass != null) {
                    return modelClass;
                }
                return null;
            }
            case XML: {
                XmlModelGenerator generator = new XmlModelGenerator();
                File schemaPath = new File(this.uiModel.getProject().getFile(String.valueOf(filePath) + ".xsd").getLocationURI());
                JCodeModel model = generator.generateFromInstance(new File(this.uiModel.getProject().findMember(filePath).getLocationURI()), schemaPath, pkgName, targetClassesFolder);
                String elementName = null;
                elementName = isSource ? this.uiModel.getSourceClassName() : this.uiModel.getTargetClassName();
                String modelClass = null;
                Map mappings = generator.elementToClassMapping(model);
                modelClass = mappings != null && !mappings.isEmpty() ? (String)mappings.get(elementName) : this.selectModelClass(model);
                if (modelClass != null) {
                    return modelClass;
                }
                return null;
            }
        }
        return null;
    }

    private String selectModelClass(JCodeModel model) {
        Iterator pkgIter = model.packages();
        while (pkgIter.hasNext()) {
            JPackage pkg = (JPackage)pkgIter.next();
            Iterator classIter = pkg.classes();
            while (classIter.hasNext()) {
                JDefinedClass definedClass = (JDefinedClass)classIter.next();
                if (OBJECT_FACTORY_NAME.equals(definedClass.name())) continue;
                return definedClass.fullName();
            }
        }
        return null;
    }

    public void setSaveCamelConfig(boolean saveCamelConfig) {
        this.saveCamelConfig = saveCamelConfig;
    }

    public DataFormatDefinition getSourceFormat() {
        return this.sourceFormat;
    }

    public DataFormatDefinition getTargetFormat() {
        return this.targetFormat;
    }

    public CamelEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Model getModel() {
        return this.uiModel;
    }

    private void addCamelContextEndpoint(CamelContextFactoryBean context, CamelEndpointFactoryBean endpoint) {
        LinkedList<CamelEndpointFactoryBean> endpoints = context.getEndpoints();
        if (endpoints == null) {
            endpoints = new LinkedList<CamelEndpointFactoryBean>();
        }
        endpoints.add(endpoint);
        context.setEndpoints(endpoints);
    }

    private void addDataFormat(CamelContextFactoryBean context, DataFormatDefinition dataFormat) {
        DataFormatsDefinition dataFormats = context.getDataFormats();
        if (dataFormats == null) {
            dataFormats = new DataFormatsDefinition();
        }
        if (dataFormats.getDataFormats() == null) {
            dataFormats.setDataFormats(new LinkedList());
        }
        boolean exists = false;
        for (DataFormatDefinition dfd : dataFormats.getDataFormats()) {
            if (!dataFormat.getId().equals(dfd.getId())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            dataFormats.getDataFormats().add(dataFormat);
            context.setDataFormats(dataFormats);
        }
    }

    private Dependency createDependency(String groupId, String artifactId, String version) {
        Dependency dep = new Dependency();
        dep.setGroupId(groupId);
        dep.setArtifactId(artifactId);
        dep.setVersion(version);
        return dep;
    }

    private void addCamelDozerDependency() {
        Dependency dep = this.createDependency("org.apache.camel", "camel-dozer", org.fusesource.ide.camel.editor.Activator.getDefault().getCamelVersion());
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        deps.add(dep);
        try {
            Util.updateMavenDependencies(deps, this.uiModel.getProject());
        }
        catch (CoreException e) {
            org.fusesource.ide.camel.editor.Activator.getLogger().error((Throwable)e);
        }
    }

    private void addDataFormatDefinitionDependency(DataFormatDefinition dataFormat) {
        Dependency dep = null;
        if (dataFormat != null) {
            if (dataFormat.getDataFormatName().equalsIgnoreCase("json-jackson")) {
                dep = this.createDependency("org.apache.camel", "camel-jackson", org.fusesource.ide.camel.editor.Activator.getDefault().getCamelVersion());
            } else if (dataFormat.getDataFormatName().equalsIgnoreCase("jaxb")) {
                dep = this.createDependency("org.apache.camel", "camel-jaxb", org.fusesource.ide.camel.editor.Activator.getDefault().getCamelVersion());
            }
            if (dep != null) {
                ArrayList<Dependency> deps = new ArrayList<Dependency>();
                deps.add(dep);
                try {
                    Util.updateMavenDependencies(deps, this.uiModel.getProject());
                }
                catch (CoreException e) {
                    org.fusesource.ide.camel.editor.Activator.getLogger().error((Throwable)e);
                }
            }
        }
    }
}

