/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.util.List;
import org.apache.camel.model.DataFormatDefinition;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.ModelViewer;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.TransformationTypePage;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;
import org.jboss.tools.fuse.transformation.editor.wizards.NewTransformationWizard;
import org.jboss.tools.fuse.transformation.model.ModelBuilder;

public class OtherPage
extends XformWizardPage
implements TransformationTypePage {
    private Composite _page;
    private boolean isSource = true;
    private Text _javaClassText;
    private ComboViewer _dataFormatIdCombo;
    private ModelBuilder _builder;
    private org.jboss.tools.fuse.transformation.model.Model _javaModel = null;
    private ModelViewer _modelViewer;
    private Label _dfErrorLabel;
    private Binding _binding;
    private Binding _binding2;

    public OtherPage(String pageName, Model model, boolean isSource) {
        super(pageName, model);
        this.setTitle("Other Page");
        this.setImageDescriptor(Activator.imageDescriptor("transform.png"));
        this.isSource = isSource;
        this.observablesManager.addObservablesFromContext(this.context, true, true);
        this._builder = new ModelBuilder();
    }

    @Override
    public void createControl(final Composite parent) {
        if (this.isSource) {
            this.setTitle("Source Type (Other)");
            this.setDescription("Specify details for the source data format and Java class for this transformation.");
        } else {
            this.setTitle("Target Type (Other)");
            this.setDescription("Specify details for the target data format and Java class for this transformation.");
        }
        this.observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                OtherPage.this.createPage(parent);
            }
        });
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void createPage(Composite parent) {
        this._page = new Composite(parent, 0);
        this.setControl((Control)this._page);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.horizontalSpacing = 10;
        this._page.setLayout((Layout)layout);
        Label label = this.isSourcePage() ? this.createLabel(this._page, "Source Class:", "The source Java class for the transformation.") : this.createLabel(this._page, "Target Class:", "The target Java class for the transformation.");
        this._javaClassText = new Text(this._page, 2048);
        this._javaClassText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._javaClassText.setToolTipText(label.getToolTipText());
        Button javaClassBrowseButton = new Button(this._page, 0);
        javaClassBrowseButton.setLayoutData((Object)new GridData());
        javaClassBrowseButton.setText("...");
        javaClassBrowseButton.setToolTipText("Browse to specify the selected class.");
        javaClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    final IType selected = OtherPage.this.selectType(OtherPage.this._page.getShell(), "java.lang.Object", null);
                    if (selected != null) {
                        OtherPage.this._javaClassText.setText(selected.getFullyQualifiedName());
                        if (OtherPage.this.isSourcePage()) {
                            OtherPage.this.model.setSourceType(ModelType.OTHER);
                            OtherPage.this.model.setSourceFilePath(selected.getFullyQualifiedName());
                        } else {
                            OtherPage.this.model.setTargetType(ModelType.OTHER);
                            OtherPage.this.model.setTargetFilePath(selected.getFullyQualifiedName());
                        }
                        UIJob uiJob = new UIJob("open error"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                NewTransformationWizard wizard = (NewTransformationWizard)OtherPage.this.getWizard();
                                try {
                                    Class<?> tempClass = wizard.getLoader().loadClass(selected.getFullyQualifiedName());
                                    OtherPage.this._javaModel = ModelBuilder.fromJavaClass(tempClass);
                                    OtherPage.this._modelViewer.setModel(OtherPage.this._javaModel);
                                }
                                catch (ClassNotFoundException e) {
                                    e.printStackTrace();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        uiJob.setSystem(true);
                        uiJob.schedule();
                        OtherPage.this._javaClassText.notifyListeners(24, new Event());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        label = this.createLabel(this._page, "Data Format ID:", "Unique ID for the data format.");
        this._dataFormatIdCombo = new ComboViewer(this._page, 12);
        this._dataFormatIdCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._dataFormatIdCombo.getCombo().setToolTipText(label.getToolTipText());
        this._dataFormatIdCombo.setContentProvider((IContentProvider)new ObservableListContentProvider());
        label = this.createLabel(this._page, "", "");
        this._dfErrorLabel = this.createLabel(this._page, "", "");
        this._dfErrorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group group = new Group(this._page, 16);
        group.setText("Class Structure Preview");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 3, 3));
        this._modelViewer = new ModelViewer(null, (Composite)group, this._javaModel, null);
        this._modelViewer.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this._modelViewer.layout();
        this.bindControls();
        this.validatePage();
    }

    private void bindControls() {
        ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe((Widget)this._javaClassText);
        IObservableValue modelValue = null;
        modelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceFilePath").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetFilePath").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String path = value == null ? null : value.toString().trim();
                String pathEmptyError = null;
                String unableToFindError = null;
                if (OtherPage.this.isSourcePage()) {
                    pathEmptyError = "A source file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a source file with the supplied path";
                } else {
                    pathEmptyError = "A target file path must be supplied for the transformation.";
                    unableToFindError = "Unable to find a target file with the supplied path";
                }
                if (path == null || path.isEmpty()) {
                    return ValidationStatus.error((String)pathEmptyError);
                }
                if (OtherPage.this.model.getProject().findMember(path) == null) {
                    return ValidationStatus.error((String)unableToFindError);
                }
                return ValidationStatus.ok();
            }
        });
        this._binding = this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding, (int)this.decoratorPosition, (Composite)this._javaClassText.getParent());
        this.listenForValidationChanges();
    }

    public void initialize() {
        IViewerObservableValue widgetValue = ViewerProperties.singleSelection().observe((Viewer)this._dataFormatIdCombo);
        IObservableValue modelValue = null;
        WritableList dfList = new WritableList();
        List dataFormats = this.getModel().camelConfig.getConfigBuilder().getDataFormats();
        for (DataFormatDefinition df : dataFormats) {
            if (df.getId() == null) continue;
            dfList.add((Object)df.getId());
        }
        if (dfList.isEmpty()) {
            this._dfErrorLabel.setText("No available data format definitions in the selected Camel configuration.");
            this._dfErrorLabel.setForeground(Display.getCurrent().getSystemColor(3));
            this._dataFormatIdCombo.getCombo().setEnabled(false);
        } else {
            this._dfErrorLabel.setText("");
            this._dataFormatIdCombo.getCombo().setEnabled(true);
        }
        this._dataFormatIdCombo.setInput((Object)dfList);
        modelValue = this.isSourcePage() ? BeanProperties.value(Model.class, (String)"sourceDataFormatid").observe((Object)this.model) : BeanProperties.value(Model.class, (String)"targetDataFormatid").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String path;
                String string = path = value == null ? null : value.toString().trim();
                if (path == null || path.isEmpty()) {
                    return ValidationStatus.error((String)"A data format id must be supplied for the transformation.");
                }
                return ValidationStatus.ok();
            }
        });
        this._binding2 = this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)this._binding2, (int)this.decoratorPosition, (Composite)this._javaClassText.getParent());
    }

    @Override
    public boolean isSourcePage() {
        return this.isSource;
    }

    @Override
    public boolean isTargetPage() {
        return !this.isSource;
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            IJavaProject javaProject;
            IType superType;
            if (project == null) {
                project = this.model.getProject();
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle("Select Class");
        dialog.setMessage("Matching items");
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    @Override
    public void notifyListeners() {
        if (this._javaClassText != null && !this._javaClassText.isDisposed()) {
            this._javaClassText.notifyListeners(24, new Event());
        }
    }

    @Override
    public void clearControls() {
        if (this._javaClassText != null && !this._javaClassText.isDisposed()) {
            this._javaModel = new org.jboss.tools.fuse.transformation.model.Model("", "");
            this._modelViewer.setModel(this._javaModel);
            this._javaClassText.setText("");
        }
        this.notifyListeners();
    }

    @Override
    public void pingBinding() {
        if (this._binding != null) {
            this._binding.validateTargetToModel();
        }
        if (this._binding2 != null) {
            this._binding2.validateTargetToModel();
        }
    }

    @Override
    public void resetFinish() {
        super.resetFinish();
    }

    static /* synthetic */ ModelBuilder access$3(OtherPage otherPage) {
        return otherPage._builder;
    }
}

