/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.fuse.transformation.CustomMapping;
import org.jboss.tools.fuse.transformation.Expression;
import org.jboss.tools.fuse.transformation.ExpressionMapping;
import org.jboss.tools.fuse.transformation.FieldMapping;
import org.jboss.tools.fuse.transformation.MapperConfiguration;
import org.jboss.tools.fuse.transformation.MappingOperation;
import org.jboss.tools.fuse.transformation.MappingType;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.VariableMapping;
import org.jboss.tools.fuse.transformation.dozer.DozerMapperConfiguration;
import org.jboss.tools.fuse.transformation.editor.internal.util.ExpressionPlaceholder;
import org.jboss.tools.fuse.transformation.editor.internal.util.MappingPlaceholder;
import org.jboss.tools.fuse.transformation.model.Model;

public class TransformationConfig
implements MapperConfiguration {
    public static final String MAPPING = "mapping";
    public static final String MAPPING_CUSTOMIZE = "mappingCustomize";
    public static final String MAPPING_SOURCE = "mappingSource";
    public static final String MAPPING_TARGET = "mappingTarget";
    public static final String VARIABLE = "variable";
    public static final String VARIABLE_NAME = "variableName";
    public static final String VARIABLE_VALUE = "variableValue";
    private final IFile file;
    private final MapperConfiguration delegate;
    private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private final List<MappingPlaceholder> mappingPlaceholders = new ArrayList<MappingPlaceholder>();

    public TransformationConfig(IFile file, URLClassLoader loader) throws Exception {
        this.file = file;
        this.delegate = DozerMapperConfiguration.loadConfig((File)new File(file.getLocationURI()), (ClassLoader)loader);
    }

    public void addClassMapping(String fromClass, String toClass) {
        throw new UnsupportedOperationException();
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public Variable addVariable(String name, String value) {
        Variable variable = this.delegate.addVariable(name, value);
        this.fireEvent(VARIABLE, null, variable);
        return variable;
    }

    public CustomMapping customizeMapping(FieldMapping mapping, String mappingClass) {
        throw new UnsupportedOperationException();
    }

    public CustomMapping customizeMapping(FieldMapping fieldMapping, String mappingClass, String mappingOperation) {
        CustomMapping customMapping = this.delegate.customizeMapping(fieldMapping, mappingClass, mappingOperation);
        this.fireEvent(MAPPING_CUSTOMIZE, fieldMapping, customMapping);
        return customMapping;
    }

    Model find(Object object, Model model) {
        if (model.equals(object)) {
            return model;
        }
        for (Model child : model.getChildren()) {
            Model match = this.find(object, child);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private void fireEvent(String eventType, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, eventType, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public String fullyQualifiedName(Model model) {
        return this.fullyQualifiedName(model, new StringBuilder());
    }

    private String fullyQualifiedName(Model model, StringBuilder builder) {
        if (model.getParent() != null) {
            this.fullyQualifiedName(model.getParent(), builder);
            builder.append('.');
        }
        builder.append(model.getName());
        return builder.toString();
    }

    public MappingOperation<?, ?> getMapping(Model source, Model target) {
        return this.delegate.getMapping(source, target);
    }

    public List<MappingOperation<?, ?>> getMappings() {
        List mappings = this.delegate.getMappings();
        mappings.addAll(this.mappingPlaceholders);
        return mappings;
    }

    public List<MappingOperation<?, ?>> getMappingsForSource(Model source) {
        List mappings = this.delegate.getMappingsForSource(source);
        for (MappingOperation mappingOperation : this.mappingPlaceholders) {
            if (!source.equals(mappingOperation.getSource())) continue;
            mappings.add(mappingOperation);
        }
        return mappings;
    }

    public List<MappingOperation<?, ?>> getMappingsForTarget(Model target) {
        List mappings = this.delegate.getMappingsForTarget(target);
        for (MappingOperation mappingOperation : this.mappingPlaceholders) {
            if (!target.equals(mappingOperation.getTarget())) continue;
            mappings.add(mappingOperation);
        }
        return mappings;
    }

    public Model getSourceModel() {
        return this.delegate.getSourceModel();
    }

    public Model getTargetModel() {
        return this.delegate.getTargetModel();
    }

    public Variable getVariable(String variableName) {
        return this.delegate.getVariable(variableName);
    }

    public List<Variable> getVariables() {
        return this.delegate.getVariables();
    }

    public boolean hasMappingPlaceholders() {
        return !this.mappingPlaceholders.isEmpty();
    }

    public ExpressionMapping mapExpression(String language, String expression, Model target, List<Integer> targetIndexes) {
        ExpressionMapping mapping = this.delegate.mapExpression(language, expression, target, targetIndexes == null ? this.noIndexes(target) : targetIndexes);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public ExpressionMapping mapExpression(String language, String expression, Model target) {
        ExpressionMapping mapping = this.delegate.mapExpression(language, expression, target);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public FieldMapping mapField(Model source, Model target, List<Integer> sourceIndexes, List<Integer> targetIndexes) {
        FieldMapping mapping = this.delegate.mapField(source, target, sourceIndexes == null ? this.noIndexes(source) : sourceIndexes, targetIndexes == null ? this.noIndexes(target) : targetIndexes);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public FieldMapping mapField(Model source, Model target) {
        FieldMapping mapping = this.delegate.mapField(source, target);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public boolean mapped(Variable variable) {
        for (MappingOperation<?, ?> mapping : this.getMappings()) {
            if (!this.mappingContainsVariable(mapping, variable)) continue;
            return true;
        }
        return false;
    }

    public boolean mappingContainsVariable(MappingOperation<?, ?> mapping, Variable variable) {
        return mapping != null && mapping.getType() == MappingType.VARIABLE && ((Variable)((VariableMapping)mapping).getSource()).getName().equals(variable.getName());
    }

    public VariableMapping mapVariable(Variable variable, Model target, List<Integer> targetIndexes) {
        VariableMapping mapping = this.delegate.mapVariable(variable, target, targetIndexes == null ? this.noIndexes(target) : targetIndexes);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public VariableMapping mapVariable(Variable variable, Model target) {
        VariableMapping mapping = this.delegate.mapVariable(variable, target);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    public MappingPlaceholder newMapping() {
        MappingPlaceholder mapping = new MappingPlaceholder();
        this.mappingPlaceholders.add(mapping);
        this.fireEvent(MAPPING, null, mapping);
        return mapping;
    }

    private List<Integer> noIndexes(Model model) {
        if (model == null) {
            return null;
        }
        List<Integer> indexes = this.noIndexes(model.getParent());
        if (indexes == null) {
            return new ArrayList<Integer>();
        }
        indexes.add(null);
        return indexes;
    }

    public IProject project() {
        return this.file.getProject();
    }

    public void removeAllMappings() {
        throw new UnsupportedOperationException();
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeMapping(MappingOperation<?, ?> mapping) {
        if (mapping.getType() == null) {
            this.mappingPlaceholders.remove(mapping);
        } else {
            this.delegate.removeMapping(mapping);
        }
        this.fireEvent(MAPPING, mapping, null);
    }

    public boolean removeVariable(Variable variable) {
        for (MappingOperation<?, ?> mapping : this.getMappings()) {
            if (!this.mappingContainsVariable(mapping, variable)) continue;
            this.removeMapping(mapping);
        }
        boolean removed = this.delegate.removeVariable(variable);
        this.fireEvent(VARIABLE, variable, null);
        return removed;
    }

    public Model root(Model model) {
        return model.getParent() == null ? model : this.root(model.getParent());
    }

    public void save() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream stream = new FileOutputStream(new File(this.file.getLocationURI()));){
            this.saveConfig(stream);
            this.project().refreshLocal(2, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void saveConfig(OutputStream output) throws Exception {
        this.delegate.saveConfig(output);
    }

    public MappingOperation<?, ?> setSource(MappingOperation<?, ?> mapping, Object source, List<Integer> sourceIndexes, List<Integer> targetIndexes) {
        if (mapping.getType() == null) {
            ((MappingPlaceholder)mapping).setSource(source);
        }
        return this.update(mapping, source, sourceIndexes, (Model)mapping.getTarget(), targetIndexes, MAPPING_SOURCE);
    }

    public MappingOperation<?, ?> setSourceExpression(MappingOperation<?, ?> mapping, String language, String expression, List<Integer> targetIndexes) {
        if (mapping.getType() == null) {
            ((MappingPlaceholder)mapping).setSource(new ExpressionPlaceholder(language, expression));
        } else {
            this.delegate.removeMapping(mapping);
        }
        Model targetModel = (Model)mapping.getTarget();
        return this.update(mapping, language, expression, targetModel, targetIndexes, MAPPING_SOURCE);
    }

    public MappingOperation<?, ?> setTarget(MappingOperation<?, ?> mapping, Model target, List<Integer> sourceIndexes, List<Integer> targetIndexes) {
        if (mapping.getType() == null) {
            ((MappingPlaceholder)mapping).setTarget(target);
        }
        return this.update(mapping, mapping.getSource(), sourceIndexes, target, targetIndexes, MAPPING_TARGET);
    }

    public void setValue(Variable variable, String value) {
        variable.setValue(value);
        this.fireEvent(VARIABLE_VALUE, null, variable);
    }

    public FieldMapping uncustomizeMapping(CustomMapping customMapping) {
        this.delegate.removeMapping((MappingOperation)customMapping);
        FieldMapping fieldMapping = this.delegate.mapField((Model)customMapping.getSource(), (Model)customMapping.getTarget());
        this.fireEvent(MAPPING_CUSTOMIZE, customMapping, fieldMapping);
        return fieldMapping;
    }

    private MappingOperation<?, ?> update(MappingOperation<?, ?> mapping, Object source, List<Integer> sourceIndexes, Model target, List<Integer> targetIndexes, String eventType) {
        FieldMapping resultMapping;
        if (source == null || target == null) {
            resultMapping = mapping;
        } else {
            if (mapping.getType() == null) {
                this.mappingPlaceholders.remove(mapping);
            }
            if (source instanceof Model) {
                if (mapping.getType() != null) {
                    this.delegate.removeMapping(mapping);
                }
                Model sourceModel = (Model)source;
                if (sourceIndexes == null && targetIndexes == null) {
                    resultMapping = this.delegate.mapField(sourceModel, target);
                } else {
                    if (sourceIndexes == null) {
                        sourceIndexes = this.noIndexes(sourceModel);
                    }
                    if (targetIndexes == null) {
                        targetIndexes = this.noIndexes(target);
                    }
                    resultMapping = this.delegate.mapField(sourceModel, target, sourceIndexes, targetIndexes);
                }
                if (mapping.getType() == MappingType.CUSTOM) {
                    CustomMapping customMapping = (CustomMapping)mapping;
                    resultMapping = this.delegate.customizeMapping(resultMapping, customMapping.getMappingClass(), customMapping.getMappingOperation());
                }
            } else if (source instanceof Variable) {
                if (mapping.getType() == MappingType.VARIABLE && target.equals(mapping.getTarget())) {
                    resultMapping = mapping;
                    if (targetIndexes == null) {
                        ((VariableMapping)mapping).setVariable((Variable)source);
                    } else {
                        resultMapping = this.delegate.mapVariable((Variable)source, target, targetIndexes);
                    }
                } else {
                    if (mapping.getType() != null) {
                        this.delegate.removeMapping(mapping);
                    }
                    resultMapping = targetIndexes == null ? this.delegate.mapVariable((Variable)source, target) : this.delegate.mapVariable((Variable)source, target, targetIndexes);
                }
            } else {
                if (mapping.getType() != null) {
                    this.delegate.removeMapping(mapping);
                }
                Expression expression = (Expression)source;
                resultMapping = targetIndexes == null ? this.delegate.mapExpression(expression.getLanguage(), expression.getExpression(), target) : this.delegate.mapExpression(expression.getLanguage(), expression.getExpression(), target, targetIndexes);
            }
        }
        this.fireEvent(eventType, mapping, resultMapping);
        return resultMapping;
    }

    private MappingOperation<?, ?> update(MappingOperation<?, ?> mapping, String language, String expression, Model target, List<Integer> targetIndexes, String eventType) {
        ExpressionMapping resultMapping;
        if (target == null) {
            resultMapping = mapping;
        } else {
            if (mapping.getType() == null) {
                this.mappingPlaceholders.remove(mapping);
            }
            resultMapping = targetIndexes == null ? this.delegate.mapExpression(language, expression, target) : this.delegate.mapExpression(language, expression, target, targetIndexes);
        }
        this.fireEvent(eventType, mapping, resultMapping);
        return resultMapping;
    }
}

