/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class TestGenerator {
    private static final String SPRING_TEST_TEMPLATE = "templates/spring-test.template";
    private static final String BLUEPRINT_TEST_TEMPLATE = "templates/blueprint-test.template";
    private static final String ENDPOINT_KEY = "\\$\\[transform-id\\]";
    private static final String PACKAGE_KEY = "\\$\\[package-name\\]";
    private static final String CLASSNAME_KEY = "\\$\\[test-name\\]";
    private static final String FILENAME_KEY = "\\$\\[camel-name\\]";

    public static String createTransformTestText(String transformId, String packageName, String className, String fileName, boolean isSpring) throws Exception {
        String template = null;
        template = isSpring ? TestGenerator.readTemplate(SPRING_TEST_TEMPLATE).replaceAll(ENDPOINT_KEY, transformId).replaceAll(PACKAGE_KEY, packageName).replaceAll(CLASSNAME_KEY, className).replaceAll(FILENAME_KEY, fileName) : TestGenerator.readTemplate(BLUEPRINT_TEST_TEMPLATE).replaceAll(ENDPOINT_KEY, transformId).replaceAll(PACKAGE_KEY, packageName).replaceAll(CLASSNAME_KEY, className).replaceAll(FILENAME_KEY, fileName);
        if (packageName.isEmpty()) {
            template = template.replaceFirst("package ;", "");
        }
        return template;
    }

    private static String readTemplate(String template) throws Exception {
        StringBuilder templateStr = new StringBuilder();
        try (InputStreamReader reader = null;){
            InputStream is = TestGenerator.class.getClassLoader().getResourceAsStream(template);
            reader = new InputStreamReader(is, StandardCharsets.UTF_8);
            char[] buf = new char[1024];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                templateStr.append(buf, 0, count);
            }
        }
        return templateStr.toString();
    }
}

