/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class JavaUtil {
    public static ClassLoader getProjectClassLoader(IJavaProject javaProject, ClassLoader parentClassLoader) throws Exception {
        IProject project = javaProject.getProject();
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 2) {
                IPath projectPath = classpathEntry.getPath();
                IProject otherProject = root.getProject(projectPath.segment(0));
                IJavaProject otherJavaProject = JavaCore.create((IProject)otherProject);
                urls.add(new File(otherProject.getLocation() + "/" + otherJavaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
            } else if (classpathEntry.getEntryKind() == 1) {
                urls.add(new File(classpathEntry.getPath().toOSString()).toURI().toURL());
            }
            ++n2;
        }
        if (parentClassLoader == null) {
            return new URLClassLoader(urls.toArray(new URL[urls.size()]));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parentClassLoader);
    }

    private JavaUtil() {
    }

    public static IJavaElement getInitialPackageForProject(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IPackageFragmentRoot sourceRoot = JavaUtil.getFirstJavaSourceRoot(project);
            if (sourceRoot == null) {
                return project;
            }
            IJavaElement[] packages = sourceRoot.getChildren();
            IPackageFragmentRoot element = sourceRoot;
            int i = 0;
            while (i < packages.length) {
                IPackageFragment frag = (IPackageFragment)packages[i];
                element = frag;
                if (!(frag.isDefaultPackage() || frag.hasSubpackages() && !frag.containsJavaResources())) {
                    element = frag;
                    break;
                }
                ++i;
            }
            return element;
        }
        catch (JavaModelException javaModelException) {
            return project;
        }
    }

    public static IResource getFirstResourceRoot(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IResource sourceRoot = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot frag = iPackageFragmentRootArray[n2];
                if (frag.getKind() == 1) {
                    sourceRoot = frag.getUnderlyingResource();
                    break;
                }
                ++n2;
            }
            return sourceRoot;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static IPackageFragmentRoot getFirstJavaSourceRoot(IJavaProject project) {
        if (project == null) {
            return null;
        }
        try {
            IPackageFragmentRoot sourceRoot = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot frag = iPackageFragmentRootArray[n2];
                if (frag.getKind() == 1) {
                    sourceRoot = frag;
                    break;
                }
                ++n2;
            }
            return sourceRoot;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static boolean addFolderToProjectClasspath(IJavaProject javaProject, IResource folder) {
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            IPath srcPath = javaProject.getPath().append(folder.getProjectRelativePath());
            IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
            newEntries[entries.length] = JavaCore.newSourceEntry((IPath)srcEntry.getPath());
            javaProject.setRawClasspath(newEntries, null);
            return true;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findFolderOnProjectClasspath(IJavaProject javaProject, IResource folder) {
        try {
            IClasspathEntry[] entries;
            IPath srcPath = javaProject.getPath().append(folder.getProjectRelativePath());
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)srcPath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public static String[] getSourceComplianceLevels(IJavaElement context) {
        IJavaProject javaProject;
        if (context != null && (javaProject = context.getJavaProject()) != null) {
            return new String[]{javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)};
        }
        return new String[]{JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance")};
    }

    public static IStatus validatePackageName(String name, IJavaElement context) {
        String[] sourceComplianceLevels = JavaUtil.getSourceComplianceLevels(context);
        return JavaConventions.validatePackageName((String)name, (String)sourceComplianceLevels[0], (String)sourceComplianceLevels[1]);
    }

    public static IStatus validateClassFileName(String name, IJavaElement context) {
        String[] sourceComplianceLevels = JavaUtil.getSourceComplianceLevels(context);
        return JavaConventions.validateJavaTypeName((String)name, (String)sourceComplianceLevels[0], (String)sourceComplianceLevels[1]);
    }

    public static IPath getJavaPathForResource(IResource resource) {
        if (resource == null || resource.getType() == 4 || resource.getType() == 8) {
            return null;
        }
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (project == null) {
            return resource.getFullPath().removeFirstSegments(1);
        }
        IResource container = resource;
        if (container.getType() == 1) {
            container = container.getParent();
        }
        IJavaElement element = null;
        while (element == null && container != null) {
            element = JavaCore.create((IResource)container, (IJavaProject)project);
            container = container.getParent();
        }
        if (element == null) {
            return resource.getFullPath().removeFirstSegments(1);
        }
        if (element.getElementType() == 4) {
            return resource.getFullPath().makeRelativeTo(element.getParent().getPath());
        }
        return resource.getFullPath().makeRelativeTo(element.getPath());
    }
}

