/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jboss.tools.fuse.transformation.editor.internal.util.BaseDialog;
import org.jboss.tools.fuse.transformation.model.Model;

class IndexesDialog
extends BaseDialog {
    final Model model;
    final boolean sourceModel;
    final List<Integer> indexes = new ArrayList<Integer>();

    IndexesDialog(Shell shell, Model model, boolean sourceModel) {
        super(shell);
        this.model = model;
        this.sourceModel = sourceModel;
    }

    @Override
    protected void constructContents(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.constructRow(parent, this.model);
    }

    private int constructRow(Composite parent, Model model) {
        if (model == null) {
            return -1;
        }
        final int level = this.constructRow(parent, model.getParent());
        if (level >= 0) {
            this.indexes.add(model.isCollection() ? Integer.valueOf(0) : null);
        }
        Label nameLabel = new Label(parent, 0);
        StringBuilder builder = new StringBuilder();
        int ndx = level + 1;
        while (--ndx >= 0) {
            builder.append("    ");
        }
        builder.append(model.getName());
        nameLabel.setText(builder.toString());
        if (model.isCollection()) {
            final Spinner spinner = new Spinner(parent, 2048);
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    IndexesDialog.this.indexes.set(level, spinner.getSelection());
                }
            });
        } else {
            new Label(parent, 0);
        }
        return level + 1;
    }

    @Override
    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
    }

    @Override
    protected String message() {
        return "Specify the index(es) for the collection(s) containing the " + (this.sourceModel ? "source" : "target") + " attribute.";
    }

    @Override
    protected String title() {
        return "Collection Indexes";
    }
}

