/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.util;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelFileTypeHelper;

class CamelResourceClasspathSelectionDialog
extends FilteredResourcesSelectionDialog {
    Set<String> fileExtensions;
    IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    CamelResourceClasspathSelectionDialog(Shell parentShell, IContainer container, Set<String> fileExtensions, String title) {
        super(parentShell, false, container, 1);
        this.fileExtensions = fileExtensions == null ? Collections.emptySet() : fileExtensions;
        this.setTitle(title);
    }

    CamelResourceClasspathSelectionDialog(Shell parentShell, IContainer container, String title) {
        this(parentShell, container, Collections.emptySet(), title);
    }

    CamelResourceClasspathSelectionDialog(Shell parentShell, IContainer container, String fileExtension, String title) {
        this(parentShell, container, fileExtension == null ? Collections.emptySet() : Collections.singleton(fileExtension), title);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new CamelResourceFilter();
    }

    class CamelResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        CamelResourceFilter() {
            super((FilteredResourcesSelectionDialog)CamelResourceClasspathSelectionDialog.this);
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return filter instanceof CamelResourceFilter && super.equalsFilter(filter);
        }

        private boolean fileIsSupportedCamel(Object item) {
            try {
                IResource resource = (IResource)item;
                File testFile = new File(resource.getLocationURI());
                if (testFile.exists()) {
                    boolean isValidCamel = CamelFileTypeHelper.isSupportedCamelFile(resource.getProject(), resource.getProjectRelativePath().toPortableString());
                    return isValidCamel;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        private boolean isParentOnClassPath(IJavaProject javaProject, IResource resource) {
            boolean flag = false;
            while (!flag && resource.getParent() != null) {
                flag = javaProject.isOnClasspath(resource);
                if (!flag) {
                    resource = resource.getParent();
                    continue;
                }
                return flag;
            }
            return flag;
        }

        public boolean matchItem(Object item) {
            IResource resource = (IResource)item;
            return super.matchItem(item) && (CamelResourceClasspathSelectionDialog.this.fileExtensions == null || CamelResourceClasspathSelectionDialog.this.fileExtensions.isEmpty() || CamelResourceClasspathSelectionDialog.this.fileExtensions.contains(resource.getFullPath().getFileExtension())) && this.select(resource);
        }

        private boolean select(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                boolean isSupported = this.fileIsSupportedCamel(resource);
                return javaProject != null && this.isParentOnClassPath(javaProject, resource) && isSupported || project.getNature("org.eclipse.jdt.core.javanature") != null && CamelResourceClasspathSelectionDialog.this.fJavaModel.contains(resource) && isSupported;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
    }
}

