/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.dozer;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.jboss.tools.fuse.transformation.editor.internal.dozer.DozerFileTypeHelper;

public class DozerResourceClasspathSelectionDialog
extends FilteredResourcesSelectionDialog {
    Set<String> fileExtensions;
    IJavaModel fJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());

    DozerResourceClasspathSelectionDialog(Shell parentShell, IContainer container, Set<String> fileExtensions, String title) {
        super(parentShell, false, container, 1);
        this.fileExtensions = fileExtensions == null ? Collections.emptySet() : fileExtensions;
        this.setTitle(title);
    }

    public DozerResourceClasspathSelectionDialog(Shell parentShell, IContainer container, String title) {
        this(parentShell, container, Collections.emptySet(), title);
    }

    DozerResourceClasspathSelectionDialog(Shell parentShell, IContainer container, String fileExtension, String title) {
        this(parentShell, container, fileExtension == null ? Collections.emptySet() : Collections.singleton(fileExtension), title);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new DozerResourceFilter();
    }

    class DozerResourceFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        DozerResourceFilter() {
            super((FilteredResourcesSelectionDialog)DozerResourceClasspathSelectionDialog.this);
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return filter instanceof DozerResourceFilter && super.equalsFilter(filter);
        }

        private boolean fileIsSupportedDozer(Object item) {
            try {
                IResource resource = (IResource)item;
                File testFile = new File(resource.getLocationURI());
                if (testFile.exists()) {
                    boolean isValidDozer = DozerFileTypeHelper.isDozerFile(resource.getProject(), resource.getProjectRelativePath().toPortableString());
                    return isValidDozer;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        private boolean isParentOnClassPath(IJavaProject javaProject, IResource resource) {
            boolean flag = false;
            while (!flag && resource.getParent() != null) {
                flag = javaProject.isOnClasspath(resource);
                if (!flag) {
                    resource = resource.getParent();
                    continue;
                }
                return flag;
            }
            return flag;
        }

        public boolean matchItem(Object item) {
            IResource resource = (IResource)item;
            return super.matchItem(item) && (DozerResourceClasspathSelectionDialog.this.fileExtensions == null || DozerResourceClasspathSelectionDialog.this.fileExtensions.isEmpty() || DozerResourceClasspathSelectionDialog.this.fileExtensions.contains(resource.getFullPath().getFileExtension())) && this.select(resource);
        }

        private boolean select(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                boolean isSupported = this.fileIsSupportedDozer(resource);
                return javaProject != null && this.isParentOnClassPath(javaProject, resource) && isSupported || project.getNature("org.eclipse.jdt.core.javanature") != null && DozerResourceClasspathSelectionDialog.this.fJavaModel.contains(resource) && isSupported;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
    }
}

