/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.dozer;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.fusesource.ide.commons.contenttype.XmlMatchingStrategySupport;
import org.jboss.tools.fuse.transformation.editor.internal.dozer.DozerXmlMatchingStrategy;

public final class DozerFileTypeHelper {
    private static XmlMatchingStrategySupport dozerXmlMatcher = new DozerXmlMatchingStrategy();

    public static boolean isDozerFile(IProject project, String filePath) {
        return DozerFileTypeHelper.fileMatches(project, filePath, dozerXmlMatcher);
    }

    private static boolean fileMatches(IProject project, String filePath, XmlMatchingStrategySupport matcher) {
        boolean matches = false;
        if (filePath != null && filePath.trim().length() > 0) {
            String rawPath = null;
            if (filePath.startsWith("file:")) {
                rawPath = filePath.substring(5);
            } else {
                IPath wholePath = project.getLocation().append(filePath);
                rawPath = wholePath.toPortableString();
            }
            Path fp = new Path(rawPath);
            File nf = new File(fp.toOSString());
            if (nf.exists() && nf.isFile()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)nf.getAbsolutePath());
                IFile file = workspace.getRoot().getFileForLocation(location);
                matches = matcher.matches(file);
            }
        }
        return matches;
    }
}

