/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.fuse.transformation.Variable;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.TransformationConfig;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

public final class VariablesViewer
extends Composite {
    final TableViewer tableViewer;

    public VariablesViewer(final TransformationConfig config, Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.setBackground(parent.getParent().getParent().getBackground());
        ToolBar toolBar = new ToolBar((Composite)this, 0);
        ToolItem addButton = new ToolItem(toolBar, 8);
        addButton.setImage(new DecorationOverlayIcon(Util.Images.VARIABLE, Util.Decorations.ADD, 1).createImage());
        addButton.setToolTipText("Add a new variable");
        final ToolItem deleteButton = new ToolItem(toolBar, 8);
        deleteButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        deleteButton.setToolTipText("Delete the selected variable(s)");
        deleteButton.setEnabled(false);
        this.tableViewer = new TableViewer((Composite)this);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tableViewer.setComparator(new ViewerComparator());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final TableViewerColumn nameColumn = new TableViewerColumn(this.tableViewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setImage(Util.Images.VARIABLE);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Color getForeground(Object element) {
                return Util.Colors.VARIABLE;
            }

            public Image getImage(Object element) {
                Image img = Util.Images.VARIABLE;
                if (config.mapped((Variable)element)) {
                    return new DecorationOverlayIcon(img, Util.Decorations.MAPPED, 3).createImage();
                }
                return img;
            }

            public String getText(Object element) {
                return ((Variable)element).getName();
            }
        });
        final TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "\"" + ((Variable)element).getValue() + "\"";
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){
            private final TextCellEditor cellEditor;
            {
                super($anonymous0);
                this.cellEditor = new TextCellEditor((Composite)VariablesViewer.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.cellEditor;
            }

            protected Object getValue(Object element) {
                return ((Variable)element).getValue();
            }

            protected void setValue(Object element, Object value) {
                Variable variable = (Variable)element;
                config.setValue(variable, value.toString());
                try {
                    config.save();
                    VariablesViewer.this.tableViewer.setInput(config.getVariables());
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
        });
        this.tableViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(VariablesViewer.this.tableViewer.getSelection());
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputDialog dlg = new InputDialog(VariablesViewer.this.getShell(), "Add Variable", "Enter a new variable name", null, new IInputValidator(){

                    public String isValid(String text) {
                        for (Variable variable : config.getVariables()) {
                            if (!variable.getName().equals(text)) continue;
                            return "Variable already exists";
                        }
                        return null;
                    }
                });
                if (dlg.open() != 0) {
                    return;
                }
                config.addVariable(dlg.getValue(), dlg.getValue());
                try {
                    config.save();
                    VariablesViewer.this.tableViewer.setInput(config.getVariables());
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean deleteAll = false;
                try {
                    for (Variable variable : (IStructuredSelection)VariablesViewer.this.tableViewer.getSelection()) {
                        if (config.mapped(variable) && !deleteAll) {
                            MessageDialog dlg = new MessageDialog(VariablesViewer.this.getShell(), "Confirm", null, "Variable \"" + variable.getName() + "\" is being used in one or more mappings.\n\n" + "Are you sure you want to delete it?", 4, new String[]{"Cancel", "Yes", "Yes For All", "No"}, 3);
                            int button = dlg.open();
                            if (button == 2) {
                                deleteAll = true;
                            } else {
                                if (button == 3) continue;
                                if (button < 1) {
                                    return;
                                }
                            }
                        }
                        config.removeVariable(variable);
                        VariablesViewer.this.tableViewer.remove((Object)variable);
                    }
                    config.save();
                    VariablesViewer.this.tableViewer.setInput(config.getVariables());
                }
                catch (Exception e) {
                    Activator.error(e);
                }
            }
        });
        this.tableViewer.setInput(config.getVariables());
        this.tableViewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int width = VariablesViewer.this.tableViewer.getTable().getSize().x / 2;
                nameColumn.getColumn().setWidth(width);
                valueColumn.getColumn().setWidth(width);
            }
        });
    }
}

